/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.async;

import com.google.bigtable.repackaged.com.google.api.core.ApiClock;
import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.bigtable.v2.MutateRowsRequest;
import com.google.bigtable.repackaged.com.google.bigtable.v2.MutateRowsResponse;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.config.RetryOptions;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.DeadlineGenerator;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.async.AbstractRetryingOperation;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.async.BigtableAsyncRpc;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.async.MutateRowsRequestManager;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableMap;
import com.google.bigtable.repackaged.io.grpc.Metadata;
import com.google.bigtable.repackaged.io.grpc.Status;
import com.google.bigtable.repackaged.io.opencensus.trace.AttributeValue;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;

@InternalApi(value="For internal usage only")
public class RetryingMutateRowsOperation
extends AbstractRetryingOperation<MutateRowsRequest, MutateRowsResponse, List<MutateRowsResponse>> {
    private static final Status INVALID_RESPONSE = Status.INTERNAL.withDescription("The server returned an invalid response");
    private final MutateRowsRequestManager requestManager;

    public RetryingMutateRowsOperation(RetryOptions retryOptions, MutateRowsRequest originalRequest, BigtableAsyncRpc<MutateRowsRequest, MutateRowsResponse> retryableRpc, DeadlineGenerator deadlineGenerator, ScheduledExecutorService retryExecutorService, Metadata originalMetadata, ApiClock clock) {
        super(retryOptions, originalRequest, retryableRpc, deadlineGenerator, retryExecutorService, originalMetadata, clock);
        this.requestManager = new MutateRowsRequestManager(retryOptions, originalRequest);
        this.operationSpan.addAnnotation("MutationCount", ImmutableMap.of("count", AttributeValue.longAttributeValue(originalRequest.getEntriesCount())));
    }

    @Override
    public void onMessage(MutateRowsResponse message) {
        try {
            this.requestManager.onMessage(message);
        }
        catch (Exception e) {
            this.setException(e);
        }
    }

    @Override
    protected MutateRowsRequest getRetryRequest() {
        return this.requestManager.getRetryRequest();
    }

    @Override
    protected boolean onOK(Metadata trailers) {
        MutateRowsRequestManager.ProcessingStatus status = this.requestManager.onOK();
        if (status == MutateRowsRequestManager.ProcessingStatus.INVALID) {
            this.onError(INVALID_RESPONSE, trailers);
            return true;
        }
        if (status == MutateRowsRequestManager.ProcessingStatus.SUCCESS || status == MutateRowsRequestManager.ProcessingStatus.NOT_RETRYABLE) {
            this.completionFuture.set(Arrays.asList(this.requestManager.buildResponse()));
            return true;
        }
        Long nextBackOff = this.getNextBackoff();
        if (nextBackOff == null) {
            this.rpc.getRpcMetrics().markRetriesExhasted();
            this.completionFuture.set(Arrays.asList(this.requestManager.buildResponse()));
            this.operationSpan.addAnnotation("MutationCount", ImmutableMap.of("failureCount", AttributeValue.longAttributeValue(this.requestManager.getRetryRequest().getEntriesCount())));
            return true;
        }
        this.performRetry(nextBackOff);
        this.operationSpan.addAnnotation("MutationCount", ImmutableMap.of("retryCount", AttributeValue.longAttributeValue(this.requestManager.getRetryRequest().getEntriesCount())));
        return false;
    }
}

