/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.async;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.async.ResourceLimiter;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.protobuf.MessageLite;
import com.google.bigtable.repackaged.io.grpc.CallOptions;
import com.google.bigtable.repackaged.io.grpc.Channel;
import com.google.bigtable.repackaged.io.grpc.ClientCall;
import com.google.bigtable.repackaged.io.grpc.ClientInterceptor;
import com.google.bigtable.repackaged.io.grpc.ForwardingClientCallListener;
import com.google.bigtable.repackaged.io.grpc.Metadata;
import com.google.bigtable.repackaged.io.grpc.MethodDescriptor;
import com.google.bigtable.repackaged.io.grpc.Status;
import com.google.bigtable.repackaged.javax.annotation.Nullable;
import java.util.concurrent.CancellationException;

@InternalApi(value="For internal usage only")
public class ThrottlingClientInterceptor
implements ClientInterceptor {
    private final ResourceLimiter resourceLimiter;

    public ThrottlingClientInterceptor(ResourceLimiter resourceLimiter) {
        Preconditions.checkNotNull(resourceLimiter);
        this.resourceLimiter = resourceLimiter;
    }

    @Override
    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(final MethodDescriptor<ReqT, RespT> method, final CallOptions callOptions, final Channel delegateChannel) {
        if (this.resourceLimiter == null) {
            return delegateChannel.newCall(method, callOptions);
        }
        return new ClientCall<ReqT, RespT>(){
            private boolean cancelledEarly;
            private ClientCall.Listener<RespT> delegateListener = null;
            private ClientCall<ReqT, RespT> delegateCall;
            private Metadata headers;
            private int numMessagesRequested = 0;
            private Long id = null;

            @Override
            public void start(ClientCall.Listener<RespT> listener, Metadata headers) {
                Preconditions.checkState(!this.cancelledEarly, "Call already cancelled");
                Preconditions.checkState(this.delegateListener == null && this.headers == null, "Call already started");
                this.delegateListener = Preconditions.checkNotNull(listener);
                this.headers = Preconditions.checkNotNull(headers);
            }

            @Override
            public void request(int numMessages) {
                if (this.delegateCall != null) {
                    this.delegateCall.request(numMessages);
                    return;
                }
                Preconditions.checkState(!this.cancelledEarly, "Call already cancelled");
                this.numMessagesRequested += numMessages;
            }

            @Override
            public void cancel(@Nullable String message, @Nullable Throwable cause) {
                if (this.delegateCall != null) {
                    this.delegateCall.cancel(message, cause);
                    return;
                }
                this.cancelledEarly = true;
                if (message == null && cause == null) {
                    cause = new CancellationException("Cancelled without a message or cause");
                }
                if (this.delegateListener != null) {
                    this.delegateListener.onClose(Status.CANCELLED.withDescription(message).withCause(cause), new Metadata());
                }
            }

            @Override
            public void sendMessage(ReqT message) {
                Preconditions.checkState(this.delegateCall == null, "ThrottlingClientInterceptor only supports unary operations");
                Preconditions.checkState(this.delegateListener != null && this.headers != null, "start() has to be called before sendMessage().");
                Preconditions.checkState(!this.cancelledEarly, "Call already cancelled");
                try {
                    this.id = ThrottlingClientInterceptor.this.resourceLimiter.registerOperationWithHeapSize(((MessageLite)message).getSerializedSize());
                }
                catch (InterruptedException e) {
                    this.delegateListener.onClose(Status.INTERNAL.withDescription("Operation was interrupted"), new Metadata());
                    return;
                }
                this.delegateCall = delegateChannel.newCall(method, callOptions);
                ForwardingClientCallListener.SimpleForwardingClientCallListener markCompletionListener = new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(this.delegateListener){

                    @Override
                    public void onClose(Status status, Metadata trailers) {
                        ThrottlingClientInterceptor.this.resourceLimiter.markCanBeCompleted(id);
                        this.delegate().onClose(status, trailers);
                    }
                };
                this.delegateCall.start(markCompletionListener, this.headers);
                this.delegateCall.request(this.numMessagesRequested);
                this.delegateCall.sendMessage(message);
                this.delegateCall.halfClose();
            }

            @Override
            public void halfClose() {
            }
        };
    }
}

