/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.io;

import com.google.bigtable.repackaged.com.google.api.client.util.Clock;
import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.auth.oauth2.AccessToken;
import com.google.bigtable.repackaged.com.google.auth.oauth2.OAuth2Credentials;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.config.Logger;
import com.google.bigtable.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.Futures;
import com.google.bigtable.repackaged.io.grpc.Status;
import com.google.bigtable.repackaged.io.opencensus.common.Scope;
import com.google.bigtable.repackaged.io.opencensus.contrib.grpc.util.StatusConverter;
import com.google.bigtable.repackaged.io.opencensus.trace.Span;
import com.google.bigtable.repackaged.io.opencensus.trace.Tracer;
import com.google.bigtable.repackaged.io.opencensus.trace.Tracing;
import com.google.bigtable.repackaged.javax.annotation.concurrent.GuardedBy;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

@InternalApi(value="For internal usage only")
public class OAuthCredentialsCache {
    private static final Logger LOG = new Logger(OAuthCredentialsCache.class);
    private static final Tracer TRACER = Tracing.getTracer();
    private static final HeaderCacheElement EMPTY_HEADER = new HeaderCacheElement(null, 0L);
    @VisibleForTesting
    static Clock clock = Clock.SYSTEM;
    private final ExecutorService executor;
    private final OAuth2Credentials credentials;
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    private Future<HeaderCacheElement> futureToken = null;
    @GuardedBy(value="lock")
    private volatile HeaderCacheElement headerCache = EMPTY_HEADER;

    public OAuthCredentialsCache(ExecutorService scheduler, OAuth2Credentials credentials) {
        this.executor = Preconditions.checkNotNull(scheduler);
        this.credentials = Preconditions.checkNotNull(credentials);
    }

    @VisibleForTesting
    HeaderCacheElement getHeaderCache() {
        return this.headerCache;
    }

    HeaderToken getHeader(long timeout, TimeUnit timeUnit) {
        try {
            return this.getHeaderUnsafe(timeout, timeUnit).getToken();
        }
        catch (Exception e) {
            LOG.warn("Got an unexpected exception while trying to refresh google credentials.", e, new Object[0]);
            Status status = Status.UNAUTHENTICATED.withDescription("Unexpected failure get auth token").withCause(e);
            return new HeaderToken(status, null);
        }
    }

    @VisibleForTesting
    HeaderCacheElement getHeaderUnsafe(long timeout, TimeUnit timeUnit) {
        HeaderCacheElement headerCacheUnsync = this.headerCache;
        switch (headerCacheUnsync.getCacheState()) {
            case Good: {
                return headerCacheUnsync;
            }
            case Stale: {
                this.asyncRefresh();
                return headerCacheUnsync;
            }
            case Expired: 
            case Exception: {
                return this.syncRefresh(timeout, timeUnit);
            }
        }
        String message = "Could not process state: " + (Object)((Object)headerCacheUnsync.getCacheState());
        LOG.warn(message, new Object[0]);
        return new HeaderCacheElement(Status.UNAUTHENTICATED.withCause(new IllegalStateException(message)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private HeaderCacheElement syncRefresh(long timeout, TimeUnit timeUnit) {
        Span span = TRACER.spanBuilder("Bigtable.CredentialsRefresh").startSpan();
        try {
            HeaderCacheElement headerCacheElement;
            Throwable throwable;
            Scope scope;
            block23: {
                block24: {
                    scope = TRACER.withSpan(span);
                    throwable = null;
                    headerCacheElement = this.asyncRefresh().get(timeout, timeUnit);
                    if (scope == null) break block23;
                    if (throwable == null) break block24;
                    try {
                        scope.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block23;
                }
                scope.close();
            }
            return headerCacheElement;
            catch (Throwable throwable3) {
                Status status;
                try {
                    try {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (scope != null) {
                            if (throwable != null) {
                                try {
                                    scope.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                scope.close();
                            }
                        }
                        throw throwable4;
                    }
                }
                catch (InterruptedException e) {
                    LOG.warn("Interrupted while trying to refresh google credentials.", e, new Object[0]);
                    status = Status.UNAUTHENTICATED.withDescription("Authentication was interrupted.").withCause(e);
                    span.setStatus(StatusConverter.fromGrpcStatus(status));
                    Thread.currentThread().interrupt();
                    HeaderCacheElement headerCacheElement2 = new HeaderCacheElement(status);
                    return headerCacheElement2;
                }
                catch (ExecutionException e) {
                    LOG.warn("ExecutionException while trying to refresh google credentials.", e, new Object[0]);
                    status = Status.UNAUTHENTICATED.withDescription("ExecutionException during Authentication.").withCause(e);
                    span.setStatus(StatusConverter.fromGrpcStatus(status));
                    HeaderCacheElement headerCacheElement3 = new HeaderCacheElement(status);
                    return headerCacheElement3;
                }
                catch (TimeoutException e) {
                    LOG.warn("TimeoutException while trying to refresh google credentials.", e, new Object[0]);
                    status = Status.UNAUTHENTICATED.withDescription("TimeoutException during Authentication.").withCause(e);
                    span.setStatus(StatusConverter.fromGrpcStatus(status));
                    HeaderCacheElement headerCacheElement4 = new HeaderCacheElement(status);
                    return headerCacheElement4;
                }
                catch (Exception e) {
                    LOG.warn("Unexpected exception while trying to refresh google credentials.", e, new Object[0]);
                    status = Status.UNAUTHENTICATED.withDescription("Unexpected exception during Authentication.").withCause(e);
                    span.setStatus(StatusConverter.fromGrpcStatus(status));
                    HeaderCacheElement headerCacheElement5 = new HeaderCacheElement(status);
                    return headerCacheElement5;
                }
            }
        }
        finally {
            span.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Future<HeaderCacheElement> asyncRefresh() {
        LOG.trace("asyncRefresh", new Object[0]);
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.futureToken != null) {
                    return this.futureToken;
                }
                if (this.headerCache.getCacheState() == CacheState.Good) {
                    return Futures.immediateFuture(this.headerCache);
                }
                Future<HeaderCacheElement> future = this.executor.submit(new Callable<HeaderCacheElement>(){

                    @Override
                    public HeaderCacheElement call() {
                        return OAuthCredentialsCache.this.updateToken();
                    }
                });
                if (!future.isDone()) {
                    this.futureToken = future;
                }
                return future;
            }
            catch (RuntimeException e) {
                this.futureToken = null;
                LOG.warn("Got an unexpected exception while trying to refresh google credentials.", e, new Object[0]);
                return Futures.immediateFuture(new HeaderCacheElement(Status.UNAUTHENTICATED.withDescription("Unexpected error trying to authenticate").withCause(e)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HeaderCacheElement updateToken() {
        HeaderCacheElement newToken;
        try {
            LOG.info("Refreshing the OAuth token", new Object[0]);
            newToken = new HeaderCacheElement(this.credentials.refreshAccessToken());
        }
        catch (Exception e) {
            LOG.warn("Got an unexpected exception while trying to refresh google credentials.", e, new Object[0]);
            newToken = new HeaderCacheElement(Status.UNAUTHENTICATED.withDescription("Unexpected error trying to authenticate").withCause(e));
        }
        Object object = this.lock;
        synchronized (object) {
            if (newToken.isValid() || !this.headerCache.isValid()) {
                this.headerCache = newToken;
            } else {
                LOG.warn("Failed to refresh the access token. Falling back to existing token. New token state: {}, status: {}", new Object[]{newToken.getCacheState(), newToken.getToken().status});
            }
            this.futureToken = null;
            return this.headerCache;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void revokeUnauthToken(HeaderToken oldToken) {
        Object object = this.lock;
        synchronized (object) {
            if (this.headerCache.getToken() == oldToken) {
                LOG.warn("Got unauthenticated response from server, revoking the current token", new Object[0]);
                this.headerCache = EMPTY_HEADER;
            } else {
                LOG.info("Skipping revoke, since the revoked token has already changed", new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    boolean isRefreshing() {
        Object object = this.lock;
        synchronized (object) {
            return this.futureToken != null;
        }
    }

    static class HeaderCacheElement {
        static final long TOKEN_STALENESS_MS = TimeUnit.MINUTES.toMillis(6L);
        static final long TOKEN_EXPIRES_MS = TimeUnit.MINUTES.toMillis(5L);
        private final HeaderToken token;
        private final long actualExpirationTimeMs;

        private HeaderCacheElement(AccessToken token) {
            this.actualExpirationTimeMs = token.getExpirationTime() == null ? Long.MAX_VALUE : token.getExpirationTime().getTime();
            this.token = new HeaderToken(Status.OK, "Bearer " + token.getTokenValue());
        }

        private HeaderCacheElement(String header, long actualExpirationTimeMs) {
            this.token = new HeaderToken(Status.OK, header);
            this.actualExpirationTimeMs = actualExpirationTimeMs;
        }

        private HeaderCacheElement(Status errorStatus) {
            Preconditions.checkArgument(!errorStatus.isOk(), "Error status can't be OK");
            this.token = new HeaderToken(errorStatus, null);
            this.actualExpirationTimeMs = 0L;
        }

        CacheState getCacheState() {
            long now = clock.currentTimeMillis();
            if (!this.token.status.isOk()) {
                return CacheState.Exception;
            }
            if (this.actualExpirationTimeMs - TOKEN_EXPIRES_MS <= now) {
                return CacheState.Expired;
            }
            if (this.actualExpirationTimeMs - TOKEN_STALENESS_MS <= now) {
                return CacheState.Stale;
            }
            return CacheState.Good;
        }

        private boolean isValid() {
            return this.getCacheState().isValid();
        }

        HeaderToken getToken() {
            return this.token;
        }
    }

    static class HeaderToken {
        private final Status status;
        private final String header;

        public HeaderToken(Status status, String header) {
            this.status = status;
            this.header = header;
        }

        Status getStatus() {
            return this.status;
        }

        String getHeader() {
            return this.header;
        }
    }

    @VisibleForTesting
    static enum CacheState {
        Good(true),
        Stale(true),
        Expired(false),
        Exception(false);

        private boolean isValid;

        private CacheState(boolean isValid) {
            this.isValid = isValid;
        }

        public boolean isValid() {
            return this.isValid;
        }
    }
}

