/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.io;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.auth.oauth2.OAuth2Credentials;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.config.Logger;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.io.OAuthCredentialsCache;
import com.google.bigtable.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.RateLimiter;
import com.google.bigtable.repackaged.io.grpc.CallOptions;
import com.google.bigtable.repackaged.io.grpc.Channel;
import com.google.bigtable.repackaged.io.grpc.ClientCall;
import com.google.bigtable.repackaged.io.grpc.ClientInterceptor;
import com.google.bigtable.repackaged.io.grpc.ForwardingClientCall;
import com.google.bigtable.repackaged.io.grpc.ForwardingClientCallListener;
import com.google.bigtable.repackaged.io.grpc.Metadata;
import com.google.bigtable.repackaged.io.grpc.MethodDescriptor;
import com.google.bigtable.repackaged.io.grpc.Status;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;

@InternalApi(value="For internal usage only")
public class RefreshingOAuth2CredentialsInterceptor
implements ClientInterceptor {
    private static final Logger LOG = new Logger(RefreshingOAuth2CredentialsInterceptor.class);
    @VisibleForTesting
    static final long TIMEOUT_MILLISECONDS = TimeUnit.SECONDS.toMillis(15L);
    @VisibleForTesting
    static final Metadata.Key<String> AUTHORIZATION_HEADER_KEY = Metadata.Key.of("Authorization", Metadata.ASCII_STRING_MARSHALLER);
    private final OAuthCredentialsCache store;
    private final RateLimiter rateLimiter;

    public RefreshingOAuth2CredentialsInterceptor(ExecutorService scheduler, OAuth2Credentials credentials) {
        this(new OAuthCredentialsCache(scheduler, credentials));
    }

    @VisibleForTesting
    RefreshingOAuth2CredentialsInterceptor(OAuthCredentialsCache store) {
        this.store = store;
        this.rateLimiter = RateLimiter.create(0.1);
    }

    @Override
    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, final CallOptions callOptions, Channel next) {
        return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){
            private volatile boolean unauthorized;
            {
                super(x0);
                this.unauthorized = false;
            }

            @Override
            public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                long timeout = callOptions.getDeadline() != null ? callOptions.getDeadline().timeRemaining(TimeUnit.MILLISECONDS) : TIMEOUT_MILLISECONDS;
                OAuthCredentialsCache.HeaderToken token = RefreshingOAuth2CredentialsInterceptor.this.store.getHeader(timeout, TimeUnit.MILLISECONDS);
                if (!token.getStatus().isOk()) {
                    this.unauthorized = true;
                    responseListener.onClose(token.getStatus(), new Metadata());
                    return;
                }
                headers.put(AUTHORIZATION_HEADER_KEY, token.getHeader());
                this.delegate().start(new UnAuthResponseListener(responseListener, token), headers);
            }

            @Override
            public void request(int numMessages) {
                if (!this.unauthorized) {
                    this.delegate().request(numMessages);
                }
            }

            @Override
            public void sendMessage(ReqT message) {
                if (!this.unauthorized) {
                    this.delegate().sendMessage(message);
                }
            }

            @Override
            public void halfClose() {
                if (!this.unauthorized) {
                    this.delegate().halfClose();
                }
            }

            @Override
            public void cancel(String message, Throwable cause) {
                if (!this.unauthorized) {
                    this.delegate().cancel(message, cause);
                }
            }
        };
    }

    void asyncRefresh() {
        this.store.asyncRefresh();
    }

    private class UnAuthResponseListener<RespT>
    extends ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT> {
        private final OAuthCredentialsCache.HeaderToken origToken;

        private UnAuthResponseListener(ClientCall.Listener<RespT> delegate, OAuthCredentialsCache.HeaderToken origToken) {
            super(delegate);
            this.origToken = origToken;
        }

        @Override
        public void onClose(Status status, Metadata trailers) {
            if (status == Status.UNAUTHENTICATED) {
                if (RefreshingOAuth2CredentialsInterceptor.this.rateLimiter.tryAcquire()) {
                    RefreshingOAuth2CredentialsInterceptor.this.store.revokeUnauthToken(this.origToken);
                } else {
                    LOG.trace("UnAuthResponseListener rate limited", new Object[0]);
                }
            }
            super.onClose(status, trailers);
        }
    }
}

