/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.io;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.io.Watchdog;
import com.google.bigtable.repackaged.io.grpc.CallOptions;
import com.google.bigtable.repackaged.io.grpc.Channel;
import com.google.bigtable.repackaged.io.grpc.ClientCall;
import com.google.bigtable.repackaged.io.grpc.ClientInterceptor;
import com.google.bigtable.repackaged.io.grpc.MethodDescriptor;
import java.util.Set;

@InternalApi(value="For internal usage only")
public class WatchdogInterceptor
implements ClientInterceptor {
    private final Set<MethodDescriptor<?, ?>> watchedMethods;
    private final Watchdog watchdog;

    public WatchdogInterceptor(Set<MethodDescriptor<?, ?>> watchedMethods, Watchdog watchdog) {
        this.watchedMethods = watchedMethods;
        this.watchdog = watchdog;
    }

    @Override
    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> methodDescriptor, CallOptions callOptions, Channel channel) {
        ClientCall<ReqT, RespT> call = channel.newCall(methodDescriptor, callOptions);
        if (this.watchedMethods.contains(methodDescriptor)) {
            call = this.watchdog.watch(call);
        }
        return call;
    }
}

