/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.scanner;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.api.core.InternalExtensionOnly;
import com.google.bigtable.repackaged.com.google.common.base.MoreObjects;
import com.google.bigtable.repackaged.com.google.common.base.Objects;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableList;
import com.google.bigtable.repackaged.com.google.protobuf.ByteString;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;

@InternalExtensionOnly
public class FlatRow
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final ByteString rowKey;
    private final ImmutableList<Cell> cells;

    @InternalApi(value="For internal usage only")
    public static Builder newBuilder() {
        return new Builder();
    }

    @InternalApi(value="For internal usage only")
    public FlatRow(ByteString rowKey, ImmutableList<Cell> cells) {
        this.rowKey = rowKey;
        this.cells = cells;
    }

    public ByteString getRowKey() {
        return this.rowKey;
    }

    public List<Cell> getCells() {
        return this.cells;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FlatRow)) {
            return false;
        }
        FlatRow other = (FlatRow)obj;
        return Objects.equal(this.rowKey, other.rowKey) && Objects.equal(this.cells, other.getCells());
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("rowKey", this.rowKey).add("cells", this.cells).toString();
    }

    @InternalApi(value="For internal usage only")
    public static final class Builder {
        private ByteString rowKey = null;
        private final ImmutableList.Builder<Cell> listBuilder = new ImmutableList.Builder();

        private Builder() {
        }

        public Builder withRowKey(ByteString rowKey) {
            Preconditions.checkNotNull(rowKey, "Row Key can not be null");
            this.rowKey = rowKey;
            return this;
        }

        public Builder addCell(String family, ByteString qualifier, long timestamp, ByteString value, List<String> labels) {
            return this.addCell(new Cell(family, qualifier, timestamp, value, labels));
        }

        public Builder addCell(String family, ByteString qualifier, long timestamp, ByteString value) {
            return this.addCell(new Cell(family, qualifier, timestamp, value, null));
        }

        public Builder addCell(Cell cell) {
            Preconditions.checkNotNull(cell, "cell can not be null");
            this.listBuilder.add((Object)cell);
            return this;
        }

        public FlatRow build() {
            return new FlatRow(this.rowKey, (ImmutableList<Cell>)this.listBuilder.build());
        }

        public ByteString getRowKey() {
            return this.rowKey;
        }
    }

    public static final class Cell
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String family;
        private final ByteString qualifier;
        private final long timestamp;
        private final ByteString value;
        private final List<String> labels;

        @InternalApi(value="For internal usage only")
        public static Builder newBuilder() {
            return new Builder();
        }

        @InternalApi(value="For internal usage only")
        public Cell(String family, ByteString qualifier, long timestamp, ByteString value, List<String> labels) {
            this.family = family;
            this.qualifier = qualifier;
            this.timestamp = timestamp;
            this.value = value;
            this.labels = labels == null ? Collections.emptyList() : labels;
        }

        public String getFamily() {
            return this.family;
        }

        public ByteString getQualifier() {
            return this.qualifier;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public ByteString getValue() {
            return this.value;
        }

        public List<String> getLabels() {
            return this.labels;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Cell)) {
                return false;
            }
            Cell other = (Cell)obj;
            return this.timestamp == other.timestamp && Objects.equal(this.family, other.family) && Objects.equal(this.qualifier, other.qualifier) && Objects.equal(this.value, other.value) && Objects.equal(this.labels, other.labels);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("family", this.family).add("qualifier", this.qualifier).add("timestamp", this.timestamp).add("value", this.value).add("labels", this.labels).toString();
        }

        @InternalApi(value="For internal usage only")
        public static final class Builder {
            private String family;
            private ByteString qualifier;
            private long timestamp;
            private ByteString value;
            private List<String> labels;

            public Builder withFamily(String family) {
                this.family = family;
                return this;
            }

            public Builder withQualifier(ByteString qualifier) {
                this.qualifier = qualifier;
                return this;
            }

            public Builder withTimestamp(long timestamp) {
                this.timestamp = timestamp;
                return this;
            }

            public Builder withValue(ByteString value) {
                this.value = value;
                return this;
            }

            public Builder withLabels(List<String> labels) {
                if (labels == null || labels.isEmpty()) {
                    return this;
                }
                this.labels = labels;
                return this;
            }

            public Cell build() {
                return new Cell(this.family, this.qualifier, this.timestamp, this.value, this.labels);
            }
        }
    }
}

