/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc.alts;

import com.google.bigtable.repackaged.com.google.auth.oauth2.GoogleCredentials;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableList;
import com.google.bigtable.repackaged.io.grpc.CallCredentials;
import com.google.bigtable.repackaged.io.grpc.ChannelCredentials;
import com.google.bigtable.repackaged.io.grpc.CompositeChannelCredentials;
import com.google.bigtable.repackaged.io.grpc.Status;
import com.google.bigtable.repackaged.io.grpc.alts.FailingCallCredentials;
import com.google.bigtable.repackaged.io.grpc.alts.HandshakerServiceChannel;
import com.google.bigtable.repackaged.io.grpc.alts.internal.AltsProtocolNegotiator;
import com.google.bigtable.repackaged.io.grpc.auth.MoreCallCredentials;
import com.google.bigtable.repackaged.io.grpc.internal.SharedResourcePool;
import com.google.bigtable.repackaged.io.grpc.netty.GrpcSslContexts;
import com.google.bigtable.repackaged.io.grpc.netty.InternalNettyChannelCredentials;
import com.google.bigtable.repackaged.io.grpc.netty.InternalProtocolNegotiator;
import com.google.bigtable.repackaged.io.grpc.netty.shaded.io.netty.handler.ssl.SslContext;
import java.io.IOException;
import javax.net.ssl.SSLException;

public final class GoogleDefaultChannelCredentials {
    private GoogleDefaultChannelCredentials() {
    }

    public static ChannelCredentials create() {
        CallCredentials callCredentials;
        ChannelCredentials nettyCredentials = InternalNettyChannelCredentials.create(GoogleDefaultChannelCredentials.createClientFactory());
        try {
            callCredentials = MoreCallCredentials.from(GoogleCredentials.getApplicationDefault());
        }
        catch (IOException e) {
            callCredentials = new FailingCallCredentials(Status.UNAUTHENTICATED.withDescription("Failed to get Google default credentials").withCause(e));
        }
        return CompositeChannelCredentials.create(nettyCredentials, callCredentials);
    }

    private static InternalProtocolNegotiator.ClientFactory createClientFactory() {
        SslContext sslContext;
        try {
            sslContext = GrpcSslContexts.forClient().build();
        }
        catch (SSLException e) {
            throw new RuntimeException(e);
        }
        return new AltsProtocolNegotiator.GoogleDefaultProtocolNegotiatorFactory(ImmutableList.of(), SharedResourcePool.forResource(HandshakerServiceChannel.SHARED_HANDSHAKER_CHANNEL), sslContext);
    }
}

