/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc.netty.shaded.io.netty.handler.ssl;

import com.google.bigtable.repackaged.io.grpc.netty.shaded.io.netty.handler.ssl.JdkAlpnApplicationProtocolNegotiator;
import com.google.bigtable.repackaged.io.grpc.netty.shaded.io.netty.handler.ssl.OpenSsl;
import com.google.bigtable.repackaged.io.grpc.netty.shaded.io.netty.handler.ssl.SslUtils;

public enum SslProvider {
    JDK,
    OPENSSL,
    OPENSSL_REFCNT;


    public static boolean isAlpnSupported(SslProvider provider) {
        switch (provider) {
            case JDK: {
                return JdkAlpnApplicationProtocolNegotiator.isAlpnSupported();
            }
            case OPENSSL: 
            case OPENSSL_REFCNT: {
                return OpenSsl.isAlpnSupported();
            }
        }
        throw new Error("Unknown SslProvider: " + (Object)((Object)provider));
    }

    public static boolean isTlsv13Supported(SslProvider provider) {
        switch (provider) {
            case JDK: {
                return SslUtils.isTLSv13SupportedByJDK();
            }
            case OPENSSL: 
            case OPENSSL_REFCNT: {
                return OpenSsl.isTlsv13Supported();
            }
        }
        throw new Error("Unknown SslProvider: " + (Object)((Object)provider));
    }

    static boolean isTlsv13EnabledByDefault(SslProvider provider) {
        switch (provider) {
            case JDK: {
                return SslUtils.isTLSv13EnabledByJDK();
            }
            case OPENSSL: 
            case OPENSSL_REFCNT: {
                return OpenSsl.isTlsv13Supported();
            }
        }
        throw new Error("Unknown SslProvider: " + (Object)((Object)provider));
    }
}

