/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.opencensus.contrib.zpages;

import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.io.opencensus.contrib.zpages.RpczZPageHandler;
import com.google.bigtable.repackaged.io.opencensus.contrib.zpages.StatszZPageHandler;
import com.google.bigtable.repackaged.io.opencensus.contrib.zpages.TraceConfigzZPageHandler;
import com.google.bigtable.repackaged.io.opencensus.contrib.zpages.TracezZPageHandler;
import com.google.bigtable.repackaged.io.opencensus.contrib.zpages.ZPageHandler;
import com.google.bigtable.repackaged.io.opencensus.contrib.zpages.ZPageHttpHandler;
import com.google.bigtable.repackaged.io.opencensus.stats.Stats;
import com.google.bigtable.repackaged.io.opencensus.trace.Tracing;
import com.google.bigtable.repackaged.javax.annotation.Nullable;
import com.google.bigtable.repackaged.javax.annotation.concurrent.GuardedBy;
import com.google.bigtable.repackaged.javax.annotation.concurrent.ThreadSafe;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.logging.Logger;

@ThreadSafe
public final class ZPageHandlers {
    private static final int BACKLOG = 5;
    private static final int STOP_DELAY = 1;
    private static final Logger logger = Logger.getLogger(ZPageHandler.class.getName());
    private static final ZPageHandler tracezZPageHandler = TracezZPageHandler.create(Tracing.getExportComponent().getRunningSpanStore(), Tracing.getExportComponent().getSampledSpanStore());
    private static final ZPageHandler traceConfigzZPageHandler = TraceConfigzZPageHandler.create(Tracing.getTraceConfig());
    private static final ZPageHandler rpczZpageHandler = RpczZPageHandler.create(Stats.getViewManager());
    private static final ZPageHandler statszZPageHandler = StatszZPageHandler.create(Stats.getViewManager());
    private static final Object monitor = new Object();
    private static volatile boolean isRunningSpanStoreInitialized = false;
    @Nullable
    @GuardedBy(value="monitor")
    private static HttpServer server;

    public static ZPageHandler getTracezZPageHandler() {
        ZPageHandlers.enableRunningSpanStore();
        return tracezZPageHandler;
    }

    public static ZPageHandler getTraceConfigzZPageHandler() {
        return traceConfigzZPageHandler;
    }

    public static ZPageHandler getRpczZpageHandler() {
        return rpczZpageHandler;
    }

    public static ZPageHandler getStatszZPageHandler() {
        return statszZPageHandler;
    }

    public static void registerAllToHttpServer(HttpServer server) {
        server.createContext(tracezZPageHandler.getUrlPath(), new ZPageHttpHandler(tracezZPageHandler));
        server.createContext(traceConfigzZPageHandler.getUrlPath(), new ZPageHttpHandler(traceConfigzZPageHandler));
        server.createContext(rpczZpageHandler.getUrlPath(), new ZPageHttpHandler(rpczZpageHandler));
        server.createContext(statszZPageHandler.getUrlPath(), new ZPageHttpHandler(statszZPageHandler));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startHttpServerAndRegisterAll(int port) throws IOException {
        Object object = monitor;
        synchronized (object) {
            Preconditions.checkState(server == null, "The HttpServer is already started.");
            server = HttpServer.create(new InetSocketAddress(port), 5);
            ZPageHandlers.registerAllToHttpServer(server);
            server.start();
            logger.fine("HttpServer started on address " + server.getAddress().toString());
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                logger.fine("*** Shutting down gRPC server (JVM shutting down)");
                ZPageHandlers.stop();
                logger.fine("*** Server shut down");
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void stop() {
        Object object = monitor;
        synchronized (object) {
            if (server == null) {
                throw new IllegalStateException("The HttpServer is already stopped.");
            }
            server.stop(1);
            server = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void enableRunningSpanStore() {
        if (!isRunningSpanStoreInitialized) {
            Object object = monitor;
            synchronized (object) {
                if (isRunningSpanStoreInitialized) {
                    return;
                }
                Tracing.getExportComponent().getRunningSpanStore().setMaxNumberOfSpans(Integer.MAX_VALUE);
                isRunningSpanStoreInitialized = true;
            }
        }
    }

    private ZPageHandlers() {
    }
}

