/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.opencensus.implcore.stats;

import com.google.bigtable.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.common.collect.LinkedHashMultimap;
import com.google.bigtable.repackaged.com.google.common.collect.Maps;
import com.google.bigtable.repackaged.com.google.common.collect.Multimap;
import com.google.bigtable.repackaged.io.opencensus.common.Duration;
import com.google.bigtable.repackaged.io.opencensus.common.Function;
import com.google.bigtable.repackaged.io.opencensus.common.Functions;
import com.google.bigtable.repackaged.io.opencensus.common.Timestamp;
import com.google.bigtable.repackaged.io.opencensus.implcore.internal.CheckerFrameworkUtils;
import com.google.bigtable.repackaged.io.opencensus.implcore.internal.CurrentState;
import com.google.bigtable.repackaged.io.opencensus.implcore.stats.IntervalBucket;
import com.google.bigtable.repackaged.io.opencensus.implcore.stats.MetricUtils;
import com.google.bigtable.repackaged.io.opencensus.implcore.stats.MutableAggregation;
import com.google.bigtable.repackaged.io.opencensus.implcore.stats.RecordUtils;
import com.google.bigtable.repackaged.io.opencensus.metrics.LabelValue;
import com.google.bigtable.repackaged.io.opencensus.metrics.data.AttachmentValue;
import com.google.bigtable.repackaged.io.opencensus.metrics.export.Metric;
import com.google.bigtable.repackaged.io.opencensus.metrics.export.MetricDescriptor;
import com.google.bigtable.repackaged.io.opencensus.metrics.export.Point;
import com.google.bigtable.repackaged.io.opencensus.metrics.export.TimeSeries;
import com.google.bigtable.repackaged.io.opencensus.stats.Aggregation;
import com.google.bigtable.repackaged.io.opencensus.stats.AggregationData;
import com.google.bigtable.repackaged.io.opencensus.stats.Measure;
import com.google.bigtable.repackaged.io.opencensus.stats.View;
import com.google.bigtable.repackaged.io.opencensus.stats.ViewData;
import com.google.bigtable.repackaged.io.opencensus.tags.TagContext;
import com.google.bigtable.repackaged.io.opencensus.tags.TagValue;
import com.google.bigtable.repackaged.javax.annotation.Nullable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

abstract class MutableViewData {
    @VisibleForTesting
    static final Timestamp ZERO_TIMESTAMP = Timestamp.create(0L, 0);
    private final View view;

    private MutableViewData(View view) {
        this.view = view;
    }

    static MutableViewData create(View view, Timestamp start) {
        return view.getWindow().match(new CreateCumulative(view, start), new CreateInterval(view, start), Functions.throwAssertionError());
    }

    View getView() {
        return this.view;
    }

    @Nullable
    abstract Metric toMetric(Timestamp var1, CurrentState.State var2);

    abstract void record(TagContext var1, double var2, Timestamp var4, Map<String, AttachmentValue> var5);

    abstract ViewData toViewData(Timestamp var1, CurrentState.State var2);

    abstract void clearStats();

    abstract void resumeStatsCollection(Timestamp var1);

    private static final class CreateInterval
    implements Function<View.AggregationWindow.Interval, MutableViewData> {
        private final View view;
        private final Timestamp start;

        @Override
        public MutableViewData apply(View.AggregationWindow.Interval arg) {
            return new IntervalMutableViewData(this.view, this.start);
        }

        private CreateInterval(View view, Timestamp start) {
            this.view = view;
            this.start = start;
        }
    }

    private static final class CreateCumulative
    implements Function<View.AggregationWindow.Cumulative, MutableViewData> {
        private final View view;
        private final Timestamp start;

        @Override
        public MutableViewData apply(View.AggregationWindow.Cumulative arg) {
            return new CumulativeMutableViewData(this.view, this.start);
        }

        private CreateCumulative(View view, Timestamp start) {
            this.view = view;
            this.start = start;
        }
    }

    private static final class IntervalMutableViewData
    extends MutableViewData {
        private static final int N = 4;
        private final ArrayDeque<IntervalBucket> buckets = new ArrayDeque();
        private final Duration totalDuration;
        private final Duration bucketDuration;

        private IntervalMutableViewData(View view, Timestamp start) {
            super(view);
            Duration totalDuration;
            this.totalDuration = totalDuration = ((View.AggregationWindow.Interval)view.getWindow()).getDuration();
            this.bucketDuration = Duration.fromMillis(totalDuration.toMillis() / 4L);
            this.shiftBucketList(5L, start);
        }

        @Override
        @Nullable
        Metric toMetric(Timestamp now, CurrentState.State state) {
            return null;
        }

        @Override
        void record(TagContext context, double value, Timestamp timestamp, Map<String, AttachmentValue> attachments) {
            List<TagValue> tagValues = RecordUtils.getTagValues(RecordUtils.getTagMap(context), ((MutableViewData)this).view.getColumns());
            this.refreshBucketList(timestamp);
            CheckerFrameworkUtils.castNonNull(this.buckets.peekLast()).record(tagValues, value, attachments, timestamp);
        }

        @Override
        ViewData toViewData(Timestamp now, CurrentState.State state) {
            this.refreshBucketList(now);
            if (state == CurrentState.State.ENABLED) {
                return ViewData.create(((MutableViewData)this).view, this.combineBucketsAndGetAggregationMap(now), ViewData.AggregationWindowData.IntervalData.create(now));
            }
            return ViewData.create(((MutableViewData)this).view, Collections.emptyMap(), ViewData.AggregationWindowData.IntervalData.create(ZERO_TIMESTAMP));
        }

        @Override
        void clearStats() {
            for (IntervalBucket bucket : this.buckets) {
                bucket.clearStats();
            }
        }

        @Override
        void resumeStatsCollection(Timestamp now) {
            this.refreshBucketList(now);
        }

        private void refreshBucketList(Timestamp now) {
            if (this.buckets.size() != 5) {
                throw new AssertionError((Object)"Bucket list must have exactly 5 buckets.");
            }
            Timestamp startOfLastBucket = CheckerFrameworkUtils.castNonNull(this.buckets.peekLast()).getStart();
            Preconditions.checkArgument(now.compareTo(startOfLastBucket) >= 0, "Current time must be within or after the last bucket.");
            long elapsedTimeMillis = now.subtractTimestamp(startOfLastBucket).toMillis();
            long numOfPadBuckets = elapsedTimeMillis / this.bucketDuration.toMillis();
            this.shiftBucketList(numOfPadBuckets, now);
        }

        private void shiftBucketList(long numOfPadBuckets, Timestamp now) {
            Timestamp startOfNewBucket = !this.buckets.isEmpty() ? CheckerFrameworkUtils.castNonNull(this.buckets.peekLast()).getStart().addDuration(this.bucketDuration) : IntervalMutableViewData.subtractDuration(now, this.totalDuration);
            if (numOfPadBuckets > 5L) {
                startOfNewBucket = IntervalMutableViewData.subtractDuration(now, this.totalDuration);
                numOfPadBuckets = 5L;
            }
            int i = 0;
            while ((long)i < numOfPadBuckets) {
                this.buckets.add(new IntervalBucket(startOfNewBucket, this.bucketDuration, ((MutableViewData)this).view.getAggregation(), ((MutableViewData)this).view.getMeasure()));
                startOfNewBucket = startOfNewBucket.addDuration(this.bucketDuration);
                ++i;
            }
            while (this.buckets.size() > 5) {
                this.buckets.pollFirst();
            }
        }

        private Map<List<TagValue>, AggregationData> combineBucketsAndGetAggregationMap(Timestamp now) {
            LinkedHashMultimap<List<TagValue>, MutableAggregation> multimap = LinkedHashMultimap.create();
            ArrayDeque<IntervalBucket> shallowCopy = new ArrayDeque<IntervalBucket>(this.buckets);
            Aggregation aggregation = ((MutableViewData)this).view.getAggregation();
            Measure measure = ((MutableViewData)this).view.getMeasure();
            IntervalMutableViewData.putBucketsIntoMultiMap(shallowCopy, multimap, aggregation, measure, now);
            Map<List<TagValue>, MutableAggregation> singleMap = IntervalMutableViewData.aggregateOnEachTagValueList(multimap, aggregation, measure);
            return RecordUtils.createAggregationMap(singleMap, super.getView().getMeasure());
        }

        private static void putBucketsIntoMultiMap(ArrayDeque<IntervalBucket> buckets, Multimap<List<TagValue>, MutableAggregation> multimap, Aggregation aggregation, Measure measure, Timestamp now) {
            IntervalBucket head = CheckerFrameworkUtils.castNonNull(buckets.peekFirst());
            IntervalBucket tail = CheckerFrameworkUtils.castNonNull(buckets.peekLast());
            double fractionTail = tail.getFraction(now);
            Preconditions.checkArgument(0.0 <= fractionTail && fractionTail <= 1.0, "Fraction " + fractionTail + " should be within [0.0, 1.0].");
            double fractionHead = 1.0 - fractionTail;
            IntervalMutableViewData.putFractionalMutableAggregationsToMultiMap(head.getTagValueAggregationMap(), multimap, aggregation, measure, fractionHead);
            boolean shouldSkipFirst = true;
            for (IntervalBucket bucket : buckets) {
                if (shouldSkipFirst) {
                    shouldSkipFirst = false;
                    continue;
                }
                for (Map.Entry<List<TagValue>, MutableAggregation> entry : bucket.getTagValueAggregationMap().entrySet()) {
                    multimap.put(entry.getKey(), entry.getValue());
                }
            }
        }

        private static <T> void putFractionalMutableAggregationsToMultiMap(Map<T, MutableAggregation> mutableAggrMap, Multimap<T, MutableAggregation> multimap, Aggregation aggregation, Measure measure, double fraction) {
            for (Map.Entry<T, MutableAggregation> entry : mutableAggrMap.entrySet()) {
                MutableAggregation fractionalMutableAgg = RecordUtils.createMutableAggregation(aggregation, measure);
                fractionalMutableAgg.combine(entry.getValue(), fraction);
                multimap.put(entry.getKey(), fractionalMutableAgg);
            }
        }

        private static <T> Map<T, MutableAggregation> aggregateOnEachTagValueList(Multimap<T, MutableAggregation> multimap, Aggregation aggregation, Measure measure) {
            HashMap<T, MutableAggregation> map = Maps.newHashMap();
            for (T tagValues : multimap.keySet()) {
                MutableAggregation combinedAggregation = RecordUtils.createMutableAggregation(aggregation, measure);
                for (MutableAggregation mutableAggregation : multimap.get(tagValues)) {
                    combinedAggregation.combine(mutableAggregation, 1.0);
                }
                map.put(tagValues, combinedAggregation);
            }
            return map;
        }

        private static Timestamp subtractDuration(Timestamp timestamp, Duration duration) {
            return timestamp.addDuration(Duration.create(-duration.getSeconds(), -duration.getNanos()));
        }
    }

    private static final class CumulativeMutableViewData
    extends MutableViewData {
        private Timestamp start;
        private final Map<List<TagValue>, MutableAggregation> tagValueAggregationMap = Maps.newHashMap();
        private final MetricDescriptor metricDescriptor;

        private CumulativeMutableViewData(View view, Timestamp start) {
            super(view);
            this.start = start;
            MetricDescriptor metricDescriptor = MetricUtils.viewToMetricDescriptor(view);
            if (metricDescriptor == null) {
                throw new AssertionError((Object)"Cumulative view should be converted to a non-null MetricDescriptor.");
            }
            this.metricDescriptor = metricDescriptor;
        }

        @Override
        @Nullable
        Metric toMetric(Timestamp now, CurrentState.State state) {
            if (state == CurrentState.State.DISABLED) {
                return null;
            }
            MetricDescriptor.Type type = this.metricDescriptor.getType();
            Timestamp startTime = type == MetricDescriptor.Type.GAUGE_INT64 || type == MetricDescriptor.Type.GAUGE_DOUBLE ? null : this.start;
            ArrayList<TimeSeries> timeSeriesList = new ArrayList<TimeSeries>();
            for (Map.Entry<List<TagValue>, MutableAggregation> entry : this.tagValueAggregationMap.entrySet()) {
                List<LabelValue> labelValues = MetricUtils.tagValuesToLabelValues(entry.getKey());
                Point point = entry.getValue().toPoint(now);
                timeSeriesList.add(TimeSeries.createWithOnePoint(labelValues, point, startTime));
            }
            return Metric.create(this.metricDescriptor, timeSeriesList);
        }

        @Override
        void record(TagContext context, double value, Timestamp timestamp, Map<String, AttachmentValue> attachments) {
            List<TagValue> tagValues = RecordUtils.getTagValues(RecordUtils.getTagMap(context), ((MutableViewData)this).view.getColumns());
            if (!this.tagValueAggregationMap.containsKey(tagValues)) {
                this.tagValueAggregationMap.put(tagValues, RecordUtils.createMutableAggregation(((MutableViewData)this).view.getAggregation(), super.getView().getMeasure()));
            }
            this.tagValueAggregationMap.get(tagValues).add(value, attachments, timestamp);
        }

        @Override
        ViewData toViewData(Timestamp now, CurrentState.State state) {
            if (state == CurrentState.State.ENABLED) {
                return ViewData.create(((MutableViewData)this).view, RecordUtils.createAggregationMap(this.tagValueAggregationMap, ((MutableViewData)this).view.getMeasure()), ViewData.AggregationWindowData.CumulativeData.create(this.start, now));
            }
            return ViewData.create(((MutableViewData)this).view, Collections.emptyMap(), ViewData.AggregationWindowData.CumulativeData.create(ZERO_TIMESTAMP, ZERO_TIMESTAMP));
        }

        @Override
        void clearStats() {
            this.tagValueAggregationMap.clear();
        }

        @Override
        void resumeStatsCollection(Timestamp now) {
            this.start = now;
        }
    }
}

