/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.opencensus.implcore.trace.export;

import com.google.bigtable.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.bigtable.repackaged.io.opencensus.common.Duration;
import com.google.bigtable.repackaged.io.opencensus.common.ToLongFunction;
import com.google.bigtable.repackaged.io.opencensus.implcore.internal.CheckerFrameworkUtils;
import com.google.bigtable.repackaged.io.opencensus.implcore.internal.DaemonThreadFactory;
import com.google.bigtable.repackaged.io.opencensus.implcore.trace.RecordEventsSpanImpl;
import com.google.bigtable.repackaged.io.opencensus.metrics.DerivedLongCumulative;
import com.google.bigtable.repackaged.io.opencensus.metrics.DerivedLongGauge;
import com.google.bigtable.repackaged.io.opencensus.metrics.MetricOptions;
import com.google.bigtable.repackaged.io.opencensus.metrics.Metrics;
import com.google.bigtable.repackaged.io.opencensus.trace.export.ExportComponent;
import com.google.bigtable.repackaged.io.opencensus.trace.export.SpanData;
import com.google.bigtable.repackaged.io.opencensus.trace.export.SpanExporter;
import com.google.bigtable.repackaged.javax.annotation.concurrent.GuardedBy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class SpanExporterImpl
extends SpanExporter {
    private static final Logger logger = Logger.getLogger(ExportComponent.class.getName());
    private static final DerivedLongCumulative droppedSpans = Metrics.getMetricRegistry().addDerivedLongCumulative("oc_worker_spans_dropped", MetricOptions.builder().setDescription("Number of spans dropped by the exporter thread.").setUnit("1").build());
    private static final DerivedLongCumulative pushedSpans = Metrics.getMetricRegistry().addDerivedLongCumulative("oc_worker_spans_pushed", MetricOptions.builder().setDescription("Number of spans pushed by the exporter thread to the exporter.").setUnit("1").build());
    private static final DerivedLongGauge referencedSpans = Metrics.getMetricRegistry().addDerivedLongGauge("oc_worker_spans_referenced", MetricOptions.builder().setDescription("Current number of spans referenced by the exporter thread.").setUnit("1").build());
    private final Worker worker;
    private final Thread workerThread;

    static SpanExporterImpl create(int bufferSize, Duration scheduleDelay) {
        Worker worker = new Worker(bufferSize, scheduleDelay);
        return new SpanExporterImpl(worker);
    }

    public void addSpan(RecordEventsSpanImpl span) {
        this.worker.addSpan(span);
    }

    @Override
    public void registerHandler(String name, SpanExporter.Handler handler) {
        this.worker.registerHandler(name, handler);
    }

    @Override
    public void unregisterHandler(String name) {
        this.worker.unregisterHandler(name);
    }

    void flush() {
        this.worker.flush();
    }

    void shutdown() {
        this.flush();
        this.workerThread.interrupt();
    }

    private SpanExporterImpl(Worker worker) {
        this.workerThread = new DaemonThreadFactory("ExportComponent.ServiceExporterThread").newThread(worker);
        this.workerThread.start();
        this.worker = worker;
        droppedSpans.createTimeSeries(Collections.emptyList(), this.worker, new ReportDroppedSpans());
        referencedSpans.createTimeSeries(Collections.emptyList(), this.worker, new ReportReferencedSpans());
        pushedSpans.createTimeSeries(Collections.emptyList(), this.worker, new ReportPushedSpans());
    }

    @VisibleForTesting
    Thread getServiceExporterThread() {
        return this.workerThread;
    }

    @VisibleForTesting
    long getDroppedSpans() {
        return this.worker.getDroppedSpans();
    }

    @VisibleForTesting
    long getReferencedSpans() {
        return this.worker.getReferencedSpans();
    }

    @VisibleForTesting
    long getPushedSpans() {
        return this.worker.getPushedSpans();
    }

    private static final class Worker
    implements Runnable {
        private final Object monitor = new Object();
        @GuardedBy(value="monitor")
        private final List<RecordEventsSpanImpl> spans;
        @GuardedBy(value="monitor")
        private long referencedSpans = 0L;
        @GuardedBy(value="monitor")
        private long droppedSpans = 0L;
        @GuardedBy(value="monitor")
        private long pushedSpans = 0L;
        private final Map<String, SpanExporter.Handler> serviceHandlers = new ConcurrentHashMap<String, SpanExporter.Handler>();
        private final int bufferSize;
        private final long maxReferencedSpans;
        private final long scheduleDelayMillis;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addSpan(RecordEventsSpanImpl span) {
            Object object = this.monitor;
            synchronized (object) {
                if (this.referencedSpans == this.maxReferencedSpans) {
                    ++this.droppedSpans;
                    return;
                }
                this.spans.add(span);
                ++this.referencedSpans;
                if (this.spans.size() >= this.bufferSize) {
                    this.monitor.notifyAll();
                }
            }
        }

        private void registerHandler(String name, SpanExporter.Handler serviceHandler) {
            this.serviceHandlers.put(name, serviceHandler);
        }

        private void unregisterHandler(String name) {
            this.serviceHandlers.remove(name);
        }

        private void onBatchExport(List<SpanData> spanDataList) {
            for (Map.Entry<String, SpanExporter.Handler> it : this.serviceHandlers.entrySet()) {
                try {
                    it.getValue().export(spanDataList);
                }
                catch (Throwable e) {
                    logger.log(Level.WARNING, "Exception thrown by the service export " + it.getKey(), e);
                }
            }
        }

        private Worker(int bufferSize, Duration scheduleDelay) {
            this.spans = new ArrayList<RecordEventsSpanImpl>(bufferSize);
            this.bufferSize = bufferSize;
            this.maxReferencedSpans = 4L * (long)bufferSize;
            this.scheduleDelayMillis = scheduleDelay.toMillis();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                ArrayList<RecordEventsSpanImpl> spansCopy;
                Object object = this.monitor;
                synchronized (object) {
                    if (this.spans.size() < this.bufferSize) {
                        do {
                            try {
                                this.monitor.wait(this.scheduleDelayMillis);
                            }
                            catch (InterruptedException ie) {
                                Thread.currentThread().interrupt();
                                return;
                            }
                        } while (this.spans.isEmpty());
                    }
                    spansCopy = new ArrayList<RecordEventsSpanImpl>(this.spans);
                    this.spans.clear();
                }
                this.exportBatches(spansCopy);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void flush() {
            ArrayList<RecordEventsSpanImpl> spansCopy;
            Object object = this.monitor;
            synchronized (object) {
                spansCopy = new ArrayList<RecordEventsSpanImpl>(this.spans);
                this.spans.clear();
            }
            this.exportBatches(spansCopy);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long getDroppedSpans() {
            Object object = this.monitor;
            synchronized (object) {
                return this.droppedSpans;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long getReferencedSpans() {
            Object object = this.monitor;
            synchronized (object) {
                return this.referencedSpans;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long getPushedSpans() {
            Object object = this.monitor;
            synchronized (object) {
                return this.pushedSpans;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void exportBatches(ArrayList<RecordEventsSpanImpl> spansCopy) {
            ArrayList<SpanData> spanDataList = new ArrayList<SpanData>(this.bufferSize);
            for (int i = 0; i < spansCopy.size(); ++i) {
                spanDataList.add(spansCopy.get(i).toSpanData());
                spansCopy.set(i, CheckerFrameworkUtils.castNonNull(null));
                if (spanDataList.size() != this.bufferSize) continue;
                this.onBatchExport(Collections.unmodifiableList(spanDataList));
                spanDataList = new ArrayList(this.bufferSize);
                Object object = this.monitor;
                synchronized (object) {
                    this.referencedSpans -= (long)this.bufferSize;
                    this.pushedSpans += (long)this.bufferSize;
                    continue;
                }
            }
            if (!spanDataList.isEmpty()) {
                this.onBatchExport(Collections.unmodifiableList(spanDataList));
                Object object = this.monitor;
                synchronized (object) {
                    this.referencedSpans -= (long)spanDataList.size();
                    this.pushedSpans += (long)spanDataList.size();
                }
                spanDataList.clear();
            }
        }
    }

    private static class ReportPushedSpans
    implements ToLongFunction<Worker> {
        private ReportPushedSpans() {
        }

        @Override
        public long applyAsLong(Worker worker) {
            if (worker == null) {
                return 0L;
            }
            return worker.getPushedSpans();
        }
    }

    private static class ReportReferencedSpans
    implements ToLongFunction<Worker> {
        private ReportReferencedSpans() {
        }

        @Override
        public long applyAsLong(Worker worker) {
            if (worker == null) {
                return 0L;
            }
            return worker.getReferencedSpans();
        }
    }

    private static class ReportDroppedSpans
    implements ToLongFunction<Worker> {
        private ReportDroppedSpans() {
        }

        @Override
        public long applyAsLong(Worker worker) {
            if (worker == null) {
                return 0L;
            }
            return worker.getDroppedSpans();
        }
    }
}

