/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase;

import com.google.bigtable.repackaged.com.google.api.core.ApiFuture;
import com.google.bigtable.repackaged.com.google.api.core.ApiFutureCallback;
import com.google.bigtable.repackaged.com.google.api.core.ApiFutures;
import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.api.core.SettableApiFuture;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.MoreExecutors;
import com.google.bigtable.repackaged.javax.annotation.Nullable;
import com.google.cloud.bigtable.hbase.BigtableBufferedMutatorHelper;
import com.google.cloud.bigtable.hbase.adapters.Adapters;
import com.google.cloud.bigtable.hbase.adapters.HBaseRequestAdapter;
import com.google.cloud.bigtable.hbase.util.ByteStringer;
import com.google.cloud.bigtable.hbase.util.Logger;
import com.google.cloud.bigtable.hbase.wrappers.BigtableApi;
import com.google.cloud.bigtable.hbase.wrappers.BigtableHBaseSettings;
import com.google.cloud.bigtable.hbase.wrappers.BulkReadWrapper;
import com.google.cloud.bigtable.metrics.BigtableClientMetrics;
import com.google.cloud.bigtable.metrics.Timer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.RetriesExhaustedWithDetailsException;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.util.Bytes;

@InternalApi(value="For internal usage only")
public class BatchExecutor
implements AutoCloseable {
    protected static final Logger LOG = new Logger(BatchExecutor.class);
    public static final byte[] NO_REGION = new byte[0];
    protected final BigtableHBaseSettings settings;
    protected final HBaseRequestAdapter requestAdapter;
    protected final Timer batchTimer = BigtableClientMetrics.timer(BigtableClientMetrics.MetricLevel.Info, "batch.latency");
    private final BigtableBufferedMutatorHelper bufferedMutatorHelper;
    private final BulkReadWrapper bulkRead;

    public BatchExecutor(BigtableApi bigtableApi, BigtableHBaseSettings settings, HBaseRequestAdapter adapter) {
        this.requestAdapter = adapter;
        this.settings = settings;
        this.bulkRead = bigtableApi.getDataClient().createBulkRead(adapter.getTableId());
        this.bufferedMutatorHelper = new BigtableBufferedMutatorHelper(bigtableApi, settings, adapter);
    }

    @Override
    public void close() throws IOException {
        this.bufferedMutatorHelper.close();
        this.bulkRead.close();
    }

    private <R extends Row, T> ApiFuture<Result> issueAsyncRowRequest(Row row, Batch.Callback<T> callback, Object[] results, int index) {
        LOG.trace("issueRowRequest(Row, Batch.Callback, Object[], index", new Object[0]);
        SettableApiFuture<Result> resultFuture = SettableApiFuture.create();
        RpcResultFutureCallback<T> futureCallback = new RpcResultFutureCallback<T>(row, callback, index, results, resultFuture);
        results[index] = null;
        ApiFutures.addCallback(this.issueAsyncRequest(row), futureCallback, MoreExecutors.directExecutor());
        return resultFuture;
    }

    private ApiFuture<?> issueAsyncRequest(Row row) {
        try {
            if (row instanceof Get) {
                return this.bulkRead.add(ByteStringer.wrap(row.getRow()), Adapters.GET_ADAPTER.buildFilter((Get)row));
            }
            if (row instanceof Mutation) {
                return this.bufferedMutatorHelper.mutate((Mutation)row);
            }
            if (row instanceof RowMutations) {
                return this.bufferedMutatorHelper.mutate((RowMutations)row);
            }
        }
        catch (Throwable e) {
            return ApiFutures.immediateFailedFuture(new IOException("Could not process the batch", e));
        }
        LOG.error("Encountered unknown action type %s", row.getClass());
        return ApiFutures.immediateFailedFuture(new IllegalArgumentException("Encountered unknown action type: " + row.getClass()));
    }

    public void batch(List<? extends Row> actions, @Nullable Object[] results) throws IOException, InterruptedException {
        this.batchCallback(actions, results, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> List<ApiFuture<?>> issueAsyncRowRequests(List<? extends Row> actions, Object[] results, Batch.Callback<R> callback) {
        try {
            ArrayList resultFutures = new ArrayList(actions.size());
            for (int i = 0; i < actions.size(); ++i) {
                resultFutures.add(this.issueAsyncRowRequest(actions.get(i), callback, results, i));
            }
            ArrayList arrayList = resultFutures;
            return arrayList;
        }
        finally {
            this.bufferedMutatorHelper.sendUnsent();
            this.bulkRead.sendOutstanding();
        }
    }

    public Result[] batch(List<? extends Row> actions) throws IOException {
        return this.batch(actions, false);
    }

    Result[] batch(List<? extends Row> actions, boolean removeSucceededActions) throws IOException {
        try {
            Object[] resultsOrErrors = new Object[actions.size()];
            this.batchCallback(actions, resultsOrErrors, null, removeSucceededActions);
            Result[] results = new Result[resultsOrErrors.length];
            System.arraycopy(resultsOrErrors, 0, results, 0, results.length);
            return results;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOG.error("Encountered exception in batch(List<>).", e, new Object[0]);
            throw new IOException("Batch error", e);
        }
    }

    public <R> void batchCallback(List<? extends Row> actions, Object[] results, Batch.Callback<R> callback) throws IOException, InterruptedException {
        this.batchCallback(actions, results, callback, false);
    }

    <R> void batchCallback(List<? extends Row> actions, Object[] results, Batch.Callback<R> callback, boolean removeSucceededActions) throws IOException, InterruptedException {
        int i;
        Preconditions.checkArgument(results == null || results.length == actions.size(), "Result array must have same dimensions as actions list.");
        if (actions.isEmpty()) {
            return;
        }
        if (results == null) {
            results = new Object[actions.size()];
        }
        Timer.Context timerContext = this.batchTimer.time();
        List<ApiFuture<?>> resultFutures = this.issueAsyncRowRequests(actions, results, callback);
        ArrayList<Throwable> problems = new ArrayList<Throwable>();
        ArrayList<Row> problemActions = new ArrayList<Row>();
        ArrayList<String> hosts = new ArrayList<String>();
        for (i = 0; i < resultFutures.size(); ++i) {
            try {
                resultFutures.get(i).get();
                continue;
            }
            catch (ExecutionException e) {
                problemActions.add(actions.get(i));
                problems.add(e.getCause());
                hosts.add(this.settings.getDataHost());
            }
        }
        if (removeSucceededActions) {
            for (i = results.length - 1; i >= 0; --i) {
                if (results[i] == null || results[i] instanceof Throwable) continue;
                actions.remove(i);
            }
        }
        if (problems.size() > 0) {
            throw new RetriesExhaustedWithDetailsException(problems, problemActions, hosts);
        }
        timerContext.close();
    }

    public boolean[] exists(List<Get> gets) throws IOException {
        Result[] getResults = this.batch(gets);
        boolean[] exists = new boolean[getResults.length];
        for (int index = 0; index < getResults.length; ++index) {
            exists[index] = !getResults[index].isEmpty();
        }
        return exists;
    }

    static class RpcResultFutureCallback<T>
    implements ApiFutureCallback<Object> {
        private final Row row;
        private final Batch.Callback<T> callback;
        private final int index;
        private final Object[] resultsArray;
        private final SettableApiFuture<Result> resultFuture;

        public RpcResultFutureCallback(Row row, Batch.Callback<T> callback, int index, Object[] resultsArray, SettableApiFuture<Result> resultFuture) {
            this.row = row;
            this.callback = callback;
            this.index = index;
            this.resultsArray = resultsArray;
            this.resultFuture = resultFuture;
        }

        @Override
        public final void onSuccess(Object message) {
            Result result = message instanceof Result ? (Result)message : Result.EMPTY_RESULT;
            this.resultsArray[this.index] = result;
            this.resultFuture.set(result);
            if (this.callback != null) {
                try {
                    this.callback.update(NO_REGION, this.row.getRow(), (Object)result);
                }
                catch (Throwable t) {
                    LOG.error("User callback threw an exception for " + Bytes.toString((byte[])result.getRow()), new Object[0]);
                }
            }
        }

        @Override
        public final void onFailure(Throwable throwable) {
            this.resultsArray[this.index] = throwable;
            this.resultFuture.setException(throwable);
        }
    }
}

