/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.common.base.Joiner;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.client.AbstractBigtableConnection;

@InternalApi(value="For internal usage only")
public class BigtableHBaseVersion {
    private static final Log LOG = LogFactory.getLog(BigtableHBaseVersion.class);
    private static final AtomicBoolean wasInitialized = new AtomicBoolean(false);
    public static final String VERSION = "2.0.0-beta3";

    public static String getVersion() {
        if (wasInitialized.compareAndSet(false, true)) {
            BigtableHBaseVersion.warnOnVersionConflict();
        }
        return VERSION;
    }

    private static void warnOnVersionConflict() {
        ArrayList<URL> classResources;
        String knownClassResourcePath = AbstractBigtableConnection.class.getName().replaceAll("\\.", "/") + ".class";
        try {
            classResources = Collections.list(ClassLoader.getSystemResources(knownClassResourcePath));
        }
        catch (IOException e) {
            LOG.warn((Object)"Failed to probe for client version conflicts", (Throwable)e);
            return;
        }
        if (classResources.size() != 1) {
            LOG.warn((Object)("Found multiple copies of the bigtable-hbase on the classpath: " + Joiner.on(',').join(classResources)));
        }
    }
}

