/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.adapters;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.MutationApi;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.Range;
import com.google.bigtable.repackaged.com.google.protobuf.ByteString;
import com.google.cloud.bigtable.hbase.adapters.MutationAdapter;
import com.google.cloud.bigtable.hbase.util.TimestampConverter;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Delete;

@InternalApi(value="For internal usage only")
public class DeleteAdapter
extends MutationAdapter<Delete> {
    static boolean isPointDelete(Cell cell) {
        return cell.getTypeByte() == KeyValue.Type.Delete.getCode();
    }

    static boolean isColumnDelete(Cell cell) {
        return cell.getTypeByte() == KeyValue.Type.DeleteColumn.getCode();
    }

    static boolean isFamilyDelete(Cell cell) {
        return cell.getTypeByte() == KeyValue.Type.DeleteFamily.getCode();
    }

    static boolean isFamilyVersionDelete(Cell cell) {
        return cell.getTypeByte() == KeyValue.Type.DeleteFamilyVersion.getCode();
    }

    static void throwOnUnsupportedCellType(Cell cell) {
        throw new UnsupportedOperationException(String.format("Cell type %s is unsupported.", cell.getTypeByte()));
    }

    static void throwOnUnsupportedDeleteFamilyVersion(Cell cell) {
        throw new UnsupportedOperationException("Cannot perform column family deletion at timestamp.");
    }

    static void throwIfUnsupportedDeleteFamily(Cell cell) {
        if (cell.getTimestamp() != Long.MAX_VALUE) {
            throw new UnsupportedOperationException("Cannot perform column family deletion before timestamp.");
        }
    }

    static void throwIfUnsupportedDeleteRow(Delete operation) {
        if (operation.getTimeStamp() != Long.MAX_VALUE) {
            throw new UnsupportedOperationException("Cannot perform row deletion at timestamp.");
        }
    }

    static void throwIfUnsupportedPointDelete(Cell cell) {
        if (cell.getTimestamp() == Long.MAX_VALUE) {
            throw new UnsupportedOperationException("Cannot delete single latest cell.");
        }
    }

    static void addDeleteFromColumnMods(ByteString familyByteString, Cell cell, MutationApi<?> mutation) {
        ByteString cellQualifierByteString = ByteString.copyFrom(cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength());
        long endTimestamp = TimestampConverter.hbase2bigtable(cell.getTimestamp() + 1L);
        if (DeleteAdapter.isPointDelete(cell)) {
            long startTimestamp = TimestampConverter.hbase2bigtable(cell.getTimestamp());
            mutation.deleteCells(familyByteString.toStringUtf8(), cellQualifierByteString, Range.TimestampRange.create(startTimestamp, endTimestamp));
        } else if (cell.getTimestamp() != Long.MAX_VALUE) {
            mutation.deleteCells(familyByteString.toStringUtf8(), cellQualifierByteString, (Range.TimestampRange)Range.TimestampRange.unbounded().endOpen(endTimestamp));
        } else {
            mutation.deleteCells(familyByteString.toStringUtf8(), cellQualifierByteString);
        }
    }

    @Override
    public void adapt(Delete operation, MutationApi<?> mutation) {
        if (operation.getFamilyCellMap().isEmpty()) {
            DeleteAdapter.throwIfUnsupportedDeleteRow(operation);
            mutation.deleteRow();
        } else {
            for (Map.Entry entry : operation.getFamilyCellMap().entrySet()) {
                ByteString familyByteString = ByteString.copyFrom((byte[])entry.getKey());
                for (Cell cell : (List)entry.getValue()) {
                    if (DeleteAdapter.isColumnDelete(cell) || DeleteAdapter.isPointDelete(cell)) {
                        if (DeleteAdapter.isPointDelete(cell)) {
                            DeleteAdapter.throwIfUnsupportedPointDelete(cell);
                        }
                        DeleteAdapter.addDeleteFromColumnMods(familyByteString, cell, mutation);
                        continue;
                    }
                    if (DeleteAdapter.isFamilyDelete(cell)) {
                        DeleteAdapter.throwIfUnsupportedDeleteFamily(cell);
                        mutation.deleteFamily(familyByteString.toStringUtf8());
                        continue;
                    }
                    if (DeleteAdapter.isFamilyVersionDelete(cell)) {
                        DeleteAdapter.throwOnUnsupportedDeleteFamilyVersion(cell);
                        continue;
                    }
                    DeleteAdapter.throwOnUnsupportedCellType(cell);
                }
            }
        }
    }
}

