/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.wrappers.veneer;

import com.google.bigtable.repackaged.com.google.api.core.ApiFunction;
import com.google.bigtable.repackaged.com.google.api.core.ApiFuture;
import com.google.bigtable.repackaged.com.google.api.core.ApiFutures;
import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.api.gax.batching.Batcher;
import com.google.bigtable.repackaged.com.google.api.gax.grpc.GrpcCallContext;
import com.google.bigtable.repackaged.com.google.bigtable.v2.RowFilter;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.BigtableDataClient;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.Filters;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.Row;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.MoreExecutors;
import com.google.bigtable.repackaged.com.google.protobuf.ByteString;
import com.google.bigtable.repackaged.javax.annotation.Nullable;
import com.google.cloud.bigtable.hbase.adapters.Adapters;
import com.google.cloud.bigtable.hbase.wrappers.BulkReadWrapper;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.hbase.client.Result;

@InternalApi(value="For internal usage only")
public class BulkReadVeneerApi
implements BulkReadWrapper {
    private static final Executor CLEANUP_EXECUTOR = Executors.newSingleThreadExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            thread.setDaemon(true);
            thread.setName("bigtable-bulkread-cleanup");
            return thread;
        }
    });
    private final BigtableDataClient client;
    private final String tableId;
    private final Map<RowFilter, Batcher<ByteString, Row>> batchers;
    private final AtomicLong cleanupBarrier;
    private AtomicBoolean isClosed = new AtomicBoolean(false);
    private final GrpcCallContext callContext;

    BulkReadVeneerApi(BigtableDataClient client, String tableId, GrpcCallContext callContext) {
        this.client = client;
        this.tableId = tableId;
        this.callContext = callContext;
        this.batchers = new HashMap<RowFilter, Batcher<ByteString, Row>>();
        this.cleanupBarrier = new AtomicLong(1L);
    }

    @Override
    public void close() {
        if (!this.isClosed.compareAndSet(false, true)) {
            return;
        }
        this.notifyArrival();
    }

    @Override
    public ApiFuture<Result> add(ByteString rowKey, @Nullable Filters.Filter filter) {
        Preconditions.checkState(!this.isClosed.get(), "can't add request when the bulk read is closed.");
        this.cleanupBarrier.incrementAndGet();
        ApiFuture<Row> rowFuture = this.getOrCreateBatcher(filter).add(rowKey);
        rowFuture.addListener(new Runnable(){

            @Override
            public void run() {
                BulkReadVeneerApi.this.notifyArrival();
            }
        }, MoreExecutors.directExecutor());
        return ApiFutures.transform(rowFuture, new ApiFunction<Row, Result>(){

            @Override
            public Result apply(Row row) {
                return Adapters.ROW_ADAPTER.adaptResponse(row);
            }
        }, MoreExecutors.directExecutor());
    }

    private void notifyArrival() {
        if (this.cleanupBarrier.decrementAndGet() == 0L) {
            this.cleanUp();
        }
    }

    private void cleanUp() {
        CLEANUP_EXECUTOR.execute(new Runnable(){

            @Override
            public void run() {
                for (Batcher batcher : BulkReadVeneerApi.this.batchers.values()) {
                    try {
                        batcher.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
        });
    }

    @Override
    public void sendOutstanding() {
        for (Batcher<ByteString, Row> batcher : this.batchers.values()) {
            batcher.sendOutstanding();
        }
    }

    private Batcher<ByteString, Row> getOrCreateBatcher(@Nullable Filters.Filter filter) {
        RowFilter proto = filter == null ? null : filter.toProto();
        Batcher<ByteString, Row> batcher = this.batchers.get(proto);
        if (batcher == null) {
            batcher = this.client.newBulkReadRowsBatcher(this.tableId, filter, this.callContext);
            this.batchers.put(proto, batcher);
        }
        return batcher;
    }
}

