/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.google.bigtable.repackaged.com.google.api.core.ApiFuture;
import com.google.bigtable.repackaged.com.google.api.core.ApiFutureCallback;
import com.google.bigtable.repackaged.com.google.api.core.ApiFutures;
import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.FailedPreconditionException;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.models.Backup;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.models.Cluster;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.models.CreateBackupRequest;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.models.CreateTableRequest;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.models.ModifyColumnFamiliesRequest;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.models.RestoreTableRequest;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.models.Table;
import com.google.bigtable.repackaged.com.google.common.base.MoreObjects;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.common.base.Strings;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.ListenableFuture;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.MoreExecutors;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.SettableFuture;
import com.google.bigtable.repackaged.com.google.protobuf.ByteString;
import com.google.bigtable.repackaged.io.grpc.Status;
import com.google.bigtable.repackaged.javax.annotation.Nullable;
import com.google.bigtable.repackaged.org.threeten.bp.Instant;
import com.google.bigtable.repackaged.org.threeten.bp.temporal.ChronoUnit;
import com.google.cloud.bigtable.hbase.adapters.admin.TableAdapter;
import com.google.cloud.bigtable.hbase.util.FutureUtil;
import com.google.cloud.bigtable.hbase.util.Logger;
import com.google.cloud.bigtable.hbase.util.ModifyTableBuilder;
import com.google.cloud.bigtable.hbase.wrappers.AdminClientWrapper;
import com.google.cloud.bigtable.hbase.wrappers.BigtableHBaseSettings;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableExistsException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotEnabledException;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.CommonConnection;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.hadoop.hbase.regionserver.wal.FailedLogCloseException;
import org.apache.hadoop.hbase.snapshot.RestoreSnapshotException;
import org.apache.hadoop.hbase.snapshot.SnapshotCreationException;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;

@InternalApi(value="For internal usage only")
public abstract class AbstractBigtableAdmin
implements Admin {
    protected final Logger LOG = new Logger(this.getClass());
    private final Set<TableName> disabledTables;
    private final Configuration configuration;
    private final BigtableHBaseSettings settings;
    protected final CommonConnection connection;
    protected final AdminClientWrapper adminClientWrapper;
    private String bigtableSnapshotClusterId;

    public AbstractBigtableAdmin(CommonConnection connection) throws IOException {
        this.LOG.debug("Creating BigtableAdmin", new Object[0]);
        this.configuration = connection.getConfiguration();
        this.settings = connection.getBigtableSettings();
        this.connection = connection;
        this.disabledTables = connection.getDisabledTables();
        this.adminClientWrapper = connection.getBigtableApi().getAdminClient();
        String clusterId = this.configuration.get("google.bigtable.snapshot.cluster.id", null);
        if (clusterId != null) {
            this.bigtableSnapshotClusterId = clusterId;
        }
    }

    public Connection getConnection() {
        return (Connection)this.connection;
    }

    public boolean tableExists(TableName tableName) throws IOException {
        for (TableName existingTableName : this.listTableNames(tableName.getNameAsString())) {
            if (!existingTableName.equals((Object)tableName)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public boolean tableExists(String tableName) throws IOException {
        return this.tableExists(TableName.valueOf((String)tableName));
    }

    public HTableDescriptor[] listTables() throws IOException {
        return this.getTableDescriptorsIgnoreFailure(this.listTableNames());
    }

    private HTableDescriptor[] getTableDescriptors(TableName[] tableNames) throws IOException {
        HTableDescriptor[] response = new HTableDescriptor[tableNames.length];
        for (int i = 0; i < tableNames.length; ++i) {
            response[i] = this.getTableDescriptor(tableNames[i]);
        }
        return response;
    }

    private HTableDescriptor[] getTableDescriptorsIgnoreFailure(TableName[] tableNames) throws IOException {
        ArrayList<HTableDescriptor> descriptors = new ArrayList<HTableDescriptor>();
        for (TableName tableName : tableNames) {
            try {
                descriptors.add(this.getTableDescriptor(tableName));
            }
            catch (IOException ex) {
                if (ex instanceof TableNotFoundException || ex.getCause() instanceof FailedPreconditionException || Status.Code.FAILED_PRECONDITION == Status.fromThrowable(ex.getCause()).getCode()) continue;
                throw ex;
            }
        }
        return descriptors.toArray(new HTableDescriptor[0]);
    }

    public HTableDescriptor[] listTables(Pattern pattern) throws IOException {
        return this.getTableDescriptorsIgnoreFailure(this.listTableNames(pattern));
    }

    public HTableDescriptor[] listTables(Pattern pattern, boolean includeSysTables) throws IOException {
        return this.listTables(pattern);
    }

    @Deprecated
    public TableName[] listTableNames(String patternStr) throws IOException {
        return this.listTableNames(Pattern.compile(patternStr));
    }

    public TableName[] listTableNames(Pattern pattern) throws IOException {
        if (pattern == null) {
            return this.listTableNames();
        }
        ArrayList<TableName> result = new ArrayList<TableName>();
        for (TableName tableName : this.listTableNames()) {
            if (!pattern.matcher(tableName.getNameAsString()).matches()) continue;
            result.add(tableName);
        }
        return result.toArray(new TableName[result.size()]);
    }

    public TableName[] listTableNames(Pattern pattern, boolean includeSysTables) throws IOException {
        return this.listTableNames(pattern);
    }

    public TableName[] listTableNames(String regex, boolean includeSysTables) throws IOException {
        return this.listTableNames(regex);
    }

    public HTableDescriptor[] listTables(String regex) throws IOException {
        return this.listTables(Pattern.compile(regex));
    }

    public HTableDescriptor[] listTables(String regex, boolean includeSysTables) throws IOException {
        return this.listTables(regex);
    }

    public TableName[] listTableNames() throws IOException {
        List<String> tablesList = FutureUtil.unwrap(this.adminClientWrapper.listTablesAsync());
        TableName[] result = new TableName[tablesList.size()];
        for (int i = 0; i < tablesList.size(); ++i) {
            result[i] = TableName.valueOf((String)tablesList.get(i));
        }
        return result;
    }

    public HTableDescriptor getTableDescriptor(TableName tableName) throws IOException {
        if (tableName == null) {
            return null;
        }
        try {
            return TableAdapter.adapt(FutureUtil.unwrap(this.adminClientWrapper.getTableAsync(tableName.getNameAsString())));
        }
        catch (Throwable throwable) {
            if (Status.fromThrowable(throwable).getCode() == Status.Code.NOT_FOUND) {
                throw new TableNotFoundException(tableName);
            }
            throw new IOException("Failed to getTableDescriptor() on " + tableName, throwable);
        }
    }

    @Deprecated
    public String[] getTableNames(String regex) throws IOException {
        TableName[] tableNames = this.listTableNames(regex);
        String[] tableIds = new String[tableNames.length];
        for (int i = 0; i < tableNames.length; ++i) {
            tableIds[i] = tableNames[i].getNameAsString();
        }
        return tableIds;
    }

    public void createTable(HTableDescriptor desc) throws IOException {
        this.createTable(desc, (byte[][])null);
    }

    public void createTable(HTableDescriptor desc, byte[] startKey, byte[] endKey, int numRegions) throws IOException {
        this.createTable(desc, AbstractBigtableAdmin.createSplitKeys(startKey, endKey, numRegions));
    }

    public static byte[][] createSplitKeys(byte[] startKey, byte[] endKey, int numRegions) {
        Object splitKeys;
        if (numRegions < 3) {
            throw new IllegalArgumentException("Must create at least three regions");
        }
        if (Bytes.compareTo((byte[])startKey, (byte[])endKey) >= 0) {
            throw new IllegalArgumentException("Start key must be smaller than end key");
        }
        if (numRegions == 3) {
            splitKeys = new byte[][]{startKey, endKey};
        } else {
            splitKeys = Bytes.split((byte[])startKey, (byte[])endKey, (int)(numRegions - 3));
            if (splitKeys == null || ((byte[][])splitKeys).length != numRegions - 1) {
                throw new IllegalArgumentException("Unable to split key range into enough regions");
            }
        }
        return splitKeys;
    }

    public void createTable(HTableDescriptor desc, byte[][] splitKeys) throws IOException {
        this.createTable(desc.getTableName(), TableAdapter.adapt(desc, splitKeys));
    }

    protected void createTable(TableName tableName, CreateTableRequest request) throws IOException {
        try {
            FutureUtil.unwrap(this.adminClientWrapper.createTableAsync(request));
        }
        catch (Throwable throwable) {
            throw AbstractBigtableAdmin.convertToTableExistsException(tableName, throwable);
        }
    }

    public void createTableAsync(HTableDescriptor desc, byte[][] splitKeys) throws IOException {
        this.LOG.warn("Creating the table synchronously", new Object[0]);
        this.createTableAsync(desc.getTableName(), TableAdapter.adapt(desc, splitKeys));
    }

    protected ListenableFuture<Table> createTableAsync(final TableName tableName, CreateTableRequest request) throws IOException {
        ApiFuture<Table> future = this.adminClientWrapper.createTableAsync(request);
        final SettableFuture<Table> settableFuture = SettableFuture.create();
        ApiFutures.addCallback(future, new ApiFutureCallback<Table>(){

            @Override
            public void onSuccess(@Nullable Table result) {
                settableFuture.set(result);
            }

            @Override
            public void onFailure(Throwable t) {
                settableFuture.setException(AbstractBigtableAdmin.convertToTableExistsException(tableName, t));
            }
        }, MoreExecutors.directExecutor());
        return settableFuture;
    }

    public static IOException convertToTableExistsException(TableName tableName, Throwable throwable) {
        if (Status.fromThrowable(throwable).getCode() == Status.Code.ALREADY_EXISTS) {
            return new TableExistsException(tableName);
        }
        return new IOException(String.format("Failed to create table '%s'", tableName), throwable);
    }

    public void deleteTable(TableName tableName) throws IOException {
        try {
            FutureUtil.unwrap(this.adminClientWrapper.deleteTableAsync(tableName.getNameAsString()));
        }
        catch (Throwable throwable) {
            throw new IOException(String.format("Failed to delete table '%s'", tableName.getNameAsString()), throwable);
        }
        this.disabledTables.remove(tableName);
    }

    public HTableDescriptor[] deleteTables(String regex) throws IOException {
        return this.deleteTables(Pattern.compile(regex));
    }

    public HTableDescriptor[] deleteTables(Pattern pattern) throws IOException {
        LinkedList<HTableDescriptor> failed = new LinkedList<HTableDescriptor>();
        for (HTableDescriptor table : this.listTables(pattern)) {
            try {
                this.deleteTable(table.getTableName());
            }
            catch (IOException ex) {
                this.LOG.info("Failed to delete table " + table.getTableName(), ex, new Object[0]);
                failed.add(table);
            }
        }
        return failed.toArray(new HTableDescriptor[failed.size()]);
    }

    public void enableTable(TableName tableName) throws IOException {
        TableName.isLegalFullyQualifiedTableName((byte[])tableName.getName());
        if (!this.tableExists(tableName)) {
            throw new TableNotFoundException(tableName);
        }
        this.disabledTables.remove(tableName);
        this.LOG.warn("Table " + tableName + " was enabled in memory only.", new Object[0]);
    }

    @Deprecated
    public void enableTable(String tableName) throws IOException {
        this.enableTable(TableName.valueOf((String)tableName));
    }

    public HTableDescriptor[] enableTables(String regex) throws IOException {
        HTableDescriptor[] tableDescriptors;
        for (HTableDescriptor descriptor : tableDescriptors = this.listTables(regex)) {
            this.enableTable(descriptor.getTableName());
        }
        return tableDescriptors;
    }

    public HTableDescriptor[] enableTables(Pattern pattern) throws IOException {
        HTableDescriptor[] tableDescriptors;
        for (HTableDescriptor descriptor : tableDescriptors = this.listTables(pattern)) {
            this.enableTable(descriptor.getTableName());
        }
        return tableDescriptors;
    }

    public void disableTable(TableName tableName) throws IOException {
        TableName.isLegalFullyQualifiedTableName((byte[])tableName.getName());
        if (!this.tableExists(tableName)) {
            throw new TableNotFoundException(tableName);
        }
        if (this.isTableDisabled(tableName)) {
            throw new TableNotEnabledException(tableName);
        }
        this.disabledTables.add(tableName);
        this.LOG.warn("Table " + tableName + " was disabled in memory only.", new Object[0]);
    }

    @Deprecated
    public void disableTable(String tableName) throws IOException {
        this.disableTable(TableName.valueOf((String)tableName));
    }

    public HTableDescriptor[] disableTables(String regex) throws IOException {
        HTableDescriptor[] tableDescriptors;
        for (HTableDescriptor descriptor : tableDescriptors = this.listTables(regex)) {
            this.disableTable(descriptor.getTableName());
        }
        return tableDescriptors;
    }

    public HTableDescriptor[] disableTables(Pattern pattern) throws IOException {
        HTableDescriptor[] tableDescriptors;
        for (HTableDescriptor descriptor : tableDescriptors = this.listTables(pattern)) {
            this.disableTable(descriptor.getTableName());
        }
        return tableDescriptors;
    }

    public boolean isTableEnabled(TableName tableName) throws IOException {
        return !this.isTableDisabled(tableName);
    }

    @Deprecated
    public boolean isTableEnabled(String tableName) throws IOException {
        return this.isTableEnabled(TableName.valueOf((String)tableName));
    }

    public boolean isTableDisabled(TableName tableName) throws IOException {
        Preconditions.checkNotNull(tableName, "TableName cannot be null");
        return this.disabledTables.contains(tableName);
    }

    @Deprecated
    public boolean isTableDisabled(String tableName) throws IOException {
        return this.isTableDisabled(TableName.valueOf((String)tableName));
    }

    public boolean isTableAvailable(TableName tableName) throws IOException {
        return this.tableExists(tableName);
    }

    public void addColumn(TableName tableName, HColumnDescriptor column) throws IOException {
        this.modifyColumns(tableName, column.getNameAsString(), "add", ModifyTableBuilder.newBuilder(tableName).add(column));
    }

    public void modifyColumn(TableName tableName, HColumnDescriptor column) throws IOException {
        this.modifyColumns(tableName, column.getNameAsString(), "modify", ModifyTableBuilder.newBuilder(tableName).modify(column));
    }

    public void deleteColumn(TableName tableName, byte[] columnName) throws IOException {
        String name = Bytes.toString((byte[])columnName);
        this.modifyColumns(tableName, name, "delete", ModifyTableBuilder.newBuilder(tableName).delete(name));
    }

    public void modifyTable(TableName tableName, HTableDescriptor newDescriptor) throws IOException {
        if (this.isTableAvailable(tableName)) {
            try {
                ModifyColumnFamiliesRequest request = ModifyTableBuilder.buildModifications(newDescriptor, this.getTableDescriptor(tableName)).build();
                FutureUtil.unwrap(this.adminClientWrapper.modifyFamiliesAsync(request));
            }
            catch (Throwable throwable) {
                throw new IOException(String.format("Failed to modify table '%s'", tableName.getNameAsString()), throwable);
            }
        } else {
            throw new TableNotFoundException(tableName);
        }
    }

    protected Void modifyColumns(TableName tableName, String columnName, String modificationType, ModifyTableBuilder builder) throws IOException {
        try {
            FutureUtil.unwrap(this.adminClientWrapper.modifyFamiliesAsync(builder.build()));
            return null;
        }
        catch (Throwable throwable) {
            throw new IOException(String.format("Failed to %s column '%s' in table '%s'", modificationType, columnName, tableName.getNameAsString()), throwable);
        }
    }

    @Deprecated
    public void addColumn(String tableName, HColumnDescriptor column) throws IOException {
        this.addColumn(TableName.valueOf((String)tableName), column);
    }

    public void modifyColumns(String tableName, HColumnDescriptor descriptor) throws IOException {
        this.modifyColumn(TableName.valueOf((String)tableName), descriptor);
    }

    @Deprecated
    public void deleteColumn(String tableName, byte[] columnName) throws IOException {
        this.deleteColumn(TableName.valueOf((String)tableName), columnName);
    }

    @Deprecated
    public void deleteColumn(String tableName, String columnName) throws IOException {
        this.deleteColumn(TableName.valueOf((String)tableName), Bytes.toBytes((String)columnName));
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public List<HRegionInfo> getTableRegions(TableName tableName) throws IOException {
        return this.connection.getAllRegionInfos(tableName);
    }

    public void close() throws IOException {
    }

    public HTableDescriptor[] getTableDescriptorsByTableName(List<TableName> tableNames) throws IOException {
        if (tableNames == null || tableNames.isEmpty()) {
            return this.listTables();
        }
        TableName[] tableNameArray = tableNames.toArray(new TableName[tableNames.size()]);
        return this.getTableDescriptors(tableNameArray);
    }

    public HTableDescriptor[] getTableDescriptors(List<String> names) throws IOException {
        Preconditions.checkNotNull(names);
        if (names.isEmpty()) {
            return this.listTables();
        }
        TableName[] tableNameArray = new TableName[names.size()];
        for (int i = 0; i < names.size(); ++i) {
            tableNameArray[i] = TableName.valueOf((String)names.get(i));
        }
        return this.getTableDescriptors(tableNameArray);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("project", this.settings.getProjectId()).add("instance", this.settings.getInstanceId()).add("adminHost", this.settings.getAdminHost()).toString();
    }

    public int getOperationTimeout() {
        throw new UnsupportedOperationException("getOperationTimeout");
    }

    public void abort(String why, Throwable e) {
        throw new UnsupportedOperationException("abort");
    }

    public boolean isAborted() {
        throw new UnsupportedOperationException("isAborted");
    }

    public void truncateTable(TableName tableName, boolean preserveSplits) throws IOException {
        if (!preserveSplits) {
            this.LOG.info("truncate will preserveSplits. The passed in variable is ignored.", new Object[0]);
        }
        try {
            FutureUtil.unwrap(this.adminClientWrapper.dropAllRowsAsync(tableName.getNameAsString()));
        }
        catch (Throwable throwable) {
            throw new IOException(String.format("Failed to truncate table '%s'", tableName.getNameAsString()), throwable);
        }
        this.disabledTables.remove(tableName);
    }

    public void deleteRowRangeByPrefix(TableName tableName, byte[] prefix) throws IOException {
        try {
            FutureUtil.unwrap(this.adminClientWrapper.dropRowRangeAsync(tableName.getNameAsString(), ByteString.copyFrom(prefix)));
        }
        catch (Throwable throwable) {
            throw new IOException(String.format("Failed to truncate table '%s'", tableName.getNameAsString()), throwable);
        }
    }

    public boolean isTableAvailable(TableName tableName, byte[][] splitKeys) throws IOException {
        return this.tableExists(tableName);
    }

    public Pair<Integer, Integer> getAlterStatus(TableName tableName) throws IOException {
        return new Pair((Object)0, (Object)0);
    }

    public Pair<Integer, Integer> getAlterStatus(byte[] tableName) throws IOException {
        return this.getAlterStatus(TableName.valueOf((byte[])tableName));
    }

    public Pair<Integer, Integer> getAlterStatus(String tableName) throws IOException {
        return this.getAlterStatus(TableName.valueOf((String)tableName));
    }

    public void snapshot(byte[] snapshotId, byte[] tableName) throws IOException, IllegalArgumentException {
        this.snapshot(snapshotId, TableName.valueOf((byte[])tableName));
    }

    public void snapshot(String snapshotId, TableName tableName) throws IOException, SnapshotCreationException, IllegalArgumentException {
        this.snapshotTable(snapshotId, tableName);
    }

    public void snapshot(byte[] snapshotId, TableName tableName) throws IOException, IllegalArgumentException {
        this.snapshot(Bytes.toString((byte[])snapshotId), tableName);
    }

    public void cloneSnapshot(byte[] snapshotId, byte[] tableName) throws IOException {
        this.cloneSnapshot(snapshotId, TableName.valueOf((byte[])tableName));
    }

    public void cloneSnapshot(byte[] snapshotName, TableName tableName) throws IOException, TableExistsException, RestoreSnapshotException {
        this.cloneSnapshot(Bytes.toString((byte[])snapshotName), tableName);
    }

    public void cloneSnapshot(String snapshotId, TableName tableName) throws IOException, TableExistsException, RestoreSnapshotException {
        RestoreTableRequest request = RestoreTableRequest.of(this.getBackupClusterId(), snapshotId).setTableId(tableName.getNameAsString());
        FutureUtil.unwrap(this.adminClientWrapper.restoreTableAsync(request));
    }

    public void deleteSnapshot(byte[] snapshotId) throws IOException {
        this.deleteSnapshot(Bytes.toString((byte[])snapshotId));
    }

    public void deleteSnapshot(String snapshotId) throws IOException {
        Preconditions.checkNotNull(snapshotId);
        if (snapshotId.isEmpty()) {
            return;
        }
        FutureUtil.unwrap(this.adminClientWrapper.deleteBackupAsync(this.getBackupClusterId(), snapshotId));
    }

    protected Backup snapshotTable(String snapshotId, TableName tableName) throws IOException {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(snapshotId));
        Preconditions.checkArgument(!Strings.isNullOrEmpty(tableName.getNameAsString()));
        CreateBackupRequest request = CreateBackupRequest.of(this.getBackupClusterId(), snapshotId).setSourceTableId(tableName.getNameAsString());
        int ttlSecondsForBackup = this.settings.getTtlSecondsForBackup();
        if (ttlSecondsForBackup <= 0) {
            throw new IllegalArgumentException("google.bigtable.snapshot.default.ttl.secs must be > 0");
        }
        Instant expireTime = Instant.now().plus((long)ttlSecondsForBackup, ChronoUnit.SECONDS);
        request.setExpireTime(expireTime);
        return FutureUtil.unwrap(this.adminClientWrapper.createBackupAsync(request));
    }

    public void deleteSnapshots(String regex) throws IOException {
        throw new UnsupportedOperationException("use deleteSnapshot instead");
    }

    public void deleteSnapshots(Pattern pattern) throws IOException {
        throw new UnsupportedOperationException("use deleteSnapshot instead");
    }

    public void deleteTableSnapshots(String tableNameRegex, String snapshotNameRegex) throws IOException {
        throw new UnsupportedOperationException("Unsupported - please use deleteSnapshots");
    }

    public void deleteTableSnapshots(Pattern tableNamePattern, Pattern snapshotNamePattern) throws IOException {
        throw new UnsupportedOperationException("Unsupported - please use deleteSnapshots");
    }

    public void restoreSnapshot(byte[] snapshotName) throws IOException, RestoreSnapshotException {
        throw new UnsupportedOperationException("restoreSnapshot");
    }

    public void restoreSnapshot(String snapshotName) throws IOException, RestoreSnapshotException {
        throw new UnsupportedOperationException("restoreSnapshot");
    }

    public void restoreSnapshot(byte[] snapshotName, boolean takeFailSafeSnapshot) throws IOException, RestoreSnapshotException {
        throw new UnsupportedOperationException("restoreSnapshot");
    }

    public void restoreSnapshot(String snapshotName, boolean takeFailSafeSnapshot) throws IOException, RestoreSnapshotException {
        throw new UnsupportedOperationException("restoreSnapshot");
    }

    protected synchronized String getBackupClusterId() {
        if (this.bigtableSnapshotClusterId == null) {
            List<Cluster> clusters = this.adminClientWrapper.listClusters(this.settings.getInstanceId());
            Preconditions.checkState(clusters.size() == 1, String.format("Project '%s' / Instance '%s' has %d clusters. There must be exactly 1 for this operation to work.", this.settings.getProjectId(), this.settings.getInstanceId(), clusters.size()));
            this.bigtableSnapshotClusterId = clusters.get(0).getId();
        }
        return this.bigtableSnapshotClusterId;
    }

    public void closeRegion(String regionname, String serverName) throws IOException {
        throw new UnsupportedOperationException("closeRegion");
    }

    public void closeRegion(byte[] regionname, String serverName) throws IOException {
        throw new UnsupportedOperationException("closeRegion");
    }

    public boolean closeRegionWithEncodedRegionName(String encodedRegionName, String serverName) throws IOException {
        throw new UnsupportedOperationException("closeRegionWithEncodedRegionName");
    }

    public void closeRegion(ServerName sn, HRegionInfo hri) throws IOException {
        throw new UnsupportedOperationException("closeRegion");
    }

    public List<HRegionInfo> getOnlineRegions(ServerName sn) throws IOException {
        throw new UnsupportedOperationException("getOnlineRegions");
    }

    public void flush(TableName tableName) throws IOException {
        throw new UnsupportedOperationException("flush");
    }

    public void flushRegion(byte[] bytes) throws IOException {
        this.LOG.info("flushRegion is a no-op", new Object[0]);
    }

    public void compact(TableName tableName) throws IOException {
        this.LOG.info("compact is a no-op", new Object[0]);
    }

    public void compactRegion(byte[] bytes) throws IOException {
        this.LOG.info("compactRegion is a no-op", new Object[0]);
    }

    public void compact(TableName tableName, byte[] bytes) throws IOException {
        this.LOG.info("compact is a no-op", new Object[0]);
    }

    public void compactRegion(byte[] bytes, byte[] bytes2) throws IOException {
        this.LOG.info("compactRegion is a no-op", new Object[0]);
    }

    public void majorCompact(TableName tableName) throws IOException {
        this.LOG.info("majorCompact is a no-op", new Object[0]);
    }

    public void majorCompactRegion(byte[] bytes) throws IOException {
        this.LOG.info("majorCompactRegion is a no-op", new Object[0]);
    }

    public void majorCompact(TableName tableName, byte[] bytes) throws IOException {
        this.LOG.info("majorCompact is a no-op", new Object[0]);
    }

    public void majorCompactRegion(byte[] bytes, byte[] bytes2) throws IOException {
        this.LOG.info("majorCompactRegion is a no-op", new Object[0]);
    }

    public void compactRegionServer(ServerName serverName, boolean b) throws IOException {
        this.LOG.info("compactRegionServer is a no-op", new Object[0]);
    }

    public void move(byte[] encodedRegionName, byte[] destServerName) throws HBaseIOException, MasterNotRunningException, ZooKeeperConnectionException {
        this.LOG.info("move is a no-op", new Object[0]);
    }

    public void assign(byte[] regionName) throws MasterNotRunningException, ZooKeeperConnectionException, IOException {
        this.LOG.info("assign is a no-op", new Object[0]);
    }

    public void unassign(byte[] regionName, boolean force) throws MasterNotRunningException, ZooKeeperConnectionException, IOException {
        this.LOG.info("unassign is a no-op", new Object[0]);
    }

    public void offline(byte[] regionName) throws IOException {
        throw new UnsupportedOperationException("offline");
    }

    public boolean setBalancerRunning(boolean on, boolean synchronous) throws MasterNotRunningException, ZooKeeperConnectionException {
        throw new UnsupportedOperationException("setBalancerRunning");
    }

    public boolean balancer() throws MasterNotRunningException, ZooKeeperConnectionException {
        throw new UnsupportedOperationException("balancer");
    }

    public boolean enableCatalogJanitor(boolean enable) throws MasterNotRunningException {
        throw new UnsupportedOperationException("enableCatalogJanitor");
    }

    public int runCatalogScan() throws MasterNotRunningException {
        throw new UnsupportedOperationException("runCatalogScan");
    }

    public boolean isCatalogJanitorEnabled() throws MasterNotRunningException {
        throw new UnsupportedOperationException("isCatalogJanitorEnabled");
    }

    public void mergeRegions(byte[] encodedNameOfRegionA, byte[] encodedNameOfRegionB, boolean forcible) throws IOException {
        this.LOG.info("mergeRegions is a no-op", new Object[0]);
    }

    public void split(TableName tableName) throws IOException {
        this.LOG.info("split is a no-op", new Object[0]);
    }

    public void splitRegion(byte[] bytes) throws IOException {
        this.LOG.info("splitRegion is a no-op", new Object[0]);
    }

    public void split(TableName tableName, byte[] bytes) throws IOException {
        this.LOG.info("split is a no-op", new Object[0]);
    }

    public void splitRegion(byte[] bytes, byte[] bytes2) throws IOException {
        this.LOG.info("split is a no-op", new Object[0]);
    }

    public void shutdown() throws IOException {
        throw new UnsupportedOperationException("shutdown");
    }

    public void stopMaster() throws IOException {
        throw new UnsupportedOperationException("stopMaster");
    }

    public void stopRegionServer(String hostnamePort) throws IOException {
        throw new UnsupportedOperationException("stopRegionServer");
    }

    public void createNamespace(NamespaceDescriptor descriptor) throws IOException {
        if (!this.provideWarningsForNamespaces()) {
            throw new UnsupportedOperationException("createNamespace");
        }
        this.LOG.warn("createNamespace is a no-op", new Object[0]);
    }

    public void modifyNamespace(NamespaceDescriptor descriptor) throws IOException {
        if (!this.provideWarningsForNamespaces()) {
            throw new UnsupportedOperationException("modifyNamespace");
        }
        this.LOG.warn("modifyNamespace is a no-op", new Object[0]);
    }

    public void deleteNamespace(String name) throws IOException {
        if (!this.provideWarningsForNamespaces()) {
            throw new UnsupportedOperationException("deleteNamespace");
        }
        this.LOG.warn("deleteNamespace is a no-op", new Object[0]);
    }

    public NamespaceDescriptor getNamespaceDescriptor(String name) throws IOException {
        if (this.provideWarningsForNamespaces()) {
            this.LOG.warn("getNamespaceDescriptor is a no-op", new Object[0]);
            return null;
        }
        throw new UnsupportedOperationException("getNamespaceDescriptor");
    }

    public NamespaceDescriptor[] listNamespaceDescriptors() throws IOException {
        if (this.provideWarningsForNamespaces()) {
            this.LOG.warn("listNamespaceDescriptors is a no-op", new Object[0]);
            return new NamespaceDescriptor[0];
        }
        throw new UnsupportedOperationException("listNamespaceDescriptors");
    }

    public HTableDescriptor[] listTableDescriptorsByNamespace(String name) throws IOException {
        if (this.provideWarningsForNamespaces()) {
            this.LOG.warn("listTableDescriptorsByNamespace is a no-op", new Object[0]);
            return new HTableDescriptor[0];
        }
        throw new UnsupportedOperationException("listTableDescriptorsByNamespace");
    }

    public TableName[] listTableNamesByNamespace(String name) throws IOException {
        if (this.provideWarningsForNamespaces()) {
            this.LOG.warn("listTableNamesByNamespace is a no-op", new Object[0]);
            return new TableName[0];
        }
        throw new UnsupportedOperationException("listTableNamesByNamespace");
    }

    private boolean provideWarningsForNamespaces() {
        return this.configuration.getBoolean("google.bigtable.namespace.warnings", false);
    }

    public String[] getMasterCoprocessors() {
        throw new UnsupportedOperationException("getMasterCoprocessors");
    }

    public void execProcedure(String signature, String instance, Map<String, String> props) throws IOException {
        throw new UnsupportedOperationException("execProcedure");
    }

    public byte[] execProcedureWithRet(String signature, String instance, Map<String, String> props) throws IOException {
        throw new UnsupportedOperationException("execProcedureWithRet");
    }

    public boolean isProcedureFinished(String signature, String instance, Map<String, String> props) throws IOException {
        throw new UnsupportedOperationException("isProcedureFinished");
    }

    public CoprocessorRpcChannel coprocessorService() {
        throw new UnsupportedOperationException("coprocessorService");
    }

    public CoprocessorRpcChannel coprocessorService(ServerName serverName) {
        throw new UnsupportedOperationException("coprocessorService");
    }

    public void updateConfiguration(ServerName serverName) throws IOException {
        throw new UnsupportedOperationException("updateConfiguration");
    }

    public void updateConfiguration() throws IOException {
        throw new UnsupportedOperationException("updateConfiguration");
    }

    public int getMasterInfoPort() throws IOException {
        throw new UnsupportedOperationException("getMasterInfoPort");
    }

    public void rollWALWriter(ServerName serverName) throws IOException, FailedLogCloseException {
        throw new UnsupportedOperationException("rollWALWriter");
    }

    public static class UnsupportedOperationsHandler
    implements InvocationHandler {
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            throw new UnsupportedOperationException(method.getName());
        }
    }
}

