/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.api.client.googleapis.auth.oauth2;

import com.google.bigtable.repackaged.com.google.api.client.auth.openidconnect.IdTokenVerifier;
import com.google.bigtable.repackaged.com.google.api.client.googleapis.auth.oauth2.GoogleIdToken;
import com.google.bigtable.repackaged.com.google.api.client.googleapis.auth.oauth2.GooglePublicKeysManager;
import com.google.bigtable.repackaged.com.google.api.client.http.HttpTransport;
import com.google.bigtable.repackaged.com.google.api.client.json.JsonFactory;
import com.google.bigtable.repackaged.com.google.api.client.util.Beta;
import com.google.bigtable.repackaged.com.google.api.client.util.Clock;
import com.google.bigtable.repackaged.com.google.api.client.util.Preconditions;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

@Beta
public class GoogleIdTokenVerifier
extends IdTokenVerifier {
    private final GooglePublicKeysManager publicKeys;

    public GoogleIdTokenVerifier(HttpTransport transport, JsonFactory jsonFactory) {
        this(new Builder(transport, jsonFactory));
    }

    public GoogleIdTokenVerifier(GooglePublicKeysManager publicKeys) {
        this(new Builder(publicKeys));
    }

    protected GoogleIdTokenVerifier(Builder builder) {
        super(builder);
        this.publicKeys = builder.publicKeys;
    }

    public final GooglePublicKeysManager getPublicKeysManager() {
        return this.publicKeys;
    }

    public final HttpTransport getTransport() {
        return this.publicKeys.getTransport();
    }

    public final JsonFactory getJsonFactory() {
        return this.publicKeys.getJsonFactory();
    }

    @Deprecated
    public final String getPublicCertsEncodedUrl() {
        return this.publicKeys.getPublicCertsEncodedUrl();
    }

    @Deprecated
    public final List<PublicKey> getPublicKeys() throws GeneralSecurityException, IOException {
        return this.publicKeys.getPublicKeys();
    }

    @Deprecated
    public final long getExpirationTimeMilliseconds() {
        return this.publicKeys.getExpirationTimeMilliseconds();
    }

    public boolean verify(GoogleIdToken googleIdToken) throws GeneralSecurityException, IOException {
        if (!super.verify(googleIdToken)) {
            return false;
        }
        for (PublicKey publicKey : this.publicKeys.getPublicKeys()) {
            if (!googleIdToken.verifySignature(publicKey)) continue;
            return true;
        }
        return false;
    }

    public GoogleIdToken verify(String idTokenString) throws GeneralSecurityException, IOException {
        GoogleIdToken idToken = GoogleIdToken.parse(this.getJsonFactory(), idTokenString);
        return this.verify(idToken) ? idToken : null;
    }

    @Deprecated
    public GoogleIdTokenVerifier loadPublicCerts() throws GeneralSecurityException, IOException {
        this.publicKeys.refresh();
        return this;
    }

    @Beta
    public static class Builder
    extends IdTokenVerifier.Builder {
        GooglePublicKeysManager publicKeys;

        public Builder(HttpTransport transport, JsonFactory jsonFactory) {
            this(new GooglePublicKeysManager(transport, jsonFactory));
        }

        public Builder(GooglePublicKeysManager publicKeys) {
            this.publicKeys = Preconditions.checkNotNull(publicKeys);
            this.setIssuers(Arrays.asList("accounts.google.com", "https://accounts.google.com"));
        }

        @Override
        public GoogleIdTokenVerifier build() {
            return new GoogleIdTokenVerifier(this);
        }

        public final GooglePublicKeysManager getPublicCerts() {
            return this.publicKeys;
        }

        public final HttpTransport getTransport() {
            return this.publicKeys.getTransport();
        }

        public final JsonFactory getJsonFactory() {
            return this.publicKeys.getJsonFactory();
        }

        @Deprecated
        public final String getPublicCertsEncodedUrl() {
            return this.publicKeys.getPublicCertsEncodedUrl();
        }

        @Deprecated
        public Builder setPublicCertsEncodedUrl(String publicKeysEncodedUrl) {
            this.publicKeys = new GooglePublicKeysManager.Builder(this.getTransport(), this.getJsonFactory()).setPublicCertsEncodedUrl(publicKeysEncodedUrl).setClock(this.publicKeys.getClock()).build();
            return this;
        }

        @Override
        public Builder setIssuer(String issuer) {
            return (Builder)super.setIssuer(issuer);
        }

        @Override
        public Builder setIssuers(Collection<String> issuers) {
            return (Builder)super.setIssuers(issuers);
        }

        @Override
        public Builder setAudience(Collection<String> audience) {
            return (Builder)super.setAudience(audience);
        }

        @Override
        public Builder setAcceptableTimeSkewSeconds(long acceptableTimeSkewSeconds) {
            return (Builder)super.setAcceptableTimeSkewSeconds(acceptableTimeSkewSeconds);
        }

        @Override
        public Builder setClock(Clock clock) {
            return (Builder)super.setClock(clock);
        }
    }
}

