/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.api.gax.httpjson;

import com.google.bigtable.repackaged.com.google.api.client.http.HttpTransport;
import com.google.bigtable.repackaged.com.google.api.client.http.javanet.NetHttpTransport;
import com.google.bigtable.repackaged.com.google.api.client.json.JsonFactory;
import com.google.bigtable.repackaged.com.google.api.client.json.gson.GsonFactory;
import com.google.bigtable.repackaged.com.google.api.core.ApiFuture;
import com.google.bigtable.repackaged.com.google.api.core.BetaApi;
import com.google.bigtable.repackaged.com.google.api.core.SettableApiFuture;
import com.google.bigtable.repackaged.com.google.api.gax.core.BackgroundResource;
import com.google.bigtable.repackaged.com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.bigtable.repackaged.com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.bigtable.repackaged.com.google.api.gax.httpjson.HttpJsonCallOptions;
import com.google.bigtable.repackaged.com.google.api.gax.httpjson.HttpJsonChannel;
import com.google.bigtable.repackaged.com.google.api.gax.httpjson.HttpJsonHeaderEnhancer;
import com.google.bigtable.repackaged.com.google.api.gax.httpjson.HttpRequestRunnable;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableList;
import com.google.bigtable.repackaged.javax.annotation.Nullable;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;

@BetaApi
public class ManagedHttpJsonChannel
implements HttpJsonChannel,
BackgroundResource {
    private static final JsonFactory JSON_FACTORY = GsonFactory.getDefaultInstance();
    private static final ExecutorService DEFAULT_EXECUTOR = InstantiatingExecutorProvider.newBuilder().build().getExecutor();
    private final Executor executor;
    private final String endpoint;
    private final JsonFactory jsonFactory;
    private final ImmutableList<HttpJsonHeaderEnhancer> headerEnhancers;
    private final HttpTransport httpTransport;
    private boolean isTransportShutdown;

    private ManagedHttpJsonChannel(Executor executor, String endpoint, JsonFactory jsonFactory, List<HttpJsonHeaderEnhancer> headerEnhancers, @Nullable HttpTransport httpTransport) {
        this.executor = executor;
        this.endpoint = endpoint;
        this.jsonFactory = jsonFactory;
        this.headerEnhancers = ImmutableList.copyOf(headerEnhancers);
        this.httpTransport = httpTransport == null ? new NetHttpTransport() : httpTransport;
    }

    @Override
    public <ResponseT, RequestT> ApiFuture<ResponseT> issueFutureUnaryCall(HttpJsonCallOptions callOptions, RequestT request, ApiMethodDescriptor<RequestT, ResponseT> methodDescriptor) {
        SettableApiFuture responseFuture = SettableApiFuture.create();
        HttpRequestRunnable runnable = HttpRequestRunnable.newBuilder().setResponseFuture(responseFuture).setApiMethodDescriptor(methodDescriptor).setHeaderEnhancers(this.headerEnhancers).setHttpJsonCallOptions(callOptions).setHttpTransport(this.httpTransport).setJsonFactory(this.jsonFactory).setRequest(request).setEndpoint(this.endpoint).build();
        this.executor.execute(runnable);
        return responseFuture;
    }

    @Override
    public synchronized void shutdown() {
        if (this.isTransportShutdown) {
            return;
        }
        try {
            this.httpTransport.shutdown();
            this.isTransportShutdown = true;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean isShutdown() {
        return this.isTransportShutdown;
    }

    @Override
    public boolean isTerminated() {
        return this.isTransportShutdown;
    }

    @Override
    public void shutdownNow() {
        this.shutdown();
    }

    @Override
    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return false;
    }

    @Override
    public void close() {
    }

    public static Builder newBuilder() {
        return new Builder().setHeaderEnhancers(new LinkedList<HttpJsonHeaderEnhancer>()).setExecutor(DEFAULT_EXECUTOR);
    }

    static /* synthetic */ JsonFactory access$100() {
        return JSON_FACTORY;
    }

    public static class Builder {
        private Executor executor;
        private String endpoint;
        private JsonFactory jsonFactory = ManagedHttpJsonChannel.access$100();
        private List<HttpJsonHeaderEnhancer> headerEnhancers;
        private HttpTransport httpTransport;

        private Builder() {
        }

        public Builder setExecutor(Executor executor) {
            this.executor = executor == null ? DEFAULT_EXECUTOR : executor;
            return this;
        }

        public Builder setEndpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder setHeaderEnhancers(List<HttpJsonHeaderEnhancer> headerEnhancers) {
            this.headerEnhancers = headerEnhancers;
            return this;
        }

        public Builder setHttpTransport(HttpTransport httpTransport) {
            this.httpTransport = httpTransport;
            return this;
        }

        public ManagedHttpJsonChannel build() {
            Preconditions.checkNotNull(this.endpoint);
            return new ManagedHttpJsonChannel(this.executor, this.endpoint, this.jsonFactory, this.headerEnhancers, this.httpTransport);
        }
    }
}

