/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.api.gax.rpc;

import com.google.bigtable.repackaged.com.google.api.core.BetaApi;
import com.google.bigtable.repackaged.com.google.api.core.InternalExtensionOnly;
import com.google.bigtable.repackaged.com.google.api.gax.retrying.RetrySettings;
import com.google.bigtable.repackaged.com.google.api.gax.retrying.RetryingContext;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.StatusCode;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.TransportChannel;
import com.google.bigtable.repackaged.com.google.api.gax.tracing.ApiTracer;
import com.google.bigtable.repackaged.com.google.auth.Credentials;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.javax.annotation.Nonnull;
import com.google.bigtable.repackaged.javax.annotation.Nullable;
import com.google.bigtable.repackaged.org.threeten.bp.Duration;
import java.util.List;
import java.util.Map;
import java.util.Set;

@InternalExtensionOnly
public interface ApiCallContext
extends RetryingContext {
    public ApiCallContext withCredentials(Credentials var1);

    public ApiCallContext withTransportChannel(TransportChannel var1);

    public ApiCallContext withTimeout(@Nullable Duration var1);

    @Nullable
    public Duration getTimeout();

    @BetaApi(value="The surface for streaming is not stable yet and may change in the future.")
    public ApiCallContext withStreamWaitTimeout(@Nullable Duration var1);

    @BetaApi(value="The surface for streaming is not stable yet and may change in the future.")
    @Nullable
    public Duration getStreamWaitTimeout();

    @BetaApi(value="The surface for streaming is not stable yet and may change in the future.")
    public ApiCallContext withStreamIdleTimeout(@Nullable Duration var1);

    @BetaApi(value="The surface for streaming is not stable yet and may change in the future.")
    @Nullable
    public Duration getStreamIdleTimeout();

    @Override
    @BetaApi(value="The surface for tracing is not stable yet and may change in the future")
    @Nonnull
    public ApiTracer getTracer();

    @BetaApi(value="The surface for tracing is not stable yet and may change in the future")
    public ApiCallContext withTracer(@Nonnull ApiTracer var1);

    @BetaApi
    public ApiCallContext withRetrySettings(RetrySettings var1);

    @BetaApi
    public ApiCallContext withRetryableCodes(Set<StatusCode.Code> var1);

    public ApiCallContext nullToSelf(ApiCallContext var1);

    public ApiCallContext merge(ApiCallContext var1);

    @BetaApi(value="The surface for extra headers is not stable yet and may change in the future.")
    public ApiCallContext withExtraHeaders(Map<String, List<String>> var1);

    @BetaApi(value="The surface for extra headers is not stable yet and may change in the future.")
    public Map<String, List<String>> getExtraHeaders();

    @BetaApi(value="The surface for call context options is not stable yet and may change in the future.")
    public <T> ApiCallContext withOption(Key<T> var1, T var2);

    @BetaApi(value="The surface for call context options is not stable yet and may change in the future.")
    public <T> T getOption(Key<T> var1);

    public static final class Key<T> {
        private final String name;

        private Key(String name) {
            this.name = name;
        }

        public static <T> Key<T> create(String name) {
            Preconditions.checkNotNull(name, "Key name cannot be null.");
            return new Key<T>(name);
        }
    }
}

