/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2;

import com.google.bigtable.repackaged.com.google.api.gax.core.CredentialsProvider;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.stub.BigtableInstanceAdminStubSettings;
import com.google.bigtable.repackaged.com.google.common.base.MoreObjects;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.common.base.Verify;
import com.google.bigtable.repackaged.javax.annotation.Nonnull;
import com.google.bigtable.repackaged.javax.annotation.Nullable;
import java.io.IOException;

public final class BigtableInstanceAdminSettings {
    private final String projectId;
    private final BigtableInstanceAdminStubSettings stubSettings;

    private BigtableInstanceAdminSettings(Builder builder) throws IOException {
        Preconditions.checkNotNull(builder.projectId, "Project ID must be set");
        Verify.verifyNotNull(builder.stubSettings, "stubSettings should never be null", new Object[0]);
        this.projectId = builder.projectId;
        this.stubSettings = builder.stubSettings.build();
    }

    @Nonnull
    public String getProjectId() {
        return this.projectId;
    }

    public CredentialsProvider getCredentialsProvider() {
        return this.stubSettings.getCredentialsProvider();
    }

    @Nonnull
    public BigtableInstanceAdminStubSettings getStubSettings() {
        return this.stubSettings;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("projectId", this.projectId).add("createInstanceSettings", this.stubSettings.createInstanceSettings()).add("createInstanceOperationSettings", this.stubSettings.createInstanceOperationSettings()).add("getInstanceSettings", this.stubSettings.getInstanceSettings()).add("listInstancesSettings", this.stubSettings.listInstancesSettings()).add("partialUpdateInstanceSettings", this.stubSettings.partialUpdateInstanceSettings()).add("partialUpdateInstanceOperationSettings", this.stubSettings.partialUpdateInstanceOperationSettings()).add("deleteInstanceSettings", this.stubSettings.deleteInstanceSettings()).add("createClusterSettings", this.stubSettings.createClusterSettings()).add("createClusterOperationSettings", this.stubSettings.createClusterOperationSettings()).add("getClusterSettings", this.stubSettings.getClusterSettings()).add("listClustersSettings", this.stubSettings.listClustersSettings()).add("updateClusterSettings", this.stubSettings.updateClusterSettings()).add("updateClusterOperationSettings", this.stubSettings.updateClusterOperationSettings()).add("deleteClusterSettings", this.stubSettings.deleteClusterSettings()).add("createAppProfileSettings", this.stubSettings.createAppProfileSettings()).add("getAppProfileSettings", this.stubSettings.getAppProfileSettings()).add("listAppProfilesSettings", this.stubSettings.listAppProfilesSettings()).add("updateAppProfileSettings", this.stubSettings.updateAppProfileSettings()).add("updateAppProfileOperationSettings", this.stubSettings.updateAppProfileOperationSettings()).add("deleteAppProfileSettings", this.stubSettings.deleteAppProfileSettings()).add("getIamPolicySettings", this.stubSettings.getIamPolicySettings()).add("setIamPolicySettings", this.stubSettings.setIamPolicySettings()).add("testIamPermissionsSettings", this.stubSettings.testIamPermissionsSettings()).add("stubSettings", this.stubSettings).toString();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static Builder newBuilder() {
        Preconditions.checkState(System.getenv("BIGTABLE_EMULATOR_HOST") == null, "BigtableInstanceAdminSettings doesn't supported on Emulator");
        return new Builder();
    }

    public static final class Builder {
        @Nullable
        private String projectId;
        private final BigtableInstanceAdminStubSettings.Builder stubSettings;

        private Builder() {
            this.stubSettings = BigtableInstanceAdminStubSettings.newBuilder();
        }

        private Builder(BigtableInstanceAdminSettings settings) {
            this.projectId = settings.projectId;
            this.stubSettings = settings.stubSettings.toBuilder();
        }

        public Builder setProjectId(@Nonnull String projectId) {
            Preconditions.checkNotNull(projectId);
            this.projectId = projectId;
            return this;
        }

        @Nullable
        public String getProjectId() {
            return this.projectId;
        }

        public Builder setCredentialsProvider(CredentialsProvider credentialsProvider) {
            this.stubSettings.setCredentialsProvider(credentialsProvider);
            return this;
        }

        public CredentialsProvider getCredentialsProvider() {
            return this.stubSettings.getCredentialsProvider();
        }

        public BigtableInstanceAdminStubSettings.Builder stubSettings() {
            return this.stubSettings;
        }

        public BigtableInstanceAdminSettings build() throws IOException {
            return new BigtableInstanceAdminSettings(this);
        }
    }
}

