/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.models;

import com.google.bigtable.repackaged.com.google.api.core.BetaApi;
import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.GcRule;
import com.google.bigtable.repackaged.com.google.common.base.MoreObjects;
import com.google.bigtable.repackaged.com.google.common.base.Objects;
import com.google.bigtable.repackaged.com.google.protobuf.Duration;
import com.google.bigtable.repackaged.javax.annotation.Nonnull;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public final class GCRules {
    public static final GCRules GCRULES = new GCRules();

    private GCRules() {
    }

    public IntersectionRule intersection() {
        return new IntersectionRule();
    }

    public UnionRule union() {
        return new UnionRule();
    }

    public VersionRule maxVersions(int maxVersion) {
        return new VersionRule(maxVersion);
    }

    public DurationRule maxAge(long maxAge, TimeUnit timeUnit) {
        return this.maxAge(com.google.bigtable.repackaged.org.threeten.bp.Duration.ofNanos(TimeUnit.NANOSECONDS.convert(maxAge, timeUnit)));
    }

    public DurationRule maxAge(com.google.bigtable.repackaged.org.threeten.bp.Duration duration) {
        return new DurationRule(duration);
    }

    public DefaultRule defaultRule() {
        return new DefaultRule();
    }

    @InternalApi
    public GCRule fromProto(GcRule source) {
        switch (source.getRuleCase()) {
            case MAX_AGE: {
                return GCRULES.maxAge(com.google.bigtable.repackaged.org.threeten.bp.Duration.ofSeconds(source.getMaxAge().getSeconds(), source.getMaxAge().getNanos()));
            }
            case MAX_NUM_VERSIONS: {
                return GCRULES.maxVersions(source.getMaxNumVersions());
            }
            case INTERSECTION: {
                IntersectionRule intersection = GCRULES.intersection();
                for (GcRule rule : source.getIntersection().getRulesList()) {
                    intersection.rule(this.fromProto(rule));
                }
                return intersection;
            }
            case UNION: {
                UnionRule union = GCRULES.union();
                for (GcRule rule : source.getUnion().getRulesList()) {
                    union.rule(this.fromProto(rule));
                }
                return union;
            }
            case RULE_NOT_SET: {
                return this.defaultRule();
            }
        }
        throw new IllegalArgumentException("Unknown GcRule case: " + source.getRuleCase());
    }

    private static List<GcRule> convertToGcRules(List<GCRule> rules) {
        ArrayList<GcRule> gcRules = new ArrayList<GcRule>(rules.size());
        for (GCRule rule : rules) {
            gcRules.add(rule.toProto());
        }
        return gcRules;
    }

    public static interface GCRule {
        @InternalApi
        public GcRule toProto();
    }

    public static final class DefaultRule
    implements GCRule {
        private DefaultRule() {
        }

        @Override
        @InternalApi
        public GcRule toProto() {
            return GcRule.getDefaultInstance();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            return this.getClass() == o.getClass();
        }

        public int hashCode() {
            return Objects.hashCode(1);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).toString();
        }
    }

    public static final class DurationRule
    implements GCRule {
        private final Duration.Builder builder;

        private DurationRule(com.google.bigtable.repackaged.org.threeten.bp.Duration duration) {
            this.builder = Duration.newBuilder().setSeconds(duration.getSeconds()).setNanos(duration.getNano());
        }

        public com.google.bigtable.repackaged.org.threeten.bp.Duration getMaxAge() {
            return com.google.bigtable.repackaged.org.threeten.bp.Duration.ofSeconds(this.builder.getSeconds(), this.builder.getNanos());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DurationRule that = (DurationRule)o;
            return Objects.equal(this.builder.build(), that.builder.build());
        }

        public int hashCode() {
            return Objects.hashCode(this.builder);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("maxAge", this.getMaxAge()).toString();
        }

        @Override
        @InternalApi
        public GcRule toProto() {
            return GcRule.newBuilder().setMaxAge(this.builder.build()).build();
        }
    }

    public static final class VersionRule
    implements GCRule {
        private final GcRule.Builder builder = GcRule.newBuilder();

        private VersionRule(int maxVersion) {
            this.builder.setMaxNumVersions(maxVersion);
        }

        public int getMaxVersions() {
            return this.builder.getMaxNumVersions();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            VersionRule that = (VersionRule)o;
            return Objects.equal(this.builder.build(), that.builder.build());
        }

        public int hashCode() {
            return Objects.hashCode(this.builder);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("maxNumVersions", this.getMaxVersions()).toString();
        }

        @Override
        @InternalApi
        public GcRule toProto() {
            return this.builder.build();
        }
    }

    public static final class UnionRule
    implements GCRule {
        private final List<GCRule> rulesList = new ArrayList<GCRule>();

        private UnionRule() {
        }

        public UnionRule rule(@Nonnull GCRule rule) {
            this.rulesList.add(rule);
            return this;
        }

        public List<GCRule> getRulesList() {
            return this.rulesList;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UnionRule unionRule = (UnionRule)o;
            return Objects.equal(this.rulesList, unionRule.rulesList);
        }

        public int hashCode() {
            return Objects.hashCode(this.rulesList);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("rulesList", this.rulesList).toString();
        }

        @Override
        @InternalApi
        public GcRule toProto() {
            switch (this.rulesList.size()) {
                case 0: {
                    return GcRule.newBuilder().build();
                }
                case 1: {
                    return this.rulesList.get(0).toProto();
                }
            }
            return GcRule.newBuilder().setUnion(GcRule.Union.newBuilder().addAllRules(GCRules.convertToGcRules(this.rulesList))).build();
        }
    }

    public static final class IntersectionRule
    implements GCRule {
        private final List<GCRule> rulesList = new ArrayList<GCRule>();

        private IntersectionRule() {
        }

        public IntersectionRule rule(@Nonnull GCRule rule) {
            this.rulesList.add(rule);
            return this;
        }

        public List<GCRule> getRulesList() {
            return this.rulesList;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IntersectionRule that = (IntersectionRule)o;
            return Objects.equal(this.rulesList, that.rulesList);
        }

        public int hashCode() {
            return Objects.hashCode(this.rulesList);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("rulesList", this.rulesList).toString();
        }

        @Override
        @InternalApi
        public GcRule toProto() {
            switch (this.rulesList.size()) {
                case 0: {
                    return GcRule.newBuilder().build();
                }
                case 1: {
                    return this.rulesList.get(0).toProto();
                }
            }
            return GcRule.newBuilder().setIntersection(GcRule.Intersection.newBuilder().addAllRules(GCRules.convertToGcRules(this.rulesList))).build();
        }
    }
}

