/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.models;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.internal.NameUtil;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.models.GCRules;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.javax.annotation.Nonnull;

public final class ModifyColumnFamiliesRequest {
    private final ModifyColumnFamiliesRequest.Builder modFamilyRequest = com.google.bigtable.repackaged.com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest.newBuilder();
    private final String tableId;

    public static ModifyColumnFamiliesRequest of(String tableId) {
        return new ModifyColumnFamiliesRequest(tableId);
    }

    ModifyColumnFamiliesRequest(String tableId) {
        Preconditions.checkNotNull(tableId);
        this.tableId = tableId;
    }

    public ModifyColumnFamiliesRequest addFamily(String familyId) {
        return this.addFamily(familyId, GCRules.GCRULES.defaultRule());
    }

    public ModifyColumnFamiliesRequest addFamily(String familyId, GCRules.GCRule gcRule) {
        Preconditions.checkNotNull(gcRule);
        ModifyColumnFamiliesRequest.Modification.Builder modification = ModifyColumnFamiliesRequest.Modification.newBuilder().setId(familyId);
        modification.getCreateBuilder().setGcRule(gcRule.toProto());
        this.modFamilyRequest.addModifications(modification.build());
        return this;
    }

    public ModifyColumnFamiliesRequest updateFamily(String familyId, GCRules.GCRule gcRule) {
        Preconditions.checkNotNull(gcRule);
        ModifyColumnFamiliesRequest.Modification.Builder modification = ModifyColumnFamiliesRequest.Modification.newBuilder().setId(familyId);
        modification.getUpdateBuilder().setGcRule(gcRule.toProto());
        this.modFamilyRequest.addModifications(modification.build());
        return this;
    }

    public ModifyColumnFamiliesRequest dropFamily(String familyId) {
        ModifyColumnFamiliesRequest.Modification.Builder modification = ModifyColumnFamiliesRequest.Modification.newBuilder().setId(familyId).setDrop(true);
        this.modFamilyRequest.addModifications(modification.build());
        return this;
    }

    @InternalApi
    public com.google.bigtable.repackaged.com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest toProto(@Nonnull String projectId, @Nonnull String instanceId) {
        Preconditions.checkNotNull(projectId, "Project id can't be null");
        Preconditions.checkNotNull(instanceId, "Instance id can't be null");
        String tableName = NameUtil.formatTableName(projectId, instanceId, this.tableId);
        return this.modFamilyRequest.setName(tableName).build();
    }
}

