/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.models;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.RestoreTableRequest;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.internal.NameUtil;
import com.google.bigtable.repackaged.com.google.common.base.Objects;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.javax.annotation.Nonnull;
import com.google.bigtable.repackaged.javax.annotation.Nullable;

public final class RestoreTableRequest {
    private final RestoreTableRequest.Builder requestBuilder = com.google.bigtable.repackaged.com.google.bigtable.admin.v2.RestoreTableRequest.newBuilder();
    private final String sourceBackupId;
    private final String sourceClusterId;
    private final String sourceInstanceId;

    public static RestoreTableRequest of(String sourceClusterId, String sourceBackupId) {
        RestoreTableRequest request = new RestoreTableRequest(null, sourceClusterId, sourceBackupId);
        return request;
    }

    public static RestoreTableRequest of(String sourceInstanceId, String sourceClusterId, String sourceBackupId) {
        RestoreTableRequest request = new RestoreTableRequest(sourceInstanceId, sourceClusterId, sourceBackupId);
        return request;
    }

    private RestoreTableRequest(@Nullable String sourceInstanceId, @Nonnull String sourceClusterId, @Nonnull String sourceBackupId) {
        Preconditions.checkNotNull(sourceClusterId);
        Preconditions.checkNotNull(sourceBackupId);
        this.sourceBackupId = sourceBackupId;
        this.sourceInstanceId = sourceInstanceId;
        this.sourceClusterId = sourceClusterId;
    }

    public RestoreTableRequest setTableId(String tableId) {
        Preconditions.checkNotNull(tableId);
        this.requestBuilder.setTableId(tableId);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RestoreTableRequest that = (RestoreTableRequest)o;
        return Objects.equal(this.requestBuilder.getTableId(), that.requestBuilder.getTableId()) && Objects.equal(this.sourceInstanceId, that.sourceInstanceId) && Objects.equal(this.sourceClusterId, that.sourceClusterId) && Objects.equal(this.sourceBackupId, that.sourceBackupId);
    }

    public int hashCode() {
        return Objects.hashCode(this.requestBuilder.getTableId(), this.sourceInstanceId, this.sourceClusterId, this.sourceBackupId);
    }

    @InternalApi
    public com.google.bigtable.repackaged.com.google.bigtable.admin.v2.RestoreTableRequest toProto(@Nonnull String projectId, @Nonnull String instanceId) {
        Preconditions.checkNotNull(projectId);
        Preconditions.checkNotNull(instanceId);
        return this.requestBuilder.setParent(NameUtil.formatInstanceName(projectId, instanceId)).setBackup(NameUtil.formatBackupName(projectId, this.sourceInstanceId == null ? instanceId : this.sourceInstanceId, this.sourceClusterId, this.sourceBackupId)).build();
    }
}

