/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.config;

import com.google.bigtable.repackaged.com.google.api.core.BetaApi;
import com.google.bigtable.repackaged.com.google.api.core.InternalExtensionOnly;
import com.google.bigtable.repackaged.com.google.common.base.MoreObjects;
import com.google.bigtable.repackaged.com.google.common.base.Optional;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Objects;

@InternalExtensionOnly
public class CallOptionsConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final boolean USE_TIMEOUT_DEFAULT = false;
    public static final int SHORT_TIMEOUT_MS_DEFAULT = 20000;
    public static final int LONG_TIMEOUT_MS_DEFAULT = 600000;
    private final boolean useTimeout;
    private final int shortRpcTimeoutMs;
    private final Optional<Integer> shortRpcAttemptTimeoutMs;
    private final int longRpcTimeoutMs;
    private final int mutateRpcTimeoutMs;
    private final Optional<Integer> mutateRpcAttemptTimeoutMs;
    private final int readStreamRpcTimeoutMs;
    private final Optional<Integer> readStreamRpcAttemptTimeoutMs;

    public static Builder builder() {
        return new Builder();
    }

    @Deprecated
    public CallOptionsConfig(boolean useTimeout, int unaryRpcTimeoutMs, int longRpcTimeoutMs) {
        this.useTimeout = useTimeout;
        this.shortRpcTimeoutMs = unaryRpcTimeoutMs;
        this.shortRpcAttemptTimeoutMs = Optional.absent();
        this.longRpcTimeoutMs = longRpcTimeoutMs;
        this.mutateRpcTimeoutMs = longRpcTimeoutMs;
        this.mutateRpcAttemptTimeoutMs = Optional.absent();
        this.readStreamRpcTimeoutMs = longRpcTimeoutMs;
        this.readStreamRpcAttemptTimeoutMs = Optional.absent();
    }

    private CallOptionsConfig(Builder builder) {
        this.useTimeout = builder.useTimeout;
        this.shortRpcTimeoutMs = builder.shortRpcTimeoutMs;
        this.shortRpcAttemptTimeoutMs = builder.shortRpcAttemptTimeoutMs;
        this.longRpcTimeoutMs = builder.longRpcTimeoutMs;
        int mutateTimeout = builder.mutateRpcTimeoutMs;
        int readRowsTimeout = builder.readRowsRpcTimeoutMs;
        if (mutateTimeout == 600000 && this.longRpcTimeoutMs != 600000) {
            mutateTimeout = this.longRpcTimeoutMs;
        }
        if (readRowsTimeout == 600000 && this.longRpcTimeoutMs != 600000) {
            readRowsTimeout = this.longRpcTimeoutMs;
        }
        this.mutateRpcTimeoutMs = mutateTimeout;
        this.mutateRpcAttemptTimeoutMs = builder.mutateRpcAttemptTimeoutMs;
        this.readStreamRpcTimeoutMs = readRowsTimeout;
        this.readStreamRpcAttemptTimeoutMs = builder.readRowsRpcAttemptTimeoutMs;
    }

    public boolean isUseTimeout() {
        return this.useTimeout;
    }

    @Deprecated
    public int getTimeoutMs() {
        return this.getShortRpcTimeoutMs();
    }

    public int getShortRpcTimeoutMs() {
        return this.shortRpcTimeoutMs;
    }

    @BetaApi(value="The API for getting attempt timeouts is not yet stable and may change in the future")
    public Optional<Integer> getShortRpcAttemptTimeoutMs() {
        return this.shortRpcAttemptTimeoutMs;
    }

    @Deprecated
    public int getLongRpcTimeoutMs() {
        return this.longRpcTimeoutMs;
    }

    public int getMutateRpcTimeoutMs() {
        return this.mutateRpcTimeoutMs;
    }

    @BetaApi(value="The API for getting attempt timeouts is not yet stable and may change in the future")
    public Optional<Integer> getMutateRpcAttemptTimeoutMs() {
        return this.mutateRpcAttemptTimeoutMs;
    }

    public int getReadStreamRpcTimeoutMs() {
        return this.readStreamRpcTimeoutMs;
    }

    @BetaApi(value="The API for getting attempt timeouts is not yet stable and may change in the future")
    public Optional<Integer> getReadStreamRpcAttemptTimeoutMs() {
        return this.readStreamRpcAttemptTimeoutMs;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != CallOptionsConfig.class) {
            return false;
        }
        CallOptionsConfig other = (CallOptionsConfig)obj;
        return this.useTimeout == other.useTimeout && this.shortRpcTimeoutMs == other.shortRpcTimeoutMs && Objects.equals(this.shortRpcAttemptTimeoutMs, other.shortRpcAttemptTimeoutMs) && this.longRpcTimeoutMs == other.longRpcTimeoutMs && this.mutateRpcTimeoutMs == other.mutateRpcTimeoutMs && Objects.equals(this.mutateRpcAttemptTimeoutMs, other.mutateRpcAttemptTimeoutMs) && this.readStreamRpcTimeoutMs == other.readStreamRpcTimeoutMs && Objects.equals(this.readStreamRpcAttemptTimeoutMs, other.readStreamRpcAttemptTimeoutMs);
    }

    public int hashCode() {
        return Objects.hash(this.useTimeout, this.shortRpcTimeoutMs, this.shortRpcAttemptTimeoutMs, this.longRpcTimeoutMs, this.mutateRpcTimeoutMs, this.mutateRpcAttemptTimeoutMs, this.readStreamRpcTimeoutMs, this.readStreamRpcAttemptTimeoutMs);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("useTimeout", this.useTimeout).add("shortRpcTimeoutMs", this.shortRpcTimeoutMs).add("shortRpcAttemptTimeoutMs", this.shortRpcAttemptTimeoutMs).add("longRpcTimeoutMs", this.longRpcTimeoutMs).add("mutateRpcTimeoutMs", this.mutateRpcTimeoutMs).add("mutateRpcAttemptTimeoutMs", this.mutateRpcAttemptTimeoutMs).add("readStreamRpcTimeoutMs", this.readStreamRpcTimeoutMs).add("readStreamRpcAttemptTimeoutMs", this.readStreamRpcAttemptTimeoutMs).toString();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static class Builder {
        private boolean useTimeout = false;
        private int shortRpcTimeoutMs = 20000;
        private Optional<Integer> shortRpcAttemptTimeoutMs = Optional.absent();
        private int longRpcTimeoutMs = 600000;
        private int mutateRpcTimeoutMs = 600000;
        private Optional<Integer> mutateRpcAttemptTimeoutMs = Optional.absent();
        private int readRowsRpcTimeoutMs = 600000;
        private Optional<Integer> readRowsRpcAttemptTimeoutMs = Optional.absent();

        @Deprecated
        public Builder() {
        }

        private Builder(CallOptionsConfig original) {
            this.useTimeout = original.useTimeout;
            this.shortRpcTimeoutMs = original.shortRpcTimeoutMs;
            this.shortRpcAttemptTimeoutMs = original.shortRpcAttemptTimeoutMs;
            this.longRpcTimeoutMs = original.longRpcTimeoutMs;
            this.mutateRpcTimeoutMs = original.mutateRpcTimeoutMs;
            this.mutateRpcAttemptTimeoutMs = original.mutateRpcAttemptTimeoutMs;
            this.readRowsRpcTimeoutMs = original.readStreamRpcTimeoutMs;
            this.readRowsRpcAttemptTimeoutMs = original.readStreamRpcAttemptTimeoutMs;
        }

        public Builder setUseTimeout(boolean useTimeout) {
            this.useTimeout = useTimeout;
            return this;
        }

        @Deprecated
        public Builder setTimeoutMs(int timeoutMs) {
            return this.setShortRpcTimeoutMs(timeoutMs);
        }

        public Builder setShortRpcTimeoutMs(int shortRpcTimeoutMs) {
            Preconditions.checkArgument(shortRpcTimeoutMs > 0, "Short Timeout ms has to be greater than 0.");
            this.shortRpcTimeoutMs = shortRpcTimeoutMs;
            return this;
        }

        @BetaApi(value="The API for setting attempt timeouts is not yet stable and may change in the future")
        public Builder setShortRpcAttemptTimeoutMs(int shortRpcAttemptTimeoutMs) {
            Preconditions.checkArgument(shortRpcAttemptTimeoutMs > 0, "Short Timeout ms has to be greater than 0.");
            this.shortRpcAttemptTimeoutMs = Optional.of(shortRpcAttemptTimeoutMs);
            return this;
        }

        @Deprecated
        public Builder setLongRpcTimeoutMs(int longRpcTimeoutMs) {
            Preconditions.checkArgument(longRpcTimeoutMs > 0, "Long running RPC Timeout ms has to be greater than 0");
            this.longRpcTimeoutMs = longRpcTimeoutMs;
            return this;
        }

        public Builder setMutateRpcTimeoutMs(int mutateRpcTimeoutMs) {
            Preconditions.checkArgument(mutateRpcTimeoutMs > 0, "Mutate Rows RPC Timeout ms has to be greater than 0");
            this.mutateRpcTimeoutMs = mutateRpcTimeoutMs;
            return this;
        }

        @BetaApi(value="The API for setting attempt timeouts is not yet stable and may change in the future")
        public Builder setMutateRpcAttemptTimeoutMs(int mutateRpcAttemptTimeoutMs) {
            Preconditions.checkArgument(mutateRpcAttemptTimeoutMs > 0, "Mutate Rows RPC Timeout ms has to be greater than 0");
            this.mutateRpcAttemptTimeoutMs = Optional.of(mutateRpcAttemptTimeoutMs);
            return this;
        }

        public Builder setReadRowsRpcTimeoutMs(int readStreamRpcTimeoutMs) {
            Preconditions.checkArgument(readStreamRpcTimeoutMs > 0, "Read Stream RPC Timeout ms has to be greater than 0");
            this.readRowsRpcTimeoutMs = readStreamRpcTimeoutMs;
            return this;
        }

        @BetaApi(value="The API for setting attempt timeouts is not yet stable and may change in the future")
        public Builder setReadRowsRpcAttemptTimeoutMs(int readRowsRpcAttemptTimeoutMs) {
            Preconditions.checkArgument(readRowsRpcAttemptTimeoutMs > 0, "Mutate Rows RPC Timeout ms has to be greater than 0");
            this.readRowsRpcAttemptTimeoutMs = Optional.of(readRowsRpcAttemptTimeoutMs);
            return this;
        }

        public CallOptionsConfig build() {
            return new CallOptionsConfig(this);
        }
    }
}

