/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2;

import com.google.bigtable.repackaged.com.google.api.core.BetaApi;
import com.google.bigtable.repackaged.com.google.api.gax.core.BackgroundResource;
import com.google.bigtable.repackaged.com.google.api.gax.core.FixedCredentialsProvider;
import com.google.bigtable.repackaged.com.google.api.gax.core.FixedExecutorProvider;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.ClientContext;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.FixedHeaderProvider;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.FixedTransportChannelProvider;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.FixedWatchdogProvider;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.BigtableDataClient;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.BigtableDataSettings;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.EnhancedBigtableStubSettings;
import com.google.bigtable.repackaged.javax.annotation.Nonnull;
import java.io.IOException;

@BetaApi(value="This feature is currently experimental and can change in the future")
public final class BigtableDataClientFactory
implements AutoCloseable {
    private final BigtableDataSettings defaultSettings;
    private final ClientContext sharedClientContext;

    public static BigtableDataClientFactory create(BigtableDataSettings defaultSettings) throws IOException {
        ClientContext sharedClientContext = ClientContext.create(defaultSettings.getStubSettings());
        return new BigtableDataClientFactory(sharedClientContext, defaultSettings);
    }

    private BigtableDataClientFactory(ClientContext sharedClientContext, BigtableDataSettings defaultSettings) {
        this.sharedClientContext = sharedClientContext;
        this.defaultSettings = defaultSettings;
    }

    @Override
    public void close() throws Exception {
        for (BackgroundResource resource : this.sharedClientContext.getBackgroundResources()) {
            resource.close();
        }
    }

    public BigtableDataClient createDefault() {
        BigtableDataSettings.Builder settingsBuilder = this.defaultSettings.toBuilder();
        this.patchStubSettings(settingsBuilder.stubSettings());
        BigtableDataSettings settings = settingsBuilder.build();
        try {
            return BigtableDataClient.create(settings);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create a new client using factory default settings and shared resources.");
        }
    }

    public BigtableDataClient createForAppProfile(@Nonnull String appProfileId) throws IOException {
        BigtableDataSettings.Builder settingsBuilder = this.defaultSettings.toBuilder().setAppProfileId(appProfileId);
        this.patchStubSettings(settingsBuilder.stubSettings());
        return BigtableDataClient.create(settingsBuilder.build());
    }

    public BigtableDataClient createForInstance(@Nonnull String projectId, @Nonnull String instanceId) throws IOException {
        BigtableDataSettings.Builder settingsBuilder = this.defaultSettings.toBuilder().setProjectId(projectId).setInstanceId(instanceId).setDefaultAppProfileId();
        this.patchStubSettings(settingsBuilder.stubSettings());
        return BigtableDataClient.create(settingsBuilder.build());
    }

    public BigtableDataClient createForInstance(@Nonnull String projectId, @Nonnull String instanceId, @Nonnull String appProfileId) throws IOException {
        BigtableDataSettings.Builder settingsBuilder = this.defaultSettings.toBuilder().setProjectId(projectId).setInstanceId(instanceId).setAppProfileId(appProfileId);
        this.patchStubSettings(settingsBuilder.stubSettings());
        return BigtableDataClient.create(settingsBuilder.build());
    }

    private void patchStubSettings(EnhancedBigtableStubSettings.Builder stubSettings) {
        ((EnhancedBigtableStubSettings.Builder)((EnhancedBigtableStubSettings.Builder)((EnhancedBigtableStubSettings.Builder)((EnhancedBigtableStubSettings.Builder)((EnhancedBigtableStubSettings.Builder)stubSettings.setRefreshingChannel(false).setTransportChannelProvider(FixedTransportChannelProvider.create(this.sharedClientContext.getTransportChannel()))).setCredentialsProvider(FixedCredentialsProvider.create(this.sharedClientContext.getCredentials()))).setExecutorProvider(FixedExecutorProvider.create(this.sharedClientContext.getExecutor()))).setStreamWatchdogProvider(FixedWatchdogProvider.create(this.sharedClientContext.getStreamWatchdog()))).setHeaderProvider(FixedHeaderProvider.create(this.sharedClientContext.getHeaders()))).setClock(this.sharedClientContext.getClock());
    }
}

