/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub;

import com.google.bigtable.repackaged.com.google.api.core.ApiFuture;
import com.google.bigtable.repackaged.com.google.api.core.ApiFutureCallback;
import com.google.bigtable.repackaged.com.google.api.core.ApiFutures;
import com.google.bigtable.repackaged.com.google.api.gax.batching.FlowControlEventStats;
import com.google.bigtable.repackaged.com.google.api.gax.batching.FlowController;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.ApiCallContext;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.DeadlineExceededException;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.UnaryCallable;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.DynamicFlowControlStats;
import com.google.bigtable.repackaged.com.google.common.base.Stopwatch;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.MoreExecutors;
import com.google.bigtable.repackaged.javax.annotation.Nonnull;
import java.util.concurrent.TimeUnit;

final class DynamicFlowControlCallable
extends UnaryCallable {
    static final double VERY_HIGH_LATENCY_MULTIPLIER = 3.0;
    static final double HIGH_LATENCY_MULTIPLIER = 1.2;
    static final double LOW_LATENCY_MULTIPLIER = 0.8;
    static final double LOW_CONCURRENCY_MULTIPLIER = 0.05;
    static final double LOW_CONCURRENCY_LATENCY_MULTIPLIER = 2.0;
    static final double VERY_HIGH_LATENCY_DECREASE_CONCURRENCY_RATE = 0.3;
    static final double HIGH_LATENCY_DECREASE_CONCURRENCY_RATE = 0.1;
    static final double LOW_LATENCY_INCREASE_CONCURRENCY_RATE = 0.05;
    static final double LOW_CONCURRENCY_INCREASE_CONCURRENCY_RATE = 0.02;
    static final long THROTTLING_EVENT_TIME_RANGE_MS = TimeUnit.MINUTES.toMillis(5L);
    private final FlowController flowController;
    private final DynamicFlowControlStats dynamicFlowControlStats;
    private final long targetLatencyMs;
    private final long adjustingIntervalMs;
    private final UnaryCallable innerCallable;

    DynamicFlowControlCallable(@Nonnull UnaryCallable innerCallable, @Nonnull FlowController flowController, @Nonnull DynamicFlowControlStats stats, long targetLatencyMs, long adjustingIntervalMs) {
        this.innerCallable = innerCallable;
        this.flowController = flowController;
        this.dynamicFlowControlStats = stats;
        this.targetLatencyMs = targetLatencyMs;
        this.adjustingIntervalMs = adjustingIntervalMs;
    }

    public ApiFuture futureCall(Object request, ApiCallContext context) {
        final DynamicFlowControlRunnable flowControllerRunnable = new DynamicFlowControlRunnable();
        ApiFuture future = this.innerCallable.futureCall(request, context);
        ApiFutures.addCallback(future, new ApiFutureCallback(){

            @Override
            public void onFailure(Throwable t) {
                if (t instanceof DeadlineExceededException) {
                    flowControllerRunnable.run();
                }
            }

            public void onSuccess(Object result) {
                flowControllerRunnable.run();
            }
        }, MoreExecutors.directExecutor());
        return future;
    }

    class DynamicFlowControlRunnable
    implements Runnable {
        private final Stopwatch timer = Stopwatch.createStarted();

        DynamicFlowControlRunnable() {
        }

        @Override
        public void run() {
            DynamicFlowControlCallable.this.dynamicFlowControlStats.updateLatency(this.timer.elapsed(TimeUnit.MILLISECONDS));
            long lastAdjustedTimestamp = DynamicFlowControlCallable.this.dynamicFlowControlStats.getLastAdjustedTimestampMs();
            long now = System.currentTimeMillis();
            if (now - lastAdjustedTimestamp < DynamicFlowControlCallable.this.adjustingIntervalMs) {
                return;
            }
            double meanLatency = DynamicFlowControlCallable.this.dynamicFlowControlStats.getMeanLatency();
            FlowControlEventStats.FlowControlEvent flowControlEvent = DynamicFlowControlCallable.this.flowController.getFlowControlEventStats().getLastFlowControlEvent();
            boolean wasRecentlyThrottled = flowControlEvent != null && now - flowControlEvent.getTimestampMs() <= THROTTLING_EVENT_TIME_RANGE_MS;
            long maxElementLimit = DynamicFlowControlCallable.this.flowController.getMaxElementCountLimit();
            if (meanLatency > (double)DynamicFlowControlCallable.this.targetLatencyMs * 3.0) {
                this.decrease(lastAdjustedTimestamp, now, Math.round((double)maxElementLimit * 0.3));
            } else if (meanLatency > (double)DynamicFlowControlCallable.this.targetLatencyMs * 1.2) {
                this.decrease(lastAdjustedTimestamp, now, Math.round((double)maxElementLimit * 0.1));
            } else if (wasRecentlyThrottled && meanLatency < (double)DynamicFlowControlCallable.this.targetLatencyMs * 0.8) {
                this.increase(lastAdjustedTimestamp, now, Math.round((double)maxElementLimit * 0.05));
            } else if (wasRecentlyThrottled && (double)DynamicFlowControlCallable.this.flowController.getCurrentElementCountLimit().longValue() < (double)maxElementLimit * 0.05 && meanLatency < (double)DynamicFlowControlCallable.this.targetLatencyMs * 2.0) {
                this.increase(lastAdjustedTimestamp, now, Math.round((double)maxElementLimit * 0.02));
            }
        }

        private void decrease(long last, long now, long elementSteps) {
            if (DynamicFlowControlCallable.this.dynamicFlowControlStats.setLastAdjustedTimestampMs(last, now)) {
                DynamicFlowControlCallable.this.flowController.decreaseThresholds(elementSteps, 0L);
            }
        }

        private void increase(long last, long now, long elementSteps) {
            if (DynamicFlowControlCallable.this.dynamicFlowControlStats.setLastAdjustedTimestampMs(last, now)) {
                DynamicFlowControlCallable.this.flowController.increaseThresholds(elementSteps, 0L);
            }
        }
    }
}

