/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub;

import com.google.bigtable.repackaged.com.google.api.core.BetaApi;
import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.api.gax.batching.Batcher;
import com.google.bigtable.repackaged.com.google.api.gax.batching.BatcherImpl;
import com.google.bigtable.repackaged.com.google.api.gax.batching.FlowController;
import com.google.bigtable.repackaged.com.google.api.gax.core.BackgroundResource;
import com.google.bigtable.repackaged.com.google.api.gax.core.CredentialsProvider;
import com.google.bigtable.repackaged.com.google.api.gax.core.FixedCredentialsProvider;
import com.google.bigtable.repackaged.com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.bigtable.repackaged.com.google.api.gax.grpc.GrpcCallContext;
import com.google.bigtable.repackaged.com.google.api.gax.grpc.GrpcCallSettings;
import com.google.bigtable.repackaged.com.google.api.gax.grpc.GrpcRawCallableFactory;
import com.google.bigtable.repackaged.com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.bigtable.repackaged.com.google.api.gax.retrying.ExponentialRetryAlgorithm;
import com.google.bigtable.repackaged.com.google.api.gax.retrying.RetryAlgorithm;
import com.google.bigtable.repackaged.com.google.api.gax.retrying.ScheduledRetryingExecutor;
import com.google.bigtable.repackaged.com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.Callables;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.ClientContext;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.RequestParamsExtractor;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.ServerStreamingCallSettings;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.StreamingCallSettings;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.UnaryCallable;
import com.google.bigtable.repackaged.com.google.api.gax.tracing.OpencensusTracerFactory;
import com.google.bigtable.repackaged.com.google.api.gax.tracing.SpanName;
import com.google.bigtable.repackaged.com.google.api.gax.tracing.TracedServerStreamingCallable;
import com.google.bigtable.repackaged.com.google.api.gax.tracing.TracedUnaryCallable;
import com.google.bigtable.repackaged.com.google.auth.Credentials;
import com.google.bigtable.repackaged.com.google.auth.oauth2.ServiceAccountJwtAccessCredentials;
import com.google.bigtable.repackaged.com.google.bigtable.v2.BigtableGrpc;
import com.google.bigtable.repackaged.com.google.bigtable.v2.CheckAndMutateRowRequest;
import com.google.bigtable.repackaged.com.google.bigtable.v2.CheckAndMutateRowResponse;
import com.google.bigtable.repackaged.com.google.bigtable.v2.MutateRowRequest;
import com.google.bigtable.repackaged.com.google.bigtable.v2.MutateRowResponse;
import com.google.bigtable.repackaged.com.google.bigtable.v2.MutateRowsRequest;
import com.google.bigtable.repackaged.com.google.bigtable.v2.MutateRowsResponse;
import com.google.bigtable.repackaged.com.google.bigtable.v2.ReadModifyWriteRowRequest;
import com.google.bigtable.repackaged.com.google.bigtable.v2.ReadModifyWriteRowResponse;
import com.google.bigtable.repackaged.com.google.bigtable.v2.ReadRowsRequest;
import com.google.bigtable.repackaged.com.google.bigtable.v2.ReadRowsResponse;
import com.google.bigtable.repackaged.com.google.bigtable.v2.SampleRowKeysRequest;
import com.google.bigtable.repackaged.com.google.bigtable.v2.SampleRowKeysResponse;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.Version;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.internal.JwtCredentialsWithAudience;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.internal.RequestContext;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.BulkMutation;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.ConditionalRowMutation;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.DefaultRowAdapter;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.KeyOffset;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.Query;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.ReadModifyWriteRow;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.Row;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.RowAdapter;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.RowMutation;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.RowMutationEntry;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.BigtableChannelPrimer;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.CheckAndMutateRowCallable;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.DynamicFlowControlCallable;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.DynamicFlowControlStats;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.EnhancedBigtableStubSettings;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.MutateRowCallable;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.ReadModifyWriteRowCallable;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.SampleRowKeysCallable;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.metrics.CompositeTracerFactory;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.metrics.HeaderTracerStreamingCallable;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.metrics.HeaderTracerUnaryCallable;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.metrics.MetricsTracerFactory;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.metrics.RpcMeasureConstants;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.mutaterows.BulkMutateRowsUserFacingCallable;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.mutaterows.MutateRowsRetryingCallable;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.readrows.FilterMarkerRowsCallable;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.readrows.ReadRowsConvertExceptionCallable;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.readrows.ReadRowsResumptionStrategy;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.readrows.ReadRowsRetryCompletedCallable;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.readrows.ReadRowsUserCallable;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.readrows.RowMergingCallable;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.gaxx.retrying.ApiResultRetryAlgorithm;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableList;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableMap;
import com.google.bigtable.repackaged.com.google.protobuf.ByteString;
import com.google.bigtable.repackaged.io.opencensus.stats.Stats;
import com.google.bigtable.repackaged.io.opencensus.stats.StatsRecorder;
import com.google.bigtable.repackaged.io.opencensus.tags.TagKey;
import com.google.bigtable.repackaged.io.opencensus.tags.TagValue;
import com.google.bigtable.repackaged.io.opencensus.tags.Tagger;
import com.google.bigtable.repackaged.io.opencensus.tags.Tags;
import com.google.bigtable.repackaged.javax.annotation.Nonnull;
import com.google.bigtable.repackaged.javax.annotation.Nullable;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@InternalApi
public class EnhancedBigtableStub
implements AutoCloseable {
    private static final String CLIENT_NAME = "Bigtable";
    private static final long FLOW_CONTROL_ADJUSTING_INTERVAL_MS = TimeUnit.SECONDS.toMillis(20L);
    private final EnhancedBigtableStubSettings settings;
    private final ClientContext clientContext;
    private final RequestContext requestContext;
    private final FlowController bulkMutationFlowController;
    private final DynamicFlowControlStats bulkMutationDynamicFlowControlStats;
    private final ServerStreamingCallable<Query, Row> readRowsCallable;
    private final UnaryCallable<Query, Row> readRowCallable;
    private final UnaryCallable<String, List<KeyOffset>> sampleRowKeysCallable;
    private final UnaryCallable<RowMutation, Void> mutateRowCallable;
    private final UnaryCallable<BulkMutation, Void> bulkMutateRowsCallable;
    private final UnaryCallable<ConditionalRowMutation, Boolean> checkAndMutateRowCallable;
    private final UnaryCallable<ReadModifyWriteRow, Row> readModifyWriteRowCallable;

    public static EnhancedBigtableStub create(EnhancedBigtableStubSettings settings) throws IOException {
        settings = EnhancedBigtableStub.finalizeSettings(settings, Tags.getTagger(), Stats.getStatsRecorder());
        return new EnhancedBigtableStub(settings, ClientContext.create(settings));
    }

    public static EnhancedBigtableStubSettings finalizeSettings(EnhancedBigtableStubSettings settings, Tagger tagger, StatsRecorder stats) throws IOException {
        EnhancedBigtableStubSettings.Builder builder = settings.toBuilder();
        EnhancedBigtableStub.patchCredentials(builder);
        if (settings.isRefreshingChannel()) {
            Credentials credentials = null;
            if (settings.getCredentialsProvider() != null) {
                credentials = settings.getCredentialsProvider().getCredentials();
            }
            builder.setCredentialsProvider(FixedCredentialsProvider.create(credentials));
            InstantiatingGrpcChannelProvider transportProvider = (InstantiatingGrpcChannelProvider)settings.getTransportChannelProvider();
            builder.setTransportChannelProvider(transportProvider.toBuilder().setChannelPrimer(BigtableChannelPrimer.create(credentials, settings.getProjectId(), settings.getInstanceId(), settings.getAppProfileId(), settings.getPrimedTableIds())).build());
        }
        ImmutableMap<TagKey, TagValue> attributes = ImmutableMap.builder().put(RpcMeasureConstants.BIGTABLE_PROJECT_ID, TagValue.create(settings.getProjectId())).put(RpcMeasureConstants.BIGTABLE_INSTANCE_ID, TagValue.create(settings.getInstanceId())).put(RpcMeasureConstants.BIGTABLE_APP_PROFILE_ID, TagValue.create(settings.getAppProfileId())).build();
        builder.setTracerFactory(new CompositeTracerFactory(ImmutableList.of(new OpencensusTracerFactory(ImmutableMap.builder().put(RpcMeasureConstants.BIGTABLE_PROJECT_ID.getName(), settings.getProjectId()).put(RpcMeasureConstants.BIGTABLE_INSTANCE_ID.getName(), settings.getInstanceId()).put(RpcMeasureConstants.BIGTABLE_APP_PROFILE_ID.getName(), settings.getAppProfileId()).put("gax", GaxGrpcProperties.getGaxGrpcVersion()).put("grpc", GaxGrpcProperties.getGrpcVersion()).put("gapic", Version.VERSION).build()), MetricsTracerFactory.create(tagger, stats, attributes), settings.getTracerFactory())));
        builder.setHeaderTracer(builder.getHeaderTracer().toBuilder().setStats(stats).setTagger(tagger).setStatsAttributes(attributes).build());
        return builder.build();
    }

    private static void patchCredentials(EnhancedBigtableStubSettings.Builder settings) throws IOException {
        int i = settings.getEndpoint().lastIndexOf(":");
        String host = settings.getEndpoint().substring(0, i);
        String audience = settings.getJwtAudienceMapping().get(host);
        if (audience == null) {
            return;
        }
        URI audienceUri = null;
        try {
            audienceUri = new URI(audience);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("invalid JWT audience override", e);
        }
        CredentialsProvider credentialsProvider = settings.getCredentialsProvider();
        if (credentialsProvider == null) {
            return;
        }
        Credentials credentials = credentialsProvider.getCredentials();
        if (credentials == null) {
            return;
        }
        if (!(credentials instanceof ServiceAccountJwtAccessCredentials)) {
            return;
        }
        ServiceAccountJwtAccessCredentials jwtCreds = (ServiceAccountJwtAccessCredentials)credentials;
        JwtCredentialsWithAudience patchedCreds = new JwtCredentialsWithAudience(jwtCreds, audienceUri);
        settings.setCredentialsProvider(FixedCredentialsProvider.create(patchedCreds));
    }

    public EnhancedBigtableStub(EnhancedBigtableStubSettings settings, ClientContext clientContext) {
        this.settings = settings;
        this.clientContext = clientContext;
        this.requestContext = RequestContext.create(settings.getProjectId(), settings.getInstanceId(), settings.getAppProfileId());
        this.bulkMutationFlowController = new FlowController(settings.bulkMutateRowsSettings().getDynamicFlowControlSettings());
        this.bulkMutationDynamicFlowControlStats = new DynamicFlowControlStats();
        this.readRowsCallable = this.createReadRowsCallable(new DefaultRowAdapter());
        this.readRowCallable = this.createReadRowCallable(new DefaultRowAdapter());
        this.sampleRowKeysCallable = this.createSampleRowKeysCallable();
        this.mutateRowCallable = this.createMutateRowCallable();
        this.bulkMutateRowsCallable = this.createBulkMutateRowsCallable();
        this.checkAndMutateRowCallable = this.createCheckAndMutateRowCallable();
        this.readModifyWriteRowCallable = this.createReadModifyWriteRowCallable();
    }

    @BetaApi(value="This surface is stable yet it might be removed in the future.")
    public <RowT> ServerStreamingCallable<ReadRowsRequest, RowT> createReadRowsRawCallable(RowAdapter<RowT> rowAdapter) {
        return this.createReadRowsBaseCallable(this.settings.readRowsSettings(), rowAdapter).withDefaultCallContext(this.clientContext.getDefaultCallContext());
    }

    public <RowT> ServerStreamingCallable<Query, RowT> createReadRowsCallable(RowAdapter<RowT> rowAdapter) {
        ServerStreamingCallable<ReadRowsRequest, RowT> readRowsCallable = this.createReadRowsBaseCallable(this.settings.readRowsSettings(), rowAdapter);
        ReadRowsUserCallable<RowT> readRowsUserCallable = new ReadRowsUserCallable<RowT>(readRowsCallable, this.requestContext);
        SpanName span = this.getSpanName("ReadRows");
        TracedServerStreamingCallable traced = new TracedServerStreamingCallable(readRowsUserCallable, this.clientContext.getTracerFactory(), span);
        return traced.withDefaultCallContext(this.clientContext.getDefaultCallContext());
    }

    public <RowT> UnaryCallable<Query, RowT> createReadRowCallable(RowAdapter<RowT> rowAdapter) {
        ServerStreamingCallable<ReadRowsRequest, RowT> readRowsCallable = this.createReadRowsBaseCallable((ServerStreamingCallSettings)ServerStreamingCallSettings.newBuilder().setRetryableCodes(this.settings.readRowSettings().getRetryableCodes()).setRetrySettings(this.settings.readRowSettings().getRetrySettings()).setIdleTimeout(this.settings.readRowSettings().getRetrySettings().getTotalTimeout()).build(), rowAdapter);
        UnaryCallable<Query, RowT> readRowCallable = new ReadRowsUserCallable<RowT>(readRowsCallable, this.requestContext).first();
        return this.createUserFacingUnaryCallable("ReadRow", readRowCallable);
    }

    private <ReqT, RowT> ServerStreamingCallable<ReadRowsRequest, RowT> createReadRowsBaseCallable(ServerStreamingCallSettings<ReqT, Row> readRowsSettings, RowAdapter<RowT> rowAdapter) {
        ServerStreamingCallable<ReadRowsRequest, ReadRowsResponse> base = GrpcRawCallableFactory.createServerStreamingCallable(GrpcCallSettings.newBuilder().setMethodDescriptor(BigtableGrpc.getReadRowsMethod()).setParamsExtractor(new RequestParamsExtractor<ReadRowsRequest>(){

            @Override
            public Map<String, String> extract(ReadRowsRequest readRowsRequest) {
                return ImmutableMap.of("table_name", readRowsRequest.getTableName(), "app_profile_id", readRowsRequest.getAppProfileId());
            }
        }).build(), readRowsSettings.getRetryableCodes());
        ReadRowsConvertExceptionCallable<ReadRowsRequest, ReadRowsResponse> convertException = new ReadRowsConvertExceptionCallable<ReadRowsRequest, ReadRowsResponse>(base);
        RowMergingCallable<RowT> merging = new RowMergingCallable<RowT>(convertException, rowAdapter);
        StreamingCallSettings innerSettings = ServerStreamingCallSettings.newBuilder().setResumptionStrategy(new ReadRowsResumptionStrategy<RowT>(rowAdapter)).setRetryableCodes(readRowsSettings.getRetryableCodes()).setRetrySettings(readRowsSettings.getRetrySettings()).setIdleTimeout(readRowsSettings.getIdleTimeout()).build();
        ServerStreamingCallable watched = Callables.watched(merging, innerSettings, this.clientContext);
        HeaderTracerStreamingCallable withHeaderTracer = new HeaderTracerStreamingCallable(watched, this.settings.getHeaderTracer(), this.getSpanName("ReadRows").toString());
        ReadRowsRetryCompletedCallable retrying1 = new ReadRowsRetryCompletedCallable(withHeaderTracer);
        ServerStreamingCallable retrying2 = Callables.retrying(retrying1, innerSettings, this.clientContext);
        return new FilterMarkerRowsCallable(retrying2, rowAdapter);
    }

    private UnaryCallable<String, List<KeyOffset>> createSampleRowKeysCallable() {
        String methodName = "SampleRowKeys";
        ServerStreamingCallable<SampleRowKeysRequest, SampleRowKeysResponse> base = GrpcRawCallableFactory.createServerStreamingCallable(GrpcCallSettings.newBuilder().setMethodDescriptor(BigtableGrpc.getSampleRowKeysMethod()).setParamsExtractor(new RequestParamsExtractor<SampleRowKeysRequest>(){

            @Override
            public Map<String, String> extract(SampleRowKeysRequest sampleRowKeysRequest) {
                return ImmutableMap.of("table_name", sampleRowKeysRequest.getTableName(), "app_profile_id", sampleRowKeysRequest.getAppProfileId());
            }
        }).build(), this.settings.sampleRowKeysSettings().getRetryableCodes());
        UnaryCallable<SampleRowKeysRequest, List<SampleRowKeysResponse>> spoolable = base.all();
        HeaderTracerUnaryCallable<SampleRowKeysRequest, List<SampleRowKeysResponse>> withHeaderTracer = new HeaderTracerUnaryCallable<SampleRowKeysRequest, List<SampleRowKeysResponse>>(spoolable, this.settings.getHeaderTracer(), this.getSpanName(methodName).toString());
        UnaryCallable<SampleRowKeysRequest, List<SampleRowKeysResponse>> retryable = Callables.retrying(withHeaderTracer, this.settings.sampleRowKeysSettings(), this.clientContext);
        return this.createUserFacingUnaryCallable(methodName, new SampleRowKeysCallable(retryable, this.requestContext));
    }

    private UnaryCallable<RowMutation, Void> createMutateRowCallable() {
        String methodName = "MutateRow";
        UnaryCallable<MutateRowRequest, MutateRowResponse> base = GrpcRawCallableFactory.createUnaryCallable(GrpcCallSettings.newBuilder().setMethodDescriptor(BigtableGrpc.getMutateRowMethod()).setParamsExtractor(new RequestParamsExtractor<MutateRowRequest>(){

            @Override
            public Map<String, String> extract(MutateRowRequest mutateRowRequest) {
                return ImmutableMap.of("table_name", mutateRowRequest.getTableName(), "app_profile_id", mutateRowRequest.getAppProfileId());
            }
        }).build(), this.settings.mutateRowSettings().getRetryableCodes());
        HeaderTracerUnaryCallable<MutateRowRequest, MutateRowResponse> withHeaderTracer = new HeaderTracerUnaryCallable<MutateRowRequest, MutateRowResponse>(base, this.settings.getHeaderTracer(), this.getSpanName(methodName).toString());
        UnaryCallable<MutateRowRequest, MutateRowResponse> retrying = Callables.retrying(withHeaderTracer, this.settings.mutateRowSettings(), this.clientContext);
        return this.createUserFacingUnaryCallable(methodName, new MutateRowCallable(retrying, this.requestContext));
    }

    private UnaryCallable<BulkMutation, Void> createBulkMutateRowsCallable() {
        DynamicFlowControlCallable baseCallable = this.createMutateRowsBaseCallable();
        DynamicFlowControlCallable flowControlCallable = null;
        if (this.settings.bulkMutateRowsSettings().isLatencyBasedThrottlingEnabled()) {
            flowControlCallable = new DynamicFlowControlCallable(baseCallable, this.bulkMutationFlowController, this.bulkMutationDynamicFlowControlStats, this.settings.bulkMutateRowsSettings().getTargetRpcLatencyMs(), FLOW_CONTROL_ADJUSTING_INTERVAL_MS);
        }
        BulkMutateRowsUserFacingCallable userFacing = new BulkMutateRowsUserFacingCallable(flowControlCallable != null ? flowControlCallable : baseCallable, this.requestContext);
        SpanName spanName = this.getSpanName("MutateRows");
        TracedUnaryCallable<BulkMutation, Void> traced = new TracedUnaryCallable<BulkMutation, Void>(userFacing, this.clientContext.getTracerFactory(), spanName);
        HeaderTracerUnaryCallable<BulkMutation, Void> withHeaderTracer = new HeaderTracerUnaryCallable<BulkMutation, Void>(traced, this.settings.getHeaderTracer(), spanName.toString());
        return withHeaderTracer.withDefaultCallContext(this.clientContext.getDefaultCallContext());
    }

    public Batcher<RowMutationEntry, Void> newMutateRowsBatcher(@Nonnull String tableId, @Nullable GrpcCallContext ctx) {
        UnaryCallable<BulkMutation, Void> callable = this.bulkMutateRowsCallable;
        if (ctx != null) {
            callable = callable.withDefaultCallContext(ctx);
        }
        return new BatcherImpl<RowMutationEntry, Void, BulkMutation, Void>(this.settings.bulkMutateRowsSettings().getBatchingDescriptor(), callable, BulkMutation.create(tableId), this.settings.bulkMutateRowsSettings().getBatchingSettings(), this.clientContext.getExecutor(), this.bulkMutationFlowController);
    }

    public Batcher<ByteString, Row> newBulkReadRowsBatcher(@Nonnull Query query, @Nullable GrpcCallContext ctx) {
        Preconditions.checkNotNull(query, "query cannot be null");
        UnaryCallable<Query, List<Row>> callable = this.readRowsCallable().all();
        if (ctx != null) {
            callable = callable.withDefaultCallContext(ctx);
        }
        return new BatcherImpl<ByteString, Row, Query, List<Row>>(this.settings.bulkReadRowsSettings().getBatchingDescriptor(), callable, query, this.settings.bulkReadRowsSettings().getBatchingSettings(), this.clientContext.getExecutor());
    }

    private UnaryCallable<MutateRowsRequest, Void> createMutateRowsBaseCallable() {
        ServerStreamingCallable<MutateRowsRequest, MutateRowsResponse> base = GrpcRawCallableFactory.createServerStreamingCallable(GrpcCallSettings.newBuilder().setMethodDescriptor(BigtableGrpc.getMutateRowsMethod()).setParamsExtractor(new RequestParamsExtractor<MutateRowsRequest>(){

            @Override
            public Map<String, String> extract(MutateRowsRequest mutateRowsRequest) {
                return ImmutableMap.of("table_name", mutateRowsRequest.getTableName(), "app_profile_id", mutateRowsRequest.getAppProfileId());
            }
        }).build(), this.settings.bulkMutateRowsSettings().getRetryableCodes());
        RetryAlgorithm retryAlgorithm = new RetryAlgorithm(new ApiResultRetryAlgorithm(), (TimedRetryAlgorithm)new ExponentialRetryAlgorithm(this.settings.bulkMutateRowsSettings().getRetrySettings(), this.clientContext.getClock()));
        ScheduledRetryingExecutor<Void> retryingExecutor = new ScheduledRetryingExecutor<Void>(retryAlgorithm, this.clientContext.getExecutor());
        return new MutateRowsRetryingCallable(this.clientContext.getDefaultCallContext(), base, retryingExecutor, this.settings.bulkMutateRowsSettings().getRetryableCodes());
    }

    private UnaryCallable<ConditionalRowMutation, Boolean> createCheckAndMutateRowCallable() {
        String methodName = "CheckAndMutateRow";
        UnaryCallable<CheckAndMutateRowRequest, CheckAndMutateRowResponse> base = GrpcRawCallableFactory.createUnaryCallable(GrpcCallSettings.newBuilder().setMethodDescriptor(BigtableGrpc.getCheckAndMutateRowMethod()).setParamsExtractor(new RequestParamsExtractor<CheckAndMutateRowRequest>(){

            @Override
            public Map<String, String> extract(CheckAndMutateRowRequest checkAndMutateRowRequest) {
                return ImmutableMap.of("table_name", checkAndMutateRowRequest.getTableName(), "app_profile_id", checkAndMutateRowRequest.getAppProfileId());
            }
        }).build(), this.settings.checkAndMutateRowSettings().getRetryableCodes());
        HeaderTracerUnaryCallable<CheckAndMutateRowRequest, CheckAndMutateRowResponse> withHeaderTracer = new HeaderTracerUnaryCallable<CheckAndMutateRowRequest, CheckAndMutateRowResponse>(base, this.settings.getHeaderTracer(), this.getSpanName(methodName).toString());
        UnaryCallable<CheckAndMutateRowRequest, CheckAndMutateRowResponse> retrying = Callables.retrying(withHeaderTracer, this.settings.checkAndMutateRowSettings(), this.clientContext);
        return this.createUserFacingUnaryCallable(methodName, new CheckAndMutateRowCallable(retrying, this.requestContext));
    }

    private UnaryCallable<ReadModifyWriteRow, Row> createReadModifyWriteRowCallable() {
        UnaryCallable<ReadModifyWriteRowRequest, ReadModifyWriteRowResponse> base = GrpcRawCallableFactory.createUnaryCallable(GrpcCallSettings.newBuilder().setMethodDescriptor(BigtableGrpc.getReadModifyWriteRowMethod()).setParamsExtractor(new RequestParamsExtractor<ReadModifyWriteRowRequest>(){

            @Override
            public Map<String, String> extract(ReadModifyWriteRowRequest request) {
                return ImmutableMap.of("table_name", request.getTableName(), "app_profile_id", request.getAppProfileId());
            }
        }).build(), this.settings.readModifyWriteRowSettings().getRetryableCodes());
        String methodName = "ReadModifyWriteRow";
        HeaderTracerUnaryCallable<ReadModifyWriteRowRequest, ReadModifyWriteRowResponse> withHeaderTracer = new HeaderTracerUnaryCallable<ReadModifyWriteRowRequest, ReadModifyWriteRowResponse>(base, this.settings.getHeaderTracer(), this.getSpanName(methodName).toString());
        UnaryCallable<ReadModifyWriteRowRequest, ReadModifyWriteRowResponse> retrying = Callables.retrying(withHeaderTracer, this.settings.readModifyWriteRowSettings(), this.clientContext);
        return this.createUserFacingUnaryCallable(methodName, new ReadModifyWriteRowCallable(retrying, this.requestContext));
    }

    private <RequestT, ResponseT> UnaryCallable<RequestT, ResponseT> createUserFacingUnaryCallable(String methodName, UnaryCallable<RequestT, ResponseT> inner) {
        TracedUnaryCallable<RequestT, ResponseT> traced = new TracedUnaryCallable<RequestT, ResponseT>(inner, this.clientContext.getTracerFactory(), this.getSpanName(methodName));
        return traced.withDefaultCallContext(this.clientContext.getDefaultCallContext());
    }

    public ServerStreamingCallable<Query, Row> readRowsCallable() {
        return this.readRowsCallable;
    }

    public UnaryCallable<Query, Row> readRowCallable() {
        return this.readRowCallable;
    }

    public UnaryCallable<String, List<KeyOffset>> sampleRowKeysCallable() {
        return this.sampleRowKeysCallable;
    }

    public UnaryCallable<RowMutation, Void> mutateRowCallable() {
        return this.mutateRowCallable;
    }

    public UnaryCallable<BulkMutation, Void> bulkMutateRowsCallable() {
        return this.bulkMutateRowsCallable;
    }

    public UnaryCallable<ConditionalRowMutation, Boolean> checkAndMutateRowCallable() {
        return this.checkAndMutateRowCallable;
    }

    public UnaryCallable<ReadModifyWriteRow, Row> readModifyWriteRowCallable() {
        return this.readModifyWriteRowCallable;
    }

    private SpanName getSpanName(String methodName) {
        return SpanName.of(CLIENT_NAME, methodName);
    }

    @Override
    public void close() {
        for (BackgroundResource backgroundResource : this.clientContext.getBackgroundResources()) {
            try {
                backgroundResource.close();
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to close resource", e);
            }
        }
    }
}

