/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.metrics;

import com.google.bigtable.repackaged.com.google.api.gax.rpc.ApiException;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.StatusCode;
import com.google.bigtable.repackaged.io.grpc.Status;
import com.google.bigtable.repackaged.io.grpc.StatusException;
import com.google.bigtable.repackaged.io.grpc.StatusRuntimeException;
import com.google.bigtable.repackaged.io.opencensus.tags.TagValue;
import com.google.bigtable.repackaged.javax.annotation.Nullable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

class Util {
    private static final TagValue OK_STATUS = TagValue.create(StatusCode.Code.OK.toString());

    Util() {
    }

    static TagValue extractStatus(@Nullable Throwable error) {
        if (error == null) {
            return OK_STATUS;
        }
        String statusString = error instanceof CancellationException ? Status.Code.CANCELLED.toString() : (error instanceof ApiException ? ((ApiException)error).getStatusCode().getCode().toString() : (error instanceof StatusRuntimeException ? ((StatusRuntimeException)error).getStatus().getCode().toString() : (error instanceof StatusException ? ((StatusException)error).getStatus().getCode().toString() : StatusCode.Code.UNKNOWN.toString())));
        return TagValue.create(statusString);
    }

    static TagValue extractStatus(Future<?> future) {
        Throwable error = null;
        try {
            future.get();
        }
        catch (InterruptedException e) {
            error = e;
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            error = e.getCause();
        }
        catch (RuntimeException e) {
            error = e;
        }
        return Util.extractStatus(error);
    }
}

