/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc;

import com.google.bigtable.repackaged.com.google.api.core.ApiFuture;
import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.CreateTableFromSnapshotRequest;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.CreateTableRequest;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.DeleteBackupRequest;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.DeleteSnapshotRequest;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.DeleteTableRequest;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.DropRowRangeRequest;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.GetBackupRequest;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.GetSnapshotRequest;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.GetTableRequest;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.ListBackupsRequest;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.ListBackupsResponse;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.ListSnapshotsRequest;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.ListSnapshotsResponse;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.ListTablesRequest;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.ListTablesResponse;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.RestoreTableMetadata;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.Snapshot;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.SnapshotTableRequest;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.Table;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.internal.NameUtil;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.models.Backup;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.models.CreateBackupRequest;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.models.ModifyColumnFamiliesRequest;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.models.RestoreTableRequest;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.models.RestoredTableResult;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.models.UpdateBackupRequest;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.config.BigtableOptions;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.core.IBigtableTableAdminClient;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.BigtableClusterName;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.BigtableInstanceName;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.BigtableSessionSharedThreadPools;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.BigtableTableAdminClient;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.util.ApiFutureUtil;
import com.google.bigtable.repackaged.com.google.common.base.Function;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableList;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.ListenableFuture;
import com.google.bigtable.repackaged.com.google.longrunning.Operation;
import com.google.bigtable.repackaged.com.google.protobuf.ByteString;
import com.google.bigtable.repackaged.com.google.protobuf.Empty;
import com.google.bigtable.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import com.google.bigtable.repackaged.javax.annotation.Nonnull;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@InternalApi(value="For internal usage only - please use BigtableTableAdminClient")
public class BigtableTableAdminClientWrapper
implements IBigtableTableAdminClient {
    private final BigtableTableAdminClient delegate;
    private final BigtableInstanceName instanceName;
    private final ExecutorService batchThreadPool;

    public BigtableTableAdminClientWrapper(@Nonnull BigtableTableAdminClient adminClient, @Nonnull BigtableOptions options) {
        Preconditions.checkNotNull(adminClient);
        Preconditions.checkNotNull(options);
        this.delegate = adminClient;
        this.instanceName = options.getInstanceName();
        this.batchThreadPool = BigtableSessionSharedThreadPools.getInstance().getBatchThreadPool();
    }

    @Override
    public com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.models.Table createTable(com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.models.CreateTableRequest request) {
        CreateTableRequest requestProto = request.toProto(this.instanceName.getProjectId(), this.instanceName.getInstanceId());
        Table proto = this.delegate.createTable(requestProto);
        return com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.models.Table.fromProto(proto);
    }

    @Override
    public ApiFuture<com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.models.Table> createTableAsync(com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.models.CreateTableRequest request) {
        CreateTableRequest requestProto = request.toProto(this.instanceName.getProjectId(), this.instanceName.getInstanceId());
        return ApiFutureUtil.transformAndAdapt(this.delegate.createTableAsync(requestProto), new Function<Table, com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.models.Table>(){

            @Override
            public com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.models.Table apply(Table tableProto) {
                return com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.models.Table.fromProto(tableProto);
            }
        });
    }

    @Override
    public com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.models.Table getTable(String tableId) {
        GetTableRequest requestProto = GetTableRequest.newBuilder().setName(this.instanceName.toTableNameStr(tableId)).build();
        return com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.models.Table.fromProto(this.delegate.getTable(requestProto));
    }

    @Override
    public ApiFuture<com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.models.Table> getTableAsync(String tableId) {
        GetTableRequest requestProto = GetTableRequest.newBuilder().setName(this.instanceName.toTableNameStr(tableId)).build();
        return ApiFutureUtil.transformAndAdapt(this.delegate.getTableAsync(requestProto), new Function<Table, com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.models.Table>(){

            @Override
            public com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.models.Table apply(Table tableProto) {
                return com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.models.Table.fromProto(tableProto);
            }
        });
    }

    @Override
    public List<String> listTables() {
        ListTablesRequest requestProto = ListTablesRequest.newBuilder().setParent(this.instanceName.toString()).build();
        ListTablesResponse response = this.delegate.listTables(requestProto);
        ImmutableList.Builder tableIdsBuilder = ImmutableList.builder();
        for (Table tableProto : response.getTablesList()) {
            tableIdsBuilder.add(this.instanceName.toTableId(tableProto.getName()));
        }
        return tableIdsBuilder.build();
    }

    @Override
    public ApiFuture<List<String>> listTablesAsync() {
        ListTablesRequest request = ListTablesRequest.newBuilder().setParent(this.instanceName.toString()).build();
        ListenableFuture<ListTablesResponse> response = this.delegate.listTablesAsync(request);
        return ApiFutureUtil.transformAndAdapt(response, new Function<ListTablesResponse, List<String>>(){

            @Override
            public List<String> apply(ListTablesResponse input) {
                ImmutableList.Builder tableIdsBuilder = ImmutableList.builder();
                for (Table tableProto : input.getTablesList()) {
                    tableIdsBuilder.add(BigtableTableAdminClientWrapper.this.instanceName.toTableId(tableProto.getName()));
                }
                return tableIdsBuilder.build();
            }
        });
    }

    @Override
    public void deleteTable(String tableId) {
        DeleteTableRequest request = DeleteTableRequest.newBuilder().setName(this.instanceName.toTableNameStr(tableId)).build();
        this.delegate.deleteTable(request);
    }

    @Override
    public ApiFuture<Void> deleteTableAsync(String tableId) {
        DeleteTableRequest request = DeleteTableRequest.newBuilder().setName(this.instanceName.toTableNameStr(tableId)).build();
        return ApiFutureUtil.transformAndAdapt(this.delegate.deleteTableAsync(request), new Function<Empty, Void>(){

            @Override
            public Void apply(Empty empty) {
                return null;
            }
        });
    }

    @Override
    public com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.models.Table modifyFamilies(ModifyColumnFamiliesRequest request) {
        com.google.bigtable.repackaged.com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest modifyColumnRequestProto = request.toProto(this.instanceName.getProjectId(), this.instanceName.getInstanceId());
        return com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.models.Table.fromProto(this.delegate.modifyColumnFamily(modifyColumnRequestProto));
    }

    @Override
    public ApiFuture<com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.models.Table> modifyFamiliesAsync(ModifyColumnFamiliesRequest request) {
        com.google.bigtable.repackaged.com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest modifyColumnRequestProto = request.toProto(this.instanceName.getProjectId(), this.instanceName.getInstanceId());
        return ApiFutureUtil.transformAndAdapt(this.delegate.modifyColumnFamilyAsync(modifyColumnRequestProto), new Function<Table, com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.models.Table>(){

            @Override
            public com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.models.Table apply(Table tableProto) {
                return com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.models.Table.fromProto(tableProto);
            }
        });
    }

    @Override
    public void dropRowRange(String tableId, String rowKeyPrefix) {
        this.dropRowRange(tableId, ByteString.copyFromUtf8(rowKeyPrefix));
    }

    @Override
    public void dropRowRange(String tableId, ByteString rowKeyPrefix) {
        Preconditions.checkNotNull(rowKeyPrefix);
        DropRowRangeRequest protoRequest = DropRowRangeRequest.newBuilder().setName(this.instanceName.toTableNameStr(tableId)).setDeleteAllDataFromTable(false).setRowKeyPrefix(rowKeyPrefix).build();
        this.delegate.dropRowRange(protoRequest);
    }

    @Override
    public ApiFuture<Void> dropRowRangeAsync(String tableId, String rowKeyPrefix) {
        return this.dropRowRangeAsync(tableId, ByteString.copyFromUtf8(rowKeyPrefix));
    }

    @Override
    public ApiFuture<Void> dropRowRangeAsync(String tableId, ByteString rowKeyPrefix) {
        Preconditions.checkNotNull(rowKeyPrefix);
        DropRowRangeRequest protoRequest = DropRowRangeRequest.newBuilder().setName(this.instanceName.toTableNameStr(tableId)).setDeleteAllDataFromTable(false).setRowKeyPrefix(rowKeyPrefix).build();
        return ApiFutureUtil.transformAndAdapt(this.delegate.dropRowRangeAsync(protoRequest), new Function<Empty, Void>(){

            @Override
            public Void apply(Empty empty) {
                return null;
            }
        });
    }

    @Override
    public void dropAllRows(String tableId) {
        DropRowRangeRequest protoRequest = DropRowRangeRequest.newBuilder().setName(this.instanceName.toTableNameStr(tableId)).setDeleteAllDataFromTable(true).build();
        this.delegate.dropRowRange(protoRequest);
    }

    @Override
    public ApiFuture<Void> dropAllRowsAsync(String tableId) {
        DropRowRangeRequest protoRequest = DropRowRangeRequest.newBuilder().setName(this.instanceName.toTableNameStr(tableId)).setDeleteAllDataFromTable(true).build();
        return ApiFutureUtil.transformAndAdapt(this.delegate.dropRowRangeAsync(protoRequest), new Function<Empty, Void>(){

            @Override
            public Void apply(Empty empty) {
                return null;
            }
        });
    }

    @Override
    public ApiFuture<Operation> snapshotTableAsync(SnapshotTableRequest request) {
        return ApiFutureUtil.adapt(this.delegate.snapshotTableAsync(request));
    }

    @Override
    public ApiFuture<Snapshot> getSnapshotAsync(GetSnapshotRequest request) {
        return ApiFutureUtil.adapt(this.delegate.getSnapshotAsync(request));
    }

    @Override
    public ApiFuture<ListSnapshotsResponse> listSnapshotsAsync(ListSnapshotsRequest request) {
        return ApiFutureUtil.adapt(this.delegate.listSnapshotsAsync(request));
    }

    @Override
    public ApiFuture<Void> deleteSnapshotAsync(DeleteSnapshotRequest request) {
        return ApiFutureUtil.transformAndAdapt(this.delegate.deleteSnapshotAsync(request), new Function<Empty, Void>(){

            @Override
            public Void apply(Empty input) {
                return null;
            }
        });
    }

    @Override
    public ApiFuture<Operation> createTableFromSnapshotAsync(CreateTableFromSnapshotRequest request) {
        return ApiFutureUtil.adapt(this.delegate.createTableFromSnapshotAsync(request));
    }

    @Override
    public ApiFuture<Backup> createBackupAsync(CreateBackupRequest request) {
        ListenableFuture<Operation> backupAsync = this.delegate.createBackupAsync(request.toProto(this.instanceName.getProjectId(), this.instanceName.getInstanceId()));
        Function<Operation, Backup> function = new Function<Operation, Backup>(){

            @Override
            public Backup apply(final Operation operation) {
                try {
                    Future<Operation> operationFuture = BigtableTableAdminClientWrapper.this.batchThreadPool.submit(new Callable<Operation>(){

                        @Override
                        public Operation call() throws Exception {
                            return BigtableTableAdminClientWrapper.this.delegate.waitForOperation(operation);
                        }
                    });
                    return Backup.fromProto(operationFuture.get().getResponse().unpack(com.google.bigtable.repackaged.com.google.bigtable.admin.v2.Backup.class));
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException("Interrupted while waiting for operation to finish");
                }
                catch (InvalidProtocolBufferException | ExecutionException e) {
                    throw new IllegalStateException(e);
                }
            }
        };
        return ApiFutureUtil.transformAndAdapt(backupAsync, function);
    }

    @Override
    public ApiFuture<Backup> getBackupAsync(String clusterId, String backupId) {
        BigtableClusterName clusterName = this.instanceName.toClusterName(clusterId);
        GetBackupRequest request = GetBackupRequest.newBuilder().setName(clusterName.toBackupName(backupId)).build();
        return ApiFutureUtil.transformAndAdapt(this.delegate.getBackupAsync(request), new Function<com.google.bigtable.repackaged.com.google.bigtable.admin.v2.Backup, Backup>(){

            @Override
            public Backup apply(com.google.bigtable.repackaged.com.google.bigtable.admin.v2.Backup backup) {
                return Backup.fromProto(backup);
            }
        });
    }

    @Override
    public ApiFuture<Backup> updateBackupAsync(UpdateBackupRequest request) {
        return ApiFutureUtil.transformAndAdapt(this.delegate.updateBackupAsync(request.toProto(this.instanceName.getProjectId(), this.instanceName.getInstanceId())), new Function<com.google.bigtable.repackaged.com.google.bigtable.admin.v2.Backup, Backup>(){

            @Override
            public Backup apply(com.google.bigtable.repackaged.com.google.bigtable.admin.v2.Backup backup) {
                return Backup.fromProto(backup);
            }
        });
    }

    @Override
    public ApiFuture<List<String>> listBackupsAsync(String clusterId) {
        BigtableClusterName clusterName = this.instanceName.toClusterName(clusterId);
        ListBackupsRequest request = ListBackupsRequest.newBuilder().setParent(clusterName.getClusterName()).build();
        return ApiFutureUtil.transformAndAdapt(this.delegate.listBackupsAsync(request), new Function<ListBackupsResponse, List<String>>(){

            @Override
            public List<String> apply(ListBackupsResponse response) {
                ArrayList<String> backups = new ArrayList<String>();
                for (com.google.bigtable.repackaged.com.google.bigtable.admin.v2.Backup backup : response.getBackupsList()) {
                    backups.add(NameUtil.extractBackupIdFromBackupName(backup.getName()));
                }
                return backups;
            }
        });
    }

    @Override
    public ApiFuture<Void> deleteBackupAsync(String clusterId, String backupId) {
        BigtableClusterName clusterName = this.instanceName.toClusterName(clusterId);
        DeleteBackupRequest request = DeleteBackupRequest.newBuilder().setName(clusterName.toBackupName(backupId)).build();
        return ApiFutureUtil.transformAndAdapt(this.delegate.deleteBackupAsync(request), new Function<Empty, Void>(){

            @Override
            public Void apply(Empty empty) {
                return null;
            }
        });
    }

    @Override
    public ApiFuture<RestoredTableResult> restoreTableAsync(RestoreTableRequest request) {
        return ApiFutureUtil.transformAndAdapt(this.delegate.restoreTableAsync(request.toProto(this.instanceName.getProjectId(), this.instanceName.getInstanceId())), new Function<Operation, RestoredTableResult>(){

            @Override
            public RestoredTableResult apply(final Operation operation) {
                try {
                    Future<Operation> operationFuture = BigtableTableAdminClientWrapper.this.batchThreadPool.submit(new Callable<Operation>(){

                        @Override
                        public Operation call() throws Exception {
                            return BigtableTableAdminClientWrapper.this.delegate.waitForOperation(operation);
                        }
                    });
                    return new RestoredTableResult(com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.models.Table.fromProto(operationFuture.get().getResponse().unpack(Table.class)), operation.getMetadata().unpack(RestoreTableMetadata.class).getOptimizeTableOperationName());
                }
                catch (IOException | InterruptedException | ExecutionException e) {
                    throw new IllegalStateException(e);
                }
            }
        });
    }
}

