/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.async;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.async.BigtableAsyncRpc;
import com.google.bigtable.repackaged.io.grpc.CallOptions;
import com.google.bigtable.repackaged.io.grpc.ClientCall;
import com.google.bigtable.repackaged.io.grpc.Metadata;
import com.google.bigtable.repackaged.io.grpc.stub.ClientCallStreamObserver;
import com.google.bigtable.repackaged.javax.annotation.Nullable;

@InternalApi(value="For internal usage only")
public class CallController<RequestT, ResponseT>
extends ClientCallStreamObserver<RequestT> {
    private static final ClientCall NULL_CALL = new ClientCall(){

        public void start(ClientCall.Listener responseListener, Metadata headers) {
        }

        @Override
        public void request(int numMessages) {
        }

        @Override
        public void cancel(String message, Throwable cause) {
        }

        @Override
        public void halfClose() {
        }

        public void sendMessage(Object message) {
        }
    };
    private boolean autoFlowControlEnabled = true;
    private ClientCall<RequestT, ResponseT> call = NULL_CALL;

    synchronized void resetCall() {
        this.call = NULL_CALL;
    }

    synchronized void setCallAndStart(BigtableAsyncRpc<RequestT, ResponseT> rpc, CallOptions callOptions, RequestT request, ClientCall.Listener<ResponseT> listener, Metadata metadata) {
        this.call = rpc.newCall(callOptions);
        rpc.start(request, listener, metadata, this.call);
    }

    @Override
    public void onNext(RequestT value) {
        throw new UnsupportedOperationException("onNext() and client-streaming are not supported.");
    }

    @Override
    public void onError(Throwable t) {
        this.cancel("Cancelled by client with StreamObserver.onError()", t);
    }

    @Override
    public void onCompleted() {
        throw new UnsupportedOperationException("onCompleted() and client-streaming are not supported.");
    }

    @Override
    public synchronized boolean isReady() {
        return this.call.isReady();
    }

    @Override
    public void setOnReadyHandler(Runnable onReadyHandler) {
        throw new UnsupportedOperationException("setOnReadHandler");
    }

    @Override
    public void disableAutoInboundFlowControl() {
        this.autoFlowControlEnabled = false;
    }

    @Override
    public synchronized void request(int count) {
        this.call.request(count);
    }

    @Override
    public void setMessageCompression(boolean enable) {
        throw new UnsupportedOperationException("setMessageCompression()");
    }

    @Override
    public synchronized void cancel(@Nullable String s2, @Nullable Throwable throwable) {
        this.call.cancel(s2, throwable);
    }

    public boolean isAutoFlowControlEnabled() {
        return this.autoFlowControlEnabled;
    }
}

