/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.async;

import com.google.bigtable.repackaged.com.google.api.core.ApiClock;
import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.config.RetryOptions;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.DeadlineGenerator;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.async.AbstractRetryingOperation;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.async.BigtableAsyncRpc;
import com.google.bigtable.repackaged.io.grpc.Metadata;
import com.google.bigtable.repackaged.io.grpc.Status;
import com.google.bigtable.repackaged.io.grpc.StatusRuntimeException;
import java.util.concurrent.ScheduledExecutorService;

@InternalApi(value="For internal usage only")
public class RetryingUnaryOperation<RequestT, ResponseT>
extends AbstractRetryingOperation<RequestT, ResponseT, ResponseT> {
    static final StatusRuntimeException NO_VALUE_SET_EXCEPTION = Status.INTERNAL.withDescription("No value received for unary call").asRuntimeException();
    private ResponseT value;

    public RetryingUnaryOperation(RetryOptions retryOptions, RequestT request, BigtableAsyncRpc<RequestT, ResponseT> retryableRpc, DeadlineGenerator deadlineGenerator, ScheduledExecutorService executorService, Metadata metadata, ApiClock clock) {
        super(retryOptions, request, retryableRpc, deadlineGenerator, executorService, metadata, clock);
    }

    @Override
    public void onMessage(ResponseT message) {
        this.value = message;
        this.completionFuture.set(this.value);
    }

    @Override
    protected boolean onOK(Metadata trailers) {
        if (this.value == null) {
            this.completionFuture.setException(NO_VALUE_SET_EXCEPTION);
        }
        return true;
    }
}

