/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.io;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.bigtable.repackaged.io.grpc.CallOptions;
import com.google.bigtable.repackaged.io.grpc.Channel;
import com.google.bigtable.repackaged.io.grpc.ClientCall;
import com.google.bigtable.repackaged.io.grpc.ClientInterceptor;
import com.google.bigtable.repackaged.io.grpc.ClientInterceptors;
import com.google.bigtable.repackaged.io.grpc.Metadata;
import com.google.bigtable.repackaged.io.grpc.MethodDescriptor;

@InternalApi(value="For internal usage only")
public class HeaderInterceptor
implements ClientInterceptor {
    private final Metadata.Key<String> key;
    private final String defaultValue;

    public HeaderInterceptor(Metadata.Key<String> key, String defaultValue) {
        this.key = key;
        this.defaultValue = defaultValue;
    }

    @Override
    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        return new ClientInterceptors.CheckedForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){

            @Override
            protected void checkedStart(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                HeaderInterceptor.this.updateHeaders(headers);
                this.delegate().start(responseListener, headers);
            }
        };
    }

    @VisibleForTesting
    public void updateHeaders(Metadata headers) {
        if (!headers.containsKey(this.key)) {
            headers.put(this.key, this.defaultValue);
        }
    }

    public String toString() {
        return String.format("%s: (key='%s' value='%s')", this.getClass().getName(), this.key.name(), this.defaultValue);
    }
}

