/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.scanner;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.bigtable.v2.Cell;
import com.google.bigtable.repackaged.com.google.bigtable.v2.Column;
import com.google.bigtable.repackaged.com.google.bigtable.v2.Family;
import com.google.bigtable.repackaged.com.google.bigtable.v2.Row;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.RowCell;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.scanner.FlatRow;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableList;
import com.google.bigtable.repackaged.com.google.protobuf.ByteString;
import java.util.List;

@InternalApi(value="For internal usage only")
public class FlatRowConverter {
    public static Row convert(FlatRow row) {
        if (row == null) {
            return null;
        }
        Row.Builder rowBuilder = Row.newBuilder().setKey(row.getRowKey());
        String prevFamily = null;
        Family.Builder familyBuilder = null;
        ByteString previousColumn = null;
        Column.Builder columnBuilder = null;
        for (FlatRow.Cell cell : row.getCells()) {
            ByteString currentQualifier;
            String currentFamily = cell.getFamily();
            if (!currentFamily.equals(prevFamily)) {
                if (familyBuilder != null) {
                    if (columnBuilder != null) {
                        familyBuilder.addColumns(columnBuilder.build());
                        columnBuilder = null;
                        previousColumn = null;
                    }
                    rowBuilder.addFamilies(familyBuilder.build());
                }
                familyBuilder = Family.newBuilder().setName(currentFamily);
                prevFamily = currentFamily;
            }
            if (!(currentQualifier = cell.getQualifier()).equals(previousColumn)) {
                if (columnBuilder != null) {
                    familyBuilder.addColumns(columnBuilder.build());
                }
                columnBuilder = Column.newBuilder().setQualifier(currentQualifier);
                previousColumn = currentQualifier;
            }
            columnBuilder.addCells(FlatRowConverter.toCell(cell));
        }
        if (familyBuilder != null) {
            if (columnBuilder != null) {
                familyBuilder.addColumns(columnBuilder.build());
            }
            rowBuilder.addFamilies(familyBuilder.build());
        }
        return rowBuilder.build();
    }

    private static Cell toCell(FlatRow.Cell cell) {
        return Cell.newBuilder().setTimestampMicros(cell.getTimestamp()).addAllLabels(cell.getLabels()).setValue(cell.getValue()).build();
    }

    public static com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.Row convertToModelRow(FlatRow row) {
        if (row == null || row.getCells() == null) {
            return null;
        }
        ImmutableList.Builder rowCellList = ImmutableList.builderWithExpectedSize(row.getCells().size());
        for (FlatRow.Cell cell : row.getCells()) {
            rowCellList.add(FlatRowConverter.toRowCell(cell));
        }
        return com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.Row.create(row.getRowKey(), (List<RowCell>)((Object)rowCellList.build()));
    }

    private static RowCell toRowCell(FlatRow.Cell cell) {
        return RowCell.create(cell.getFamily(), cell.getQualifier(), cell.getTimestamp(), cell.getLabels(), cell.getValue());
    }
}

