/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.scanner;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.bigtable.v2.ReadRowsResponse;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.config.Logger;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.scanner.FlatRow;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.util.ByteStringComparator;
import com.google.bigtable.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.bigtable.repackaged.com.google.common.base.Objects;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableList;
import com.google.bigtable.repackaged.com.google.protobuf.ByteString;
import com.google.bigtable.repackaged.io.grpc.stub.StreamObserver;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

@InternalApi(value="For internal usage only")
public class RowMerger
implements StreamObserver<ReadRowsResponse> {
    protected static final Logger LOG = new Logger(RowMerger.class);
    private final StreamObserver<FlatRow> observer;
    private RowMergerState state = RowMergerState.NewRow;
    private ByteString lastCompletedRowKey = null;
    private RowInProgress rowInProgress = null;
    private boolean complete = false;
    private Integer rowCountInLastMessage = null;

    public static List<FlatRow> toRows(Iterable<ReadRowsResponse> responses) {
        final ArrayList<FlatRow> result = new ArrayList<FlatRow>();
        RowMerger rowMerger = new RowMerger(new StreamObserver<FlatRow>(){

            @Override
            public void onNext(FlatRow value) {
                result.add(value);
            }

            @Override
            public void onError(Throwable t) {
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                throw new IllegalStateException(t);
            }

            @Override
            public void onCompleted() {
            }
        });
        for (ReadRowsResponse response : responses) {
            rowMerger.onNext(response);
        }
        rowMerger.onCompleted();
        return result;
    }

    public RowMerger(StreamObserver<FlatRow> observer) {
        this.observer = observer;
    }

    public void clearRowInProgress() {
        Preconditions.checkState(!this.complete, "Cannot reset Rowmerger after completion");
        this.state = RowMergerState.NewRow;
        this.rowInProgress = null;
        this.rowCountInLastMessage = null;
    }

    @Override
    public final void onNext(ReadRowsResponse readRowsResponse) {
        if (this.complete) {
            this.onError(new IllegalStateException("Adding partialRow after completion"));
            return;
        }
        int rowsProcessed = 0;
        for (int i = 0; i < readRowsResponse.getChunksCount(); ++i) {
            try {
                ReadRowsResponse.CellChunk chunk = readRowsResponse.getChunks(i);
                this.state.validateChunk(this.rowInProgress, this.lastCompletedRowKey, chunk);
                if (chunk.getResetRow()) {
                    this.rowInProgress = null;
                    this.state = RowMergerState.NewRow;
                    continue;
                }
                if (this.state == RowMergerState.NewRow) {
                    this.rowInProgress = new RowInProgress();
                    this.rowInProgress.updateCurrentKey(chunk);
                } else if (this.state == RowMergerState.RowInProgress) {
                    this.rowInProgress.updateCurrentKey(chunk);
                }
                if (chunk.getValueSize() > 0) {
                    this.rowInProgress.addPartialCellChunk(chunk);
                    this.state = RowMergerState.CellInProgress;
                } else if (this.rowInProgress.hasChunkInProgess()) {
                    this.rowInProgress.addPartialCellChunk(chunk);
                    this.rowInProgress.completeMultiChunkCell();
                    this.state = RowMergerState.RowInProgress;
                } else {
                    this.rowInProgress.addFullChunk(chunk);
                    this.state = RowMergerState.RowInProgress;
                }
                if (!chunk.getCommitRow()) continue;
                this.observer.onNext(this.rowInProgress.buildRow());
                this.lastCompletedRowKey = this.rowInProgress.getRowKey();
                this.state = RowMergerState.NewRow;
                this.rowInProgress = null;
                ++rowsProcessed;
                continue;
            }
            catch (Throwable e) {
                this.onError(e);
                return;
            }
        }
        this.rowCountInLastMessage = rowsProcessed;
    }

    public Integer getRowCountInLastMessage() {
        return this.rowCountInLastMessage;
    }

    public ByteString getLastCompletedRowKey() {
        return this.lastCompletedRowKey;
    }

    @VisibleForTesting
    boolean isInNewState() {
        return this.state == RowMergerState.NewRow && this.rowInProgress == null;
    }

    @Override
    public void onCompleted() {
        this.complete = true;
        this.state.handleOnComplete(this.observer);
    }

    @Override
    public void onError(Throwable e) {
        this.complete = true;
        this.observer.onError(e);
    }

    @VisibleForTesting
    boolean isComplete() {
        return this.complete;
    }

    private static final class RowInProgress {
        private static final int LARGE_ROW_SIZE = 0x3200000;
        private ByteString rowKey;
        private CellIdentifier currentId;
        private ByteString.Output outputStream;
        private int currentByteSize = 0;
        private int loggedAtSize = 0;
        private final Map<String, List<FlatRow.Cell>> cells = new TreeMap<String, List<FlatRow.Cell>>();
        private int cellCount = 0;
        private List<FlatRow.Cell> currentFamilyRowCells = null;
        private String currentFamily;
        private FlatRow.Cell previousNoLabelCell;

        private RowInProgress() {
        }

        private final void addFullChunk(ReadRowsResponse.CellChunk chunk) {
            Preconditions.checkState(!this.hasChunkInProgess());
            this.currentByteSize += chunk.getSerializedSize();
            this.addCell(chunk.getValue());
            if (this.currentByteSize >= this.loggedAtSize + 0x3200000) {
                LOG.warn("Large row read is in progress. key: `%s`, size: %d, cells: %d", this.rowKey.toStringUtf8(), this.currentByteSize, this.cellCount);
                this.loggedAtSize = this.currentByteSize;
            }
        }

        private final void completeMultiChunkCell() {
            Preconditions.checkArgument(this.hasChunkInProgess());
            this.addCell(this.outputStream.toByteString());
            this.outputStream = null;
        }

        private void addCell(ByteString value) {
            if (!Objects.equal(this.currentFamily, this.currentId.family)) {
                this.currentFamilyRowCells = new ArrayList<FlatRow.Cell>();
                this.currentFamily = this.currentId.family;
                this.cells.put(this.currentId.family, this.currentFamilyRowCells);
                this.previousNoLabelCell = null;
            }
            FlatRow.Cell cell = new FlatRow.Cell(this.currentId.family, this.currentId.qualifier, this.currentId.timestampMicros, value, this.currentId.labels);
            if (!this.currentId.labels.isEmpty()) {
                this.currentFamilyRowCells.add(cell);
            } else if (!this.isSameTimestampAndQualifier()) {
                this.currentFamilyRowCells.add(cell);
                this.previousNoLabelCell = cell;
            }
            ++this.cellCount;
        }

        private boolean isSameTimestampAndQualifier() {
            return this.previousNoLabelCell != null && this.currentId.timestampMicros == this.previousNoLabelCell.getTimestamp() && Objects.equal(this.previousNoLabelCell.getQualifier(), this.currentId.qualifier);
        }

        private final void updateCurrentKey(ReadRowsResponse.CellChunk chunk) {
            ByteString newRowKey = chunk.getRowKey();
            if (this.rowKey == null || !newRowKey.isEmpty() && !newRowKey.equals(this.rowKey)) {
                this.rowKey = newRowKey;
                this.currentId = new CellIdentifier(chunk);
                this.currentFamily = null;
                this.cells.clear();
                this.currentFamilyRowCells = null;
            } else if (chunk.hasFamilyName()) {
                this.currentId.updateForFamily(chunk);
            } else if (chunk.hasQualifier()) {
                this.currentId.updateForQualifier(chunk);
            } else {
                this.currentId.updateForTimestamp(chunk);
            }
        }

        private boolean hasChunkInProgess() {
            return this.outputStream != null;
        }

        private void addPartialCellChunk(ReadRowsResponse.CellChunk chunk) throws IOException {
            if (this.outputStream == null) {
                this.outputStream = ByteString.newOutput();
            }
            chunk.getValue().writeTo(this.outputStream);
        }

        private ByteString getRowKey() {
            return this.rowKey;
        }

        private boolean hasRowKey() {
            return this.rowKey != null;
        }

        private FlatRow buildRow() {
            if (this.currentByteSize >= 0x3200000) {
                LOG.warn("Large row was read. key: `%s`, size: %d, cellCount: %d", this.rowKey.toStringUtf8(), this.currentByteSize, this.cellCount);
            }
            return new FlatRow(this.rowKey, this.flattenCells());
        }

        private ImmutableList<FlatRow.Cell> flattenCells() {
            ImmutableList.Builder combined = ImmutableList.builder();
            for (List<FlatRow.Cell> familyCellList : this.cells.values()) {
                combined.addAll(familyCellList);
            }
            return combined.build();
        }
    }

    private static class CellIdentifier {
        String family;
        ByteString qualifier;
        long timestampMicros;
        List<String> labels;

        private CellIdentifier(ReadRowsResponse.CellChunk chunk) {
            this.updateForFamily(chunk);
        }

        private void updateForFamily(ReadRowsResponse.CellChunk chunk) {
            String chunkFamily = chunk.getFamilyName().getValue();
            if (!chunkFamily.equals(this.family)) {
                this.family = chunkFamily;
            }
            this.updateForQualifier(chunk);
        }

        private void updateForQualifier(ReadRowsResponse.CellChunk chunk) {
            this.qualifier = chunk.getQualifier().getValue();
            this.updateForTimestamp(chunk);
        }

        private void updateForTimestamp(ReadRowsResponse.CellChunk chunk) {
            this.timestampMicros = chunk.getTimestampMicros();
            this.labels = chunk.getLabelsList();
        }
    }

    private static enum RowMergerState {
        NewRow{

            @Override
            void validateChunk(RowInProgress rowInProgess, ByteString previousKey, ReadRowsResponse.CellChunk newChunk) {
                Preconditions.checkArgument(rowInProgess == null || !rowInProgess.hasRowKey(), "A new row cannot have existing state: %s", (Object)newChunk);
                Preconditions.checkArgument(newChunk.getRowStatusCase() != ReadRowsResponse.CellChunk.RowStatusCase.RESET_ROW, "A new row cannot be reset: %s", (Object)newChunk);
                Preconditions.checkArgument(newChunk.hasFamilyName(), "A family must be set: %s", (Object)newChunk);
                ByteString rowKey = newChunk.getRowKey();
                Preconditions.checkArgument(!rowKey.isEmpty(), "A row key must be set: %s", (Object)newChunk);
                if (previousKey != null && ByteStringComparator.INSTANCE.compare(previousKey, rowKey) >= 0) {
                    throw new IllegalArgumentException(String.format("Found key '%s' after key '%s'", rowKey.toStringUtf8(), previousKey.toStringUtf8()));
                }
                Preconditions.checkArgument(newChunk.hasQualifier(), "A column qualifier must be set: %s", (Object)newChunk);
                Preconditions.checkArgument(!newChunk.getCommitRow() || newChunk.getValueSize() == 0, "A row cannot be have a value size and be a commit row: %s", (Object)newChunk);
            }

            @Override
            void handleOnComplete(StreamObserver<FlatRow> observer) {
                observer.onCompleted();
            }
        }
        ,
        RowInProgress{

            @Override
            void validateChunk(RowInProgress rowInProgess, ByteString previousKey, ReadRowsResponse.CellChunk newChunk) {
                if (newChunk.hasFamilyName()) {
                    Preconditions.checkArgument(newChunk.hasQualifier(), "A qualifier must be specified: %s", (Object)newChunk);
                }
                ByteString newRowKey = newChunk.getRowKey();
                if (newChunk.getResetRow()) {
                    Preconditions.checkState(newRowKey.isEmpty() && !newChunk.hasFamilyName() && !newChunk.hasQualifier() && newChunk.getValue().isEmpty() && newChunk.getTimestampMicros() == 0L, "A reset should have no data");
                } else {
                    Preconditions.checkState(newRowKey.isEmpty() || newRowKey.equals(rowInProgess.getRowKey()), "A commit is required between row keys: %s", (Object)newChunk);
                    Preconditions.checkArgument(newChunk.getValueSize() == 0 || !newChunk.getCommitRow(), "A row cannot be have a value size and be a commit row: %s", (Object)newChunk);
                }
            }

            @Override
            void handleOnComplete(StreamObserver<FlatRow> observer) {
                observer.onError(new IllegalStateException("Got a partial row, but the stream ended"));
            }
        }
        ,
        CellInProgress{

            @Override
            void validateChunk(RowInProgress rowInProgess, ByteString previousKey, ReadRowsResponse.CellChunk newChunk) {
                if (newChunk.getResetRow()) {
                    Preconditions.checkState(newChunk.getRowKey().isEmpty() && !newChunk.hasFamilyName() && !newChunk.hasQualifier() && newChunk.getValue().isEmpty() && newChunk.getTimestampMicros() == 0L, "A reset should have no data");
                } else {
                    Preconditions.checkArgument(newChunk.getValueSize() == 0 || !newChunk.getCommitRow(), "A row cannot be have a value size and be a commit row: %s", (Object)newChunk);
                }
            }

            @Override
            void handleOnComplete(StreamObserver<FlatRow> observer) {
                observer.onError(new IllegalStateException("Got a partial row, but the stream ended"));
            }
        };


        abstract void validateChunk(RowInProgress var1, ByteString var2, ReadRowsResponse.CellChunk var3) throws Exception;

        abstract void handleOnComplete(StreamObserver<FlatRow> var1);
    }
}

