/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.monitoring.v3;

import com.google.bigtable.repackaged.com.google.api.pathtemplate.PathTemplate;
import com.google.bigtable.repackaged.com.google.api.resourcenames.ResourceName;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class MetricDescriptorName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding("projects/{project}/metricDescriptors/{metric_descriptor=**}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String metricDescriptor;

    public String getProject() {
        return this.project;
    }

    public String getMetricDescriptor() {
        return this.metricDescriptor;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private MetricDescriptorName(Builder builder) {
        this.project = Preconditions.checkNotNull(builder.getProject());
        this.metricDescriptor = Preconditions.checkNotNull(builder.getMetricDescriptor());
    }

    public static MetricDescriptorName of(String project, String metricDescriptor) {
        return MetricDescriptorName.newBuilder().setProject(project).setMetricDescriptor(metricDescriptor).build();
    }

    public static String format(String project, String metricDescriptor) {
        return MetricDescriptorName.newBuilder().setProject(project).setMetricDescriptor(metricDescriptor).build().toString();
    }

    public static MetricDescriptorName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map<String, String> matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "MetricDescriptorName.parse: formattedString not in valid format");
        return MetricDescriptorName.of(matchMap.get("project"), matchMap.get("metric_descriptor"));
    }

    public static List<MetricDescriptorName> parseList(List<String> formattedStrings) {
        ArrayList<MetricDescriptorName> list = new ArrayList<MetricDescriptorName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(MetricDescriptorName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<MetricDescriptorName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (MetricDescriptorName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            MetricDescriptorName metricDescriptorName = this;
            synchronized (metricDescriptorName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder<String, String> fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put("project", this.project);
                    fieldMapBuilder.put("metricDescriptor", this.metricDescriptor);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    @Override
    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate("project", this.project, "metric_descriptor", this.metricDescriptor);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof MetricDescriptorName) {
            MetricDescriptorName that = (MetricDescriptorName)o;
            return this.project.equals(that.project) && this.metricDescriptor.equals(that.metricDescriptor);
        }
        return false;
    }

    public int hashCode() {
        int h2 = 1;
        h2 *= 1000003;
        h2 ^= this.project.hashCode();
        h2 *= 1000003;
        return h2 ^= this.metricDescriptor.hashCode();
    }

    public static class Builder {
        private String project;
        private String metricDescriptor;

        public String getProject() {
            return this.project;
        }

        public String getMetricDescriptor() {
            return this.metricDescriptor;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setMetricDescriptor(String metricDescriptor) {
            this.metricDescriptor = metricDescriptor;
            return this;
        }

        private Builder() {
        }

        private Builder(MetricDescriptorName metricDescriptorName) {
            this.project = metricDescriptorName.project;
            this.metricDescriptor = metricDescriptorName.metricDescriptor;
        }

        public MetricDescriptorName build() {
            return new MetricDescriptorName(this);
        }
    }
}

