/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc.netty.shaded.io.netty.handler.codec.compression;

import com.google.bigtable.repackaged.io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import com.google.bigtable.repackaged.io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import com.google.bigtable.repackaged.io.grpc.netty.shaded.io.netty.handler.codec.ByteToMessageDecoder;
import com.google.bigtable.repackaged.io.grpc.netty.shaded.io.netty.handler.codec.compression.DecompressionException;

public abstract class ZlibDecoder
extends ByteToMessageDecoder {
    protected final int maxAllocation;

    public ZlibDecoder() {
        this(0);
    }

    public ZlibDecoder(int maxAllocation) {
        if (maxAllocation < 0) {
            throw new IllegalArgumentException("maxAllocation must be >= 0");
        }
        this.maxAllocation = maxAllocation;
    }

    public abstract boolean isClosed();

    protected ByteBuf prepareDecompressBuffer(ChannelHandlerContext ctx, ByteBuf buffer, int preferredSize) {
        if (buffer == null) {
            if (this.maxAllocation == 0) {
                return ctx.alloc().heapBuffer(preferredSize);
            }
            return ctx.alloc().heapBuffer(Math.min(preferredSize, this.maxAllocation), this.maxAllocation);
        }
        if (buffer.ensureWritable(preferredSize, true) == 1) {
            this.decompressionBufferExhausted(buffer.duplicate());
            buffer.skipBytes(buffer.readableBytes());
            throw new DecompressionException("Decompression buffer has reached maximum size: " + buffer.maxCapacity());
        }
        return buffer;
    }

    protected void decompressionBufferExhausted(ByteBuf buffer) {
    }
}

