/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.opencensus.contrib.grpc.util;

import com.google.bigtable.repackaged.io.grpc.Status;
import com.google.bigtable.repackaged.io.opencensus.trace.Status;

public final class StatusConverter {
    public static Status.CanonicalCode fromGrpcCode(Status.Code grpcCode) {
        return StatusConverter.opencensusStatusFromGrpcCode(grpcCode).getCanonicalCode();
    }

    public static Status fromGrpcStatus(com.google.bigtable.repackaged.io.grpc.Status grpcStatus) {
        Status status = StatusConverter.opencensusStatusFromGrpcCode(grpcStatus.getCode());
        String description = grpcStatus.getDescription();
        if (description != null) {
            status = status.withDescription(description);
        }
        return status;
    }

    public static Status.Code toGrpcCode(Status.CanonicalCode opencensusCanonicalCode) {
        return StatusConverter.grpcStatusFromOpencensusCanonicalCode(opencensusCanonicalCode).getCode();
    }

    public static com.google.bigtable.repackaged.io.grpc.Status toGrpcStatus(Status opencensusStatus) {
        com.google.bigtable.repackaged.io.grpc.Status status = StatusConverter.grpcStatusFromOpencensusCanonicalCode(opencensusStatus.getCanonicalCode());
        if (opencensusStatus.getDescription() != null) {
            status = status.withDescription(opencensusStatus.getDescription());
        }
        return status;
    }

    private static Status opencensusStatusFromGrpcCode(Status.Code grpcCanonicaleCode) {
        switch (grpcCanonicaleCode) {
            case OK: {
                return Status.OK;
            }
            case CANCELLED: {
                return Status.CANCELLED;
            }
            case UNKNOWN: {
                return Status.UNKNOWN;
            }
            case INVALID_ARGUMENT: {
                return Status.INVALID_ARGUMENT;
            }
            case DEADLINE_EXCEEDED: {
                return Status.DEADLINE_EXCEEDED;
            }
            case NOT_FOUND: {
                return Status.NOT_FOUND;
            }
            case ALREADY_EXISTS: {
                return Status.ALREADY_EXISTS;
            }
            case PERMISSION_DENIED: {
                return Status.PERMISSION_DENIED;
            }
            case RESOURCE_EXHAUSTED: {
                return Status.RESOURCE_EXHAUSTED;
            }
            case FAILED_PRECONDITION: {
                return Status.FAILED_PRECONDITION;
            }
            case ABORTED: {
                return Status.ABORTED;
            }
            case OUT_OF_RANGE: {
                return Status.OUT_OF_RANGE;
            }
            case UNIMPLEMENTED: {
                return Status.UNIMPLEMENTED;
            }
            case INTERNAL: {
                return Status.INTERNAL;
            }
            case UNAVAILABLE: {
                return Status.UNAVAILABLE;
            }
            case DATA_LOSS: {
                return Status.DATA_LOSS;
            }
            case UNAUTHENTICATED: {
                return Status.UNAUTHENTICATED;
            }
        }
        throw new AssertionError((Object)("Unhandled status code " + (Object)((Object)grpcCanonicaleCode)));
    }

    private static com.google.bigtable.repackaged.io.grpc.Status grpcStatusFromOpencensusCanonicalCode(Status.CanonicalCode opencensusCanonicalCode) {
        switch (opencensusCanonicalCode) {
            case OK: {
                return com.google.bigtable.repackaged.io.grpc.Status.OK;
            }
            case CANCELLED: {
                return com.google.bigtable.repackaged.io.grpc.Status.CANCELLED;
            }
            case UNKNOWN: {
                return com.google.bigtable.repackaged.io.grpc.Status.UNKNOWN;
            }
            case INVALID_ARGUMENT: {
                return com.google.bigtable.repackaged.io.grpc.Status.INVALID_ARGUMENT;
            }
            case DEADLINE_EXCEEDED: {
                return com.google.bigtable.repackaged.io.grpc.Status.DEADLINE_EXCEEDED;
            }
            case NOT_FOUND: {
                return com.google.bigtable.repackaged.io.grpc.Status.NOT_FOUND;
            }
            case ALREADY_EXISTS: {
                return com.google.bigtable.repackaged.io.grpc.Status.ALREADY_EXISTS;
            }
            case PERMISSION_DENIED: {
                return com.google.bigtable.repackaged.io.grpc.Status.PERMISSION_DENIED;
            }
            case RESOURCE_EXHAUSTED: {
                return com.google.bigtable.repackaged.io.grpc.Status.RESOURCE_EXHAUSTED;
            }
            case FAILED_PRECONDITION: {
                return com.google.bigtable.repackaged.io.grpc.Status.FAILED_PRECONDITION;
            }
            case ABORTED: {
                return com.google.bigtable.repackaged.io.grpc.Status.ABORTED;
            }
            case OUT_OF_RANGE: {
                return com.google.bigtable.repackaged.io.grpc.Status.OUT_OF_RANGE;
            }
            case UNIMPLEMENTED: {
                return com.google.bigtable.repackaged.io.grpc.Status.UNIMPLEMENTED;
            }
            case INTERNAL: {
                return com.google.bigtable.repackaged.io.grpc.Status.INTERNAL;
            }
            case UNAVAILABLE: {
                return com.google.bigtable.repackaged.io.grpc.Status.UNAVAILABLE;
            }
            case DATA_LOSS: {
                return com.google.bigtable.repackaged.io.grpc.Status.DATA_LOSS;
            }
            case UNAUTHENTICATED: {
                return com.google.bigtable.repackaged.io.grpc.Status.UNAUTHENTICATED;
            }
        }
        throw new AssertionError((Object)("Unhandled status code " + (Object)((Object)opencensusCanonicalCode)));
    }

    private StatusConverter() {
    }
}

