/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.opencensus.exporter.metrics.util;

import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.common.collect.EvictingQueue;
import com.google.bigtable.repackaged.io.opencensus.exporter.metrics.util.AutoValue_QueueMetricProducer_Options;
import com.google.bigtable.repackaged.io.opencensus.metrics.export.Metric;
import com.google.bigtable.repackaged.io.opencensus.metrics.export.MetricProducer;
import com.google.bigtable.repackaged.javax.annotation.concurrent.GuardedBy;
import com.google.bigtable.repackaged.javax.annotation.concurrent.Immutable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Queue;

public final class QueueMetricProducer
extends MetricProducer {
    private static final Object monitor = new Object();
    private static final int DEFAULT_BUFFER_SIZE = 32;
    @GuardedBy(value="monitor")
    private final Queue<Metric> bufferedMetrics;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QueueMetricProducer(int bufferSize) {
        Object object = monitor;
        synchronized (object) {
            this.bufferedMetrics = EvictingQueue.create(bufferSize);
        }
    }

    public static QueueMetricProducer create(Options options) {
        Preconditions.checkNotNull(options, "options");
        Preconditions.checkArgument(options.getBufferSize() > 0, "buffer size should be positive.");
        return new QueueMetricProducer(options.getBufferSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushMetrics(Collection<Metric> metrics) {
        Object object = monitor;
        synchronized (object) {
            this.bufferedMetrics.addAll(metrics);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Metric> getMetrics() {
        ArrayList<Metric> metricsToExport;
        Object object = monitor;
        synchronized (object) {
            metricsToExport = new ArrayList<Metric>(this.bufferedMetrics);
            this.bufferedMetrics.clear();
        }
        return Collections.unmodifiableList(metricsToExport);
    }

    @Immutable
    public static abstract class Options {
        Options() {
        }

        public abstract int getBufferSize();

        public static Builder builder() {
            return new AutoValue_QueueMetricProducer_Options.Builder().setBufferSize(32);
        }

        public static abstract class Builder {
            public abstract Builder setBufferSize(int var1);

            public abstract Options build();
        }
    }
}

