/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.opencensus.exporter.stats.stackdriver;

import com.google.bigtable.repackaged.com.google.api.Distribution;
import com.google.bigtable.repackaged.com.google.api.LabelDescriptor;
import com.google.bigtable.repackaged.com.google.api.Metric;
import com.google.bigtable.repackaged.com.google.api.MetricDescriptor;
import com.google.bigtable.repackaged.com.google.api.MonitoredResource;
import com.google.bigtable.repackaged.com.google.cloud.MetadataConfig;
import com.google.bigtable.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.bigtable.repackaged.com.google.common.base.Strings;
import com.google.bigtable.repackaged.com.google.common.collect.Lists;
import com.google.bigtable.repackaged.com.google.common.collect.Maps;
import com.google.bigtable.repackaged.com.google.monitoring.v3.Point;
import com.google.bigtable.repackaged.com.google.monitoring.v3.TimeInterval;
import com.google.bigtable.repackaged.com.google.monitoring.v3.TimeSeries;
import com.google.bigtable.repackaged.com.google.monitoring.v3.TypedValue;
import com.google.bigtable.repackaged.com.google.protobuf.Any;
import com.google.bigtable.repackaged.com.google.protobuf.ByteString;
import com.google.bigtable.repackaged.com.google.protobuf.Timestamp;
import com.google.bigtable.repackaged.io.opencensus.common.Function;
import com.google.bigtable.repackaged.io.opencensus.common.Functions;
import com.google.bigtable.repackaged.io.opencensus.contrib.exemplar.util.AttachmentValueSpanContext;
import com.google.bigtable.repackaged.io.opencensus.contrib.resource.util.ResourceUtils;
import com.google.bigtable.repackaged.io.opencensus.metrics.LabelKey;
import com.google.bigtable.repackaged.io.opencensus.metrics.LabelValue;
import com.google.bigtable.repackaged.io.opencensus.metrics.data.AttachmentValue;
import com.google.bigtable.repackaged.io.opencensus.metrics.data.Exemplar;
import com.google.bigtable.repackaged.io.opencensus.metrics.export.Distribution;
import com.google.bigtable.repackaged.io.opencensus.metrics.export.MetricDescriptor;
import com.google.bigtable.repackaged.io.opencensus.metrics.export.Point;
import com.google.bigtable.repackaged.io.opencensus.metrics.export.Summary;
import com.google.bigtable.repackaged.io.opencensus.metrics.export.TimeSeries;
import com.google.bigtable.repackaged.io.opencensus.metrics.export.Value;
import com.google.bigtable.repackaged.io.opencensus.resource.Resource;
import com.google.bigtable.repackaged.io.opencensus.trace.SpanContext;
import com.google.bigtable.repackaged.javax.annotation.Nullable;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

final class StackdriverExportUtils {
    @VisibleForTesting
    static final LabelKey OPENCENSUS_TASK_KEY = LabelKey.create("opencensus_task", "Opencensus task identifier");
    @VisibleForTesting
    static final LabelValue OPENCENSUS_TASK_VALUE_DEFAULT = LabelValue.create(StackdriverExportUtils.generateDefaultTaskValue());
    static final Map<LabelKey, LabelValue> DEFAULT_CONSTANT_LABELS = Collections.singletonMap(OPENCENSUS_TASK_KEY, OPENCENSUS_TASK_VALUE_DEFAULT);
    @VisibleForTesting
    static final String STACKDRIVER_PROJECT_ID_KEY = "project_id";
    @VisibleForTesting
    static final String DEFAULT_DISPLAY_NAME_PREFIX = "OpenCensus/";
    @VisibleForTesting
    static final String CUSTOM_METRIC_DOMAIN = "custom.googleapis.com/";
    @VisibleForTesting
    static final String CUSTOM_OPENCENSUS_DOMAIN = "custom.googleapis.com/opencensus/";
    @VisibleForTesting
    static final int MAX_BATCH_EXPORT_SIZE = 200;
    private static final String K8S_CONTAINER = "k8s_container";
    private static final String GCP_GCE_INSTANCE = "gce_instance";
    private static final String AWS_EC2_INSTANCE = "aws_ec2_instance";
    private static final String GLOBAL = "global";
    @VisibleForTesting
    static final String AWS_REGION_VALUE_PREFIX = "aws:";
    private static final Logger logger = Logger.getLogger(StackdriverExportUtils.class.getName());
    private static final Map<String, String> GCP_RESOURCE_MAPPING = StackdriverExportUtils.getGcpResourceLabelsMappings();
    private static final Map<String, String> K8S_RESOURCE_MAPPING = StackdriverExportUtils.getK8sResourceLabelsMappings();
    private static final Map<String, String> AWS_RESOURCE_MAPPING = StackdriverExportUtils.getAwsResourceLabelsMappings();
    @VisibleForTesting
    static final LabelKey PERCENTILE_LABEL_KEY = LabelKey.create("percentile", "the value at a given percentile of a distribution");
    @VisibleForTesting
    static final String SNAPSHOT_SUFFIX_PERCENTILE = "_summary_snapshot_percentile";
    @VisibleForTesting
    static final String SUMMARY_SUFFIX_COUNT = "_summary_count";
    @VisibleForTesting
    static final String SUMMARY_SUFFIX_SUM = "_summary_sum";
    @Nullable
    private static volatile String cachedProjectIdForExemplar = null;
    @VisibleForTesting
    static final String EXEMPLAR_ATTACHMENT_TYPE_STRING = "type.googleapis.com/google.protobuf.StringValue";
    @VisibleForTesting
    static final String EXEMPLAR_ATTACHMENT_TYPE_SPAN_CONTEXT = "type.googleapis.com/google.monitoring.v3.SpanContext";
    private static final Function<Double, TypedValue> typedValueDoubleFunction = new Function<Double, TypedValue>(){

        @Override
        public TypedValue apply(Double arg) {
            TypedValue.Builder builder = TypedValue.newBuilder();
            builder.setDoubleValue(arg);
            return builder.build();
        }
    };
    private static final Function<Long, TypedValue> typedValueLongFunction = new Function<Long, TypedValue>(){

        @Override
        public TypedValue apply(Long arg) {
            TypedValue.Builder builder = TypedValue.newBuilder();
            builder.setInt64Value(arg);
            return builder.build();
        }
    };
    private static final Function<Distribution, TypedValue> typedValueDistributionFunction = new Function<Distribution, TypedValue>(){

        @Override
        public TypedValue apply(Distribution arg) {
            TypedValue.Builder builder = TypedValue.newBuilder();
            return builder.setDistributionValue(StackdriverExportUtils.createDistribution(arg)).build();
        }
    };
    private static final Function<Summary, TypedValue> typedValueSummaryFunction = new Function<Summary, TypedValue>(){

        @Override
        public TypedValue apply(Summary arg) {
            TypedValue.Builder builder = TypedValue.newBuilder();
            return builder.build();
        }
    };
    private static final Function<Distribution.BucketOptions.ExplicitOptions, Distribution.BucketOptions> bucketOptionsExplicitFunction = new Function<Distribution.BucketOptions.ExplicitOptions, Distribution.BucketOptions>(){

        @Override
        public Distribution.BucketOptions apply(Distribution.BucketOptions.ExplicitOptions arg) {
            Distribution.BucketOptions.Builder builder = Distribution.BucketOptions.newBuilder();
            Distribution.BucketOptions.Explicit.Builder explicitBuilder = Distribution.BucketOptions.Explicit.newBuilder();
            explicitBuilder.addBounds(0.0);
            explicitBuilder.addAllBounds(arg.getBucketBoundaries());
            builder.setExplicitBuckets(explicitBuilder.build());
            return builder.build();
        }
    };

    private static String generateDefaultTaskValue() {
        String jvmName = ManagementFactory.getRuntimeMXBean().getName();
        if (jvmName.indexOf(64) < 1) {
            String hostname = "localhost";
            try {
                hostname = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                logger.log(Level.INFO, "Unable to get the hostname.", e);
            }
            return "java-" + new SecureRandom().nextInt() + "@" + hostname;
        }
        return "java-" + jvmName;
    }

    static MetricDescriptor createMetricDescriptor(com.google.bigtable.repackaged.io.opencensus.metrics.export.MetricDescriptor metricDescriptor, String projectId, String domain, String displayNamePrefix, Map<LabelKey, LabelValue> constantLabels) {
        MetricDescriptor.Builder builder = MetricDescriptor.newBuilder();
        String type = StackdriverExportUtils.generateType(metricDescriptor.getName(), domain);
        builder.setName("projects/" + projectId + "/metricDescriptors/" + type);
        builder.setType(type);
        builder.setDescription(metricDescriptor.getDescription());
        builder.setDisplayName(StackdriverExportUtils.createDisplayName(metricDescriptor.getName(), displayNamePrefix));
        for (LabelKey labelKey : metricDescriptor.getLabelKeys()) {
            builder.addLabels(StackdriverExportUtils.createLabelDescriptor(labelKey));
        }
        for (LabelKey labelKey : constantLabels.keySet()) {
            builder.addLabels(StackdriverExportUtils.createLabelDescriptor(labelKey));
        }
        builder.setUnit(metricDescriptor.getUnit());
        builder.setMetricKind(StackdriverExportUtils.createMetricKind(metricDescriptor.getType()));
        builder.setValueType(StackdriverExportUtils.createValueType(metricDescriptor.getType()));
        return builder.build();
    }

    private static String generateType(String metricName, String domain) {
        return domain + metricName;
    }

    private static String createDisplayName(String metricName, String displayNamePrefix) {
        return displayNamePrefix + metricName;
    }

    @VisibleForTesting
    static LabelDescriptor createLabelDescriptor(LabelKey labelKey) {
        LabelDescriptor.Builder builder = LabelDescriptor.newBuilder();
        builder.setKey(labelKey.getKey());
        builder.setDescription(labelKey.getDescription());
        builder.setValueType(LabelDescriptor.ValueType.STRING);
        return builder.build();
    }

    @VisibleForTesting
    static MetricDescriptor.MetricKind createMetricKind(MetricDescriptor.Type type) {
        if (type == MetricDescriptor.Type.GAUGE_INT64 || type == MetricDescriptor.Type.GAUGE_DOUBLE) {
            return MetricDescriptor.MetricKind.GAUGE;
        }
        if (type == MetricDescriptor.Type.CUMULATIVE_INT64 || type == MetricDescriptor.Type.CUMULATIVE_DOUBLE || type == MetricDescriptor.Type.CUMULATIVE_DISTRIBUTION) {
            return MetricDescriptor.MetricKind.CUMULATIVE;
        }
        return MetricDescriptor.MetricKind.UNRECOGNIZED;
    }

    @VisibleForTesting
    static MetricDescriptor.ValueType createValueType(MetricDescriptor.Type type) {
        if (type == MetricDescriptor.Type.CUMULATIVE_DOUBLE || type == MetricDescriptor.Type.GAUGE_DOUBLE) {
            return MetricDescriptor.ValueType.DOUBLE;
        }
        if (type == MetricDescriptor.Type.GAUGE_INT64 || type == MetricDescriptor.Type.CUMULATIVE_INT64) {
            return MetricDescriptor.ValueType.INT64;
        }
        if (type == MetricDescriptor.Type.GAUGE_DISTRIBUTION || type == MetricDescriptor.Type.CUMULATIVE_DISTRIBUTION) {
            return MetricDescriptor.ValueType.DISTRIBUTION;
        }
        return MetricDescriptor.ValueType.UNRECOGNIZED;
    }

    static List<com.google.bigtable.repackaged.com.google.monitoring.v3.TimeSeries> createTimeSeriesList(com.google.bigtable.repackaged.io.opencensus.metrics.export.Metric metric, MonitoredResource monitoredResource, String domain, String projectId, Map<LabelKey, LabelValue> constantLabels) {
        ArrayList<com.google.bigtable.repackaged.com.google.monitoring.v3.TimeSeries> timeSeriesList = Lists.newArrayList();
        com.google.bigtable.repackaged.io.opencensus.metrics.export.MetricDescriptor metricDescriptor = metric.getMetricDescriptor();
        if (!projectId.equals(cachedProjectIdForExemplar)) {
            cachedProjectIdForExemplar = projectId;
        }
        TimeSeries.Builder shared = com.google.bigtable.repackaged.com.google.monitoring.v3.TimeSeries.newBuilder();
        shared.setMetricKind(StackdriverExportUtils.createMetricKind(metricDescriptor.getType()));
        shared.setResource(monitoredResource);
        shared.setValueType(StackdriverExportUtils.createValueType(metricDescriptor.getType()));
        for (TimeSeries timeSeries : metric.getTimeSeriesList()) {
            TimeSeries.Builder builder = shared.clone();
            builder.setMetric(StackdriverExportUtils.createMetric(metricDescriptor, timeSeries.getLabelValues(), domain, constantLabels));
            com.google.bigtable.repackaged.io.opencensus.common.Timestamp startTimeStamp = timeSeries.getStartTimestamp();
            for (Point point : timeSeries.getPoints()) {
                builder.addPoints(StackdriverExportUtils.createPoint(point, startTimeStamp));
            }
            timeSeriesList.add(builder.build());
        }
        return timeSeriesList;
    }

    @VisibleForTesting
    static Metric createMetric(com.google.bigtable.repackaged.io.opencensus.metrics.export.MetricDescriptor metricDescriptor, List<LabelValue> labelValues, String domain, Map<LabelKey, LabelValue> constantLabels) {
        Metric.Builder builder = Metric.newBuilder();
        builder.setType(StackdriverExportUtils.generateType(metricDescriptor.getName(), domain));
        HashMap<String, String> stringTagMap = Maps.newHashMap();
        List<LabelKey> labelKeys = metricDescriptor.getLabelKeys();
        for (int i = 0; i < labelValues.size(); ++i) {
            String value = labelValues.get(i).getValue();
            if (value == null) continue;
            stringTagMap.put(labelKeys.get(i).getKey(), value);
        }
        for (Map.Entry<LabelKey, LabelValue> constantLabel : constantLabels.entrySet()) {
            String constantLabelKey = constantLabel.getKey().getKey();
            String constantLabelValue = constantLabel.getValue().getValue();
            constantLabelValue = constantLabelValue == null ? "" : constantLabelValue;
            stringTagMap.put(constantLabelKey, constantLabelValue);
        }
        builder.putAllLabels(stringTagMap);
        return builder.build();
    }

    @VisibleForTesting
    static com.google.bigtable.repackaged.com.google.monitoring.v3.Point createPoint(Point point, @Nullable com.google.bigtable.repackaged.io.opencensus.common.Timestamp startTimestamp) {
        TimeInterval.Builder timeIntervalBuilder = TimeInterval.newBuilder();
        timeIntervalBuilder.setEndTime(StackdriverExportUtils.convertTimestamp(point.getTimestamp()));
        if (startTimestamp != null) {
            timeIntervalBuilder.setStartTime(StackdriverExportUtils.convertTimestamp(startTimestamp));
        }
        Point.Builder builder = com.google.bigtable.repackaged.com.google.monitoring.v3.Point.newBuilder();
        builder.setInterval(timeIntervalBuilder.build());
        builder.setValue(StackdriverExportUtils.createTypedValue(point.getValue()));
        return builder.build();
    }

    @VisibleForTesting
    static TypedValue createTypedValue(Value value) {
        return value.match(typedValueDoubleFunction, typedValueLongFunction, typedValueDistributionFunction, typedValueSummaryFunction, Functions.throwIllegalArgumentException());
    }

    @VisibleForTesting
    static com.google.bigtable.repackaged.com.google.api.Distribution createDistribution(Distribution distribution) {
        Distribution.Builder builder = com.google.bigtable.repackaged.com.google.api.Distribution.newBuilder().setBucketOptions(StackdriverExportUtils.createBucketOptions(distribution.getBucketOptions())).setCount(distribution.getCount()).setMean(distribution.getCount() == 0L ? 0.0 : distribution.getSum() / (double)distribution.getCount()).setSumOfSquaredDeviation(distribution.getSumOfSquaredDeviations());
        StackdriverExportUtils.setBucketCountsAndExemplars(distribution.getBuckets(), builder);
        return builder.build();
    }

    @VisibleForTesting
    static Distribution.BucketOptions createBucketOptions(@Nullable Distribution.BucketOptions bucketOptions) {
        Distribution.BucketOptions.Builder builder = Distribution.BucketOptions.newBuilder();
        if (bucketOptions == null) {
            return builder.build();
        }
        return bucketOptions.match(bucketOptionsExplicitFunction, Functions.throwIllegalArgumentException());
    }

    private static void setBucketCountsAndExemplars(List<Distribution.Bucket> buckets, Distribution.Builder builder) {
        builder.addBucketCounts(0L);
        for (Distribution.Bucket bucket : buckets) {
            builder.addBucketCounts(bucket.getCount());
            Exemplar exemplar = bucket.getExemplar();
            if (exemplar == null) continue;
            builder.addExemplars(StackdriverExportUtils.toProtoExemplar(exemplar));
        }
    }

    private static Distribution.Exemplar toProtoExemplar(Exemplar exemplar) {
        Distribution.Exemplar.Builder builder = Distribution.Exemplar.newBuilder().setValue(exemplar.getValue()).setTimestamp(StackdriverExportUtils.convertTimestamp(exemplar.getTimestamp()));
        SpanContext spanContext = null;
        for (Map.Entry<String, AttachmentValue> attachment : exemplar.getAttachments().entrySet()) {
            String key = attachment.getKey();
            AttachmentValue value = attachment.getValue();
            if ("SpanContext".equals(key)) {
                spanContext = ((AttachmentValueSpanContext)value).getSpanContext();
                continue;
            }
            builder.addAttachments(StackdriverExportUtils.toProtoStringAttachment(value));
        }
        if (spanContext != null && cachedProjectIdForExemplar != null) {
            com.google.bigtable.repackaged.com.google.monitoring.v3.SpanContext protoSpanContext = StackdriverExportUtils.toProtoSpanContext(spanContext, cachedProjectIdForExemplar);
            builder.addAttachments(StackdriverExportUtils.toProtoSpanContextAttachment(protoSpanContext));
        }
        return builder.build();
    }

    private static Any toProtoStringAttachment(AttachmentValue attachmentValue) {
        return Any.newBuilder().setTypeUrl(EXEMPLAR_ATTACHMENT_TYPE_STRING).setValue(ByteString.copyFromUtf8(attachmentValue.getValue())).build();
    }

    private static Any toProtoSpanContextAttachment(com.google.bigtable.repackaged.com.google.monitoring.v3.SpanContext protoSpanContext) {
        return Any.newBuilder().setTypeUrl(EXEMPLAR_ATTACHMENT_TYPE_SPAN_CONTEXT).setValue(protoSpanContext.toByteString()).build();
    }

    private static com.google.bigtable.repackaged.com.google.monitoring.v3.SpanContext toProtoSpanContext(SpanContext spanContext, String projectId) {
        String spanName = String.format("projects/%s/traces/%s/spans/%s", projectId, spanContext.getTraceId().toLowerBase16(), spanContext.getSpanId().toLowerBase16());
        return com.google.bigtable.repackaged.com.google.monitoring.v3.SpanContext.newBuilder().setSpanName(spanName).build();
    }

    @VisibleForTesting
    static void setCachedProjectIdForExemplar(@Nullable String projectId) {
        cachedProjectIdForExemplar = projectId;
    }

    @VisibleForTesting
    static Timestamp convertTimestamp(com.google.bigtable.repackaged.io.opencensus.common.Timestamp censusTimestamp) {
        if (censusTimestamp.getSeconds() < 0L) {
            return Timestamp.newBuilder().build();
        }
        return Timestamp.newBuilder().setSeconds(censusTimestamp.getSeconds()).setNanos(censusTimestamp.getNanos()).build();
    }

    static MonitoredResource getDefaultResource() {
        Resource autoDetectedResource;
        MonitoredResource.Builder builder = MonitoredResource.newBuilder();
        if (MetadataConfig.getProjectId() != null) {
            builder.putLabels(STACKDRIVER_PROJECT_ID_KEY, MetadataConfig.getProjectId());
        }
        if ((autoDetectedResource = ResourceUtils.detectResource()) == null || autoDetectedResource.getType() == null) {
            builder.setType(GLOBAL);
            return builder.build();
        }
        StackdriverExportUtils.setResourceForBuilder(builder, autoDetectedResource);
        return builder.build();
    }

    @VisibleForTesting
    static void setResourceForBuilder(MonitoredResource.Builder builder, Resource autoDetectedResource) {
        String type = autoDetectedResource.getType();
        if (type == null) {
            return;
        }
        String sdType = GLOBAL;
        Map<String, String> mappings = null;
        if ("host".equals(type)) {
            String provider = autoDetectedResource.getLabels().get("cloud.provider");
            if ("gcp".equals(provider)) {
                sdType = GCP_GCE_INSTANCE;
                mappings = GCP_RESOURCE_MAPPING;
            } else if ("aws".equals(provider)) {
                sdType = AWS_EC2_INSTANCE;
                mappings = AWS_RESOURCE_MAPPING;
            }
        } else if ("container".equals(type)) {
            sdType = K8S_CONTAINER;
            mappings = K8S_RESOURCE_MAPPING;
        }
        builder.setType(sdType);
        if (GLOBAL.equals(sdType) || mappings == null) {
            return;
        }
        Map<String, String> resLabels = autoDetectedResource.getLabels();
        for (Map.Entry<String, String> entry : mappings.entrySet()) {
            if (entry.getValue() == null || !resLabels.containsKey(entry.getValue())) continue;
            String resourceLabelKey = entry.getKey();
            String resourceLabelValue = resLabels.get(entry.getValue());
            if (AWS_EC2_INSTANCE.equals(sdType) && "region".equals(resourceLabelKey)) {
                resourceLabelValue = AWS_REGION_VALUE_PREFIX + resourceLabelValue;
            }
            builder.putLabels(resourceLabelKey, resourceLabelValue);
        }
    }

    @VisibleForTesting
    static List<com.google.bigtable.repackaged.io.opencensus.metrics.export.Metric> convertSummaryMetric(com.google.bigtable.repackaged.io.opencensus.metrics.export.Metric summaryMetric) {
        ArrayList<com.google.bigtable.repackaged.io.opencensus.metrics.export.Metric> metricsList = Lists.newArrayList();
        final ArrayList<TimeSeries> percentileTimeSeries = new ArrayList<TimeSeries>();
        final ArrayList<TimeSeries> summaryCountTimeSeries = new ArrayList<TimeSeries>();
        final ArrayList<TimeSeries> summarySumTimeSeries = new ArrayList<TimeSeries>();
        for (final TimeSeries timeSeries : summaryMetric.getTimeSeriesList()) {
            final ArrayList<LabelValue> labelValuesWithPercentile = new ArrayList<LabelValue>(timeSeries.getLabelValues());
            final com.google.bigtable.repackaged.io.opencensus.common.Timestamp timeSeriesTimestamp = timeSeries.getStartTimestamp();
            for (Point point : timeSeries.getPoints()) {
                final com.google.bigtable.repackaged.io.opencensus.common.Timestamp pointTimestamp = point.getTimestamp();
                point.getValue().match(Functions.returnNull(), Functions.returnNull(), Functions.returnNull(), new Function<Summary, Void>(){

                    @Override
                    public Void apply(Summary summary) {
                        Double sum;
                        Long count = summary.getCount();
                        if (count != null) {
                            StackdriverExportUtils.createTimeSeries(timeSeries.getLabelValues(), Value.longValue(count), pointTimestamp, timeSeriesTimestamp, summaryCountTimeSeries);
                        }
                        if ((sum = summary.getSum()) != null) {
                            StackdriverExportUtils.createTimeSeries(timeSeries.getLabelValues(), Value.doubleValue(sum), pointTimestamp, timeSeriesTimestamp, summarySumTimeSeries);
                        }
                        Summary.Snapshot snapshot = summary.getSnapshot();
                        for (Summary.Snapshot.ValueAtPercentile valueAtPercentile : snapshot.getValueAtPercentiles()) {
                            labelValuesWithPercentile.add(LabelValue.create(valueAtPercentile.getPercentile() + ""));
                            StackdriverExportUtils.createTimeSeries(labelValuesWithPercentile, Value.doubleValue(valueAtPercentile.getValue()), pointTimestamp, null, percentileTimeSeries);
                            labelValuesWithPercentile.remove(labelValuesWithPercentile.size() - 1);
                        }
                        return null;
                    }
                }, Functions.returnNull());
            }
        }
        if (summaryCountTimeSeries.size() > 0) {
            StackdriverExportUtils.addMetric(metricsList, com.google.bigtable.repackaged.io.opencensus.metrics.export.MetricDescriptor.create(summaryMetric.getMetricDescriptor().getName() + SUMMARY_SUFFIX_COUNT, summaryMetric.getMetricDescriptor().getDescription(), "1", MetricDescriptor.Type.CUMULATIVE_INT64, summaryMetric.getMetricDescriptor().getLabelKeys()), summaryCountTimeSeries);
        }
        if (summarySumTimeSeries.size() > 0) {
            StackdriverExportUtils.addMetric(metricsList, com.google.bigtable.repackaged.io.opencensus.metrics.export.MetricDescriptor.create(summaryMetric.getMetricDescriptor().getName() + SUMMARY_SUFFIX_SUM, summaryMetric.getMetricDescriptor().getDescription(), summaryMetric.getMetricDescriptor().getUnit(), MetricDescriptor.Type.CUMULATIVE_DOUBLE, summaryMetric.getMetricDescriptor().getLabelKeys()), summarySumTimeSeries);
        }
        ArrayList<LabelKey> labelKeys = new ArrayList<LabelKey>(summaryMetric.getMetricDescriptor().getLabelKeys());
        labelKeys.add(PERCENTILE_LABEL_KEY);
        StackdriverExportUtils.addMetric(metricsList, com.google.bigtable.repackaged.io.opencensus.metrics.export.MetricDescriptor.create(summaryMetric.getMetricDescriptor().getName() + SNAPSHOT_SUFFIX_PERCENTILE, summaryMetric.getMetricDescriptor().getDescription(), summaryMetric.getMetricDescriptor().getUnit(), MetricDescriptor.Type.GAUGE_DOUBLE, labelKeys), percentileTimeSeries);
        return metricsList;
    }

    private static void addMetric(List<com.google.bigtable.repackaged.io.opencensus.metrics.export.Metric> metricsList, com.google.bigtable.repackaged.io.opencensus.metrics.export.MetricDescriptor metricDescriptor, List<TimeSeries> timeSeriesList) {
        metricsList.add(com.google.bigtable.repackaged.io.opencensus.metrics.export.Metric.create(metricDescriptor, timeSeriesList));
    }

    private static void createTimeSeries(List<LabelValue> labelValues, Value value, com.google.bigtable.repackaged.io.opencensus.common.Timestamp pointTimestamp, @Nullable com.google.bigtable.repackaged.io.opencensus.common.Timestamp timeSeriesTimestamp, List<TimeSeries> timeSeriesList) {
        timeSeriesList.add(TimeSeries.createWithOnePoint(labelValues, Point.create(value, pointTimestamp), timeSeriesTimestamp));
    }

    private static Map<String, String> getGcpResourceLabelsMappings() {
        LinkedHashMap<String, String> resourceLabels = new LinkedHashMap<String, String>();
        resourceLabels.put(STACKDRIVER_PROJECT_ID_KEY, STACKDRIVER_PROJECT_ID_KEY);
        resourceLabels.put("instance_id", "host.id");
        resourceLabels.put("zone", "cloud.zone");
        return Collections.unmodifiableMap(resourceLabels);
    }

    private static Map<String, String> getK8sResourceLabelsMappings() {
        LinkedHashMap<String, String> resourceLabels = new LinkedHashMap<String, String>();
        resourceLabels.put(STACKDRIVER_PROJECT_ID_KEY, STACKDRIVER_PROJECT_ID_KEY);
        resourceLabels.put("location", "cloud.zone");
        resourceLabels.put("cluster_name", "k8s.cluster.name");
        resourceLabels.put("namespace_name", "k8s.namespace.name");
        resourceLabels.put("pod_name", "k8s.pod.name");
        resourceLabels.put("container_name", "container.name");
        return Collections.unmodifiableMap(resourceLabels);
    }

    private static Map<String, String> getAwsResourceLabelsMappings() {
        LinkedHashMap<String, String> resourceLabels = new LinkedHashMap<String, String>();
        resourceLabels.put(STACKDRIVER_PROJECT_ID_KEY, STACKDRIVER_PROJECT_ID_KEY);
        resourceLabels.put("instance_id", "host.id");
        resourceLabels.put("region", "cloud.region");
        resourceLabels.put("aws_account", "cloud.account.id");
        return Collections.unmodifiableMap(resourceLabels);
    }

    private StackdriverExportUtils() {
    }

    static String exceptionMessage(Throwable e) {
        return e.getMessage() != null ? e.getMessage() : e.getClass().getName();
    }

    static String getDomain(@Nullable String metricNamePrefix) {
        String domain = Strings.isNullOrEmpty(metricNamePrefix) ? CUSTOM_OPENCENSUS_DOMAIN : (!metricNamePrefix.endsWith("/") ? metricNamePrefix + '/' : metricNamePrefix);
        return domain;
    }

    static String getDisplayNamePrefix(@Nullable String metricNamePrefix) {
        if (metricNamePrefix == null) {
            return DEFAULT_DISPLAY_NAME_PREFIX;
        }
        if (!metricNamePrefix.endsWith("/") && !metricNamePrefix.isEmpty()) {
            metricNamePrefix = metricNamePrefix + '/';
        }
        return metricNamePrefix;
    }
}

