/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.opencensus.exporter.trace.stackdriver;

import com.google.bigtable.repackaged.com.google.auth.Credentials;
import com.google.bigtable.repackaged.com.google.cloud.ServiceOptions;
import com.google.bigtable.repackaged.com.google.cloud.trace.v2.stub.TraceServiceStub;
import com.google.bigtable.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.common.base.Strings;
import com.google.bigtable.repackaged.io.opencensus.common.Duration;
import com.google.bigtable.repackaged.io.opencensus.exporter.trace.stackdriver.AutoValue_StackdriverTraceConfiguration;
import com.google.bigtable.repackaged.io.opencensus.trace.AttributeValue;
import com.google.bigtable.repackaged.javax.annotation.Nullable;
import com.google.bigtable.repackaged.javax.annotation.concurrent.Immutable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

@Immutable
public abstract class StackdriverTraceConfiguration {
    private static final String DEFAULT_PROJECT_ID = Strings.nullToEmpty(ServiceOptions.getDefaultProjectId());
    @VisibleForTesting
    static final Duration DEFAULT_DEADLINE = Duration.create(10L, 0);

    StackdriverTraceConfiguration() {
    }

    @Nullable
    public abstract Credentials getCredentials();

    public abstract String getProjectId();

    @Nullable
    public abstract TraceServiceStub getTraceServiceStub();

    public abstract Map<String, AttributeValue> getFixedAttributes();

    public abstract Duration getDeadline();

    public static Builder builder() {
        return new AutoValue_StackdriverTraceConfiguration.Builder().setProjectId(DEFAULT_PROJECT_ID).setFixedAttributes(Collections.emptyMap()).setDeadline(DEFAULT_DEADLINE);
    }

    public static abstract class Builder {
        @VisibleForTesting
        static final Duration ZERO = Duration.fromMillis(0L);

        Builder() {
        }

        public abstract Builder setCredentials(Credentials var1);

        public abstract Builder setProjectId(String var1);

        public abstract Builder setTraceServiceStub(TraceServiceStub var1);

        public abstract Builder setFixedAttributes(Map<String, AttributeValue> var1);

        public abstract Builder setDeadline(Duration var1);

        abstract String getProjectId();

        abstract Map<String, AttributeValue> getFixedAttributes();

        abstract Duration getDeadline();

        abstract StackdriverTraceConfiguration autoBuild();

        public StackdriverTraceConfiguration build() {
            this.setFixedAttributes(Collections.unmodifiableMap(new LinkedHashMap<String, AttributeValue>(this.getFixedAttributes())));
            Preconditions.checkArgument(!Strings.isNullOrEmpty(this.getProjectId()), "Cannot find a project ID from either configurations or application default.");
            for (Map.Entry<String, AttributeValue> fixedAttribute : this.getFixedAttributes().entrySet()) {
                Preconditions.checkNotNull(fixedAttribute.getKey(), "attribute key");
                Preconditions.checkNotNull(fixedAttribute.getValue(), "attribute value");
            }
            Preconditions.checkArgument(this.getDeadline().compareTo(ZERO) > 0, "Deadline must be positive.");
            return this.autoBuild();
        }
    }
}

