/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.opencensus.metrics;

import com.google.bigtable.repackaged.io.opencensus.internal.Provider;
import com.google.bigtable.repackaged.io.opencensus.metrics.MetricRegistry;
import com.google.bigtable.repackaged.io.opencensus.metrics.MetricsComponent;
import com.google.bigtable.repackaged.io.opencensus.metrics.export.ExportComponent;
import com.google.bigtable.repackaged.javax.annotation.Nullable;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Metrics {
    private static final Logger logger = Logger.getLogger(Metrics.class.getName());
    private static final MetricsComponent metricsComponent = Metrics.loadMetricsComponent(MetricsComponent.class.getClassLoader());

    public static ExportComponent getExportComponent() {
        return metricsComponent.getExportComponent();
    }

    public static MetricRegistry getMetricRegistry() {
        return metricsComponent.getMetricRegistry();
    }

    static MetricsComponent loadMetricsComponent(@Nullable ClassLoader classLoader) {
        try {
            return Provider.createInstance(Class.forName("com.google.bigtable.repackaged.io.opencensus.impl.metrics.MetricsComponentImpl", true, classLoader), MetricsComponent.class);
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.FINE, "Couldn't load full implementation for MetricsComponent, now trying to load lite implementation.", e);
            try {
                return Provider.createInstance(Class.forName("com.google.bigtable.repackaged.io.opencensus.impllite.metrics.MetricsComponentImplLite", true, classLoader), MetricsComponent.class);
            }
            catch (ClassNotFoundException e2) {
                logger.log(Level.FINE, "Couldn't load lite implementation for MetricsComponent, now using default implementation for MetricsComponent.", e2);
                return MetricsComponent.newNoopMetricsComponent();
            }
        }
    }

    private Metrics() {
    }
}

