/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.opencensus.stats;

import com.google.bigtable.repackaged.io.opencensus.common.Function;
import com.google.bigtable.repackaged.io.opencensus.internal.StringUtils;
import com.google.bigtable.repackaged.io.opencensus.internal.Utils;
import com.google.bigtable.repackaged.io.opencensus.stats.AutoValue_Measure_MeasureDouble;
import com.google.bigtable.repackaged.io.opencensus.stats.AutoValue_Measure_MeasureLong;
import com.google.bigtable.repackaged.javax.annotation.concurrent.Immutable;

@Immutable
public abstract class Measure {
    static final int NAME_MAX_LENGTH = 255;
    private static final String ERROR_MESSAGE_INVALID_NAME = "Name should be a ASCII string with a length no greater than 255 characters.";

    public abstract <T> T match(Function<? super MeasureDouble, T> var1, Function<? super MeasureLong, T> var2, Function<? super Measure, T> var3);

    public abstract String getName();

    public abstract String getDescription();

    public abstract String getUnit();

    private Measure() {
    }

    @Immutable
    public static abstract class MeasureLong
    extends Measure {
        MeasureLong() {
        }

        public static MeasureLong create(String name, String description, String unit) {
            Utils.checkArgument(StringUtils.isPrintableString(name) && name.length() <= 255, Measure.ERROR_MESSAGE_INVALID_NAME);
            return new AutoValue_Measure_MeasureLong(name, description, unit);
        }

        @Override
        public <T> T match(Function<? super MeasureDouble, T> p0, Function<? super MeasureLong, T> p1, Function<? super Measure, T> defaultFunction) {
            return p1.apply(this);
        }

        @Override
        public abstract String getName();

        @Override
        public abstract String getDescription();

        @Override
        public abstract String getUnit();
    }

    @Immutable
    public static abstract class MeasureDouble
    extends Measure {
        MeasureDouble() {
        }

        public static MeasureDouble create(String name, String description, String unit) {
            Utils.checkArgument(StringUtils.isPrintableString(name) && name.length() <= 255, Measure.ERROR_MESSAGE_INVALID_NAME);
            return new AutoValue_Measure_MeasureDouble(name, description, unit);
        }

        @Override
        public <T> T match(Function<? super MeasureDouble, T> p0, Function<? super MeasureLong, T> p1, Function<? super Measure, T> defaultFunction) {
            return p0.apply(this);
        }

        @Override
        public abstract String getName();

        @Override
        public abstract String getDescription();

        @Override
        public abstract String getUnit();
    }
}

