/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.metrics;

import com.google.bigtable.repackaged.com.google.api.core.ApiFuture;
import com.google.bigtable.repackaged.com.google.api.core.ApiFutureCallback;
import com.google.bigtable.repackaged.com.google.api.core.ApiFutures;
import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.api.gax.grpc.GrpcResponseMetadata;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.ApiCallContext;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.UnaryCallable;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.metrics.BigtableTracer;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.metrics.Util;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.MoreExecutors;
import javax.annotation.Nonnull;

@InternalApi
public class BigtableTracerUnaryCallable<RequestT, ResponseT>
extends UnaryCallable<RequestT, ResponseT> {
    private final UnaryCallable<RequestT, ResponseT> innerCallable;

    public BigtableTracerUnaryCallable(@Nonnull UnaryCallable<RequestT, ResponseT> innerCallable) {
        this.innerCallable = Preconditions.checkNotNull(innerCallable, "Inner callable must be set");
    }

    @Override
    public ApiFuture<ResponseT> futureCall(RequestT request, ApiCallContext context) {
        if (context.getTracer() instanceof BigtableTracer) {
            GrpcResponseMetadata responseMetadata = new GrpcResponseMetadata();
            BigtableTracerUnaryCallback callback = new BigtableTracerUnaryCallback((BigtableTracer)context.getTracer(), responseMetadata);
            ApiFuture<ResponseT> future = this.innerCallable.futureCall(request, Util.injectBigtableStreamTracer(context, responseMetadata, (BigtableTracer)context.getTracer()));
            ApiFutures.addCallback(future, callback, MoreExecutors.directExecutor());
            return future;
        }
        return this.innerCallable.futureCall(request, context);
    }

    class BigtableTracerUnaryCallback<ResponseT>
    implements ApiFutureCallback<ResponseT> {
        private final BigtableTracer tracer;
        private final GrpcResponseMetadata responseMetadata;

        BigtableTracerUnaryCallback(BigtableTracer tracer, GrpcResponseMetadata responseMetadata) {
            this.tracer = tracer;
            this.responseMetadata = responseMetadata;
        }

        @Override
        public void onFailure(Throwable throwable) {
            Util.recordMetricsFromMetadata(this.responseMetadata, this.tracer, throwable);
        }

        @Override
        public void onSuccess(ResponseT response) {
            Util.recordMetricsFromMetadata(this.responseMetadata, this.tracer, null);
        }
    }
}

