/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.metrics;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.api.gax.grpc.GrpcResponseMetadata;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.ApiCallContext;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.ResponseObserver;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.StreamController;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.SafeResponseObserver;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.metrics.BigtableTracer;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.metrics.Util;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.common.base.Stopwatch;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

@InternalApi
public class BigtableTracerStreamingCallable<RequestT, ResponseT>
extends ServerStreamingCallable<RequestT, ResponseT> {
    private final ServerStreamingCallable<RequestT, ResponseT> innerCallable;

    public BigtableTracerStreamingCallable(@Nonnull ServerStreamingCallable<RequestT, ResponseT> callable) {
        this.innerCallable = Preconditions.checkNotNull(callable, "Inner callable must be set");
    }

    @Override
    public void call(RequestT request, ResponseObserver<ResponseT> responseObserver, ApiCallContext context) {
        GrpcResponseMetadata responseMetadata = new GrpcResponseMetadata();
        if (context.getTracer() instanceof BigtableTracer) {
            BigtableTracerResponseObserver<ResponseT> innerObserver = new BigtableTracerResponseObserver<ResponseT>(responseObserver, (BigtableTracer)context.getTracer(), responseMetadata);
            this.innerCallable.call(request, innerObserver, Util.injectBigtableStreamTracer(context, responseMetadata, (BigtableTracer)context.getTracer()));
        } else {
            this.innerCallable.call(request, responseObserver, context);
        }
    }

    private class BigtableTracerResponseObserver<ResponseT>
    extends SafeResponseObserver<ResponseT> {
        private final BigtableTracer tracer;
        private final ResponseObserver<ResponseT> outerObserver;
        private final GrpcResponseMetadata responseMetadata;

        BigtableTracerResponseObserver(ResponseObserver<ResponseT> observer, BigtableTracer tracer, GrpcResponseMetadata metadata) {
            super(observer);
            this.tracer = tracer;
            this.outerObserver = observer;
            this.responseMetadata = metadata;
        }

        @Override
        protected void onStartImpl(StreamController controller) {
            TracedStreamController tracedController = new TracedStreamController(controller, this.tracer);
            this.outerObserver.onStart(tracedController);
        }

        @Override
        protected void onResponseImpl(ResponseT response) {
            Stopwatch stopwatch = Stopwatch.createStarted();
            this.outerObserver.onResponse(response);
            this.tracer.afterResponse(stopwatch.elapsed(TimeUnit.MILLISECONDS));
        }

        @Override
        protected void onErrorImpl(Throwable t) {
            Util.recordMetricsFromMetadata(this.responseMetadata, this.tracer, t);
            this.outerObserver.onError(t);
        }

        @Override
        protected void onCompleteImpl() {
            Util.recordMetricsFromMetadata(this.responseMetadata, this.tracer, null);
            this.outerObserver.onComplete();
        }
    }

    private class TracedStreamController
    implements StreamController {
        private final StreamController innerController;
        private final BigtableTracer tracer;

        TracedStreamController(StreamController innerController, BigtableTracer tracer) {
            this.innerController = innerController;
            this.tracer = tracer;
        }

        @Override
        public void cancel() {
            this.innerController.cancel();
        }

        @Override
        public void disableAutoInboundFlowControl() {
            this.tracer.disableFlowControl();
            this.innerController.disableAutoInboundFlowControl();
        }

        @Override
        public void request(int i) {
            this.tracer.onRequest(i);
            this.innerController.request(i);
        }
    }
}

