/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc.alts;

import com.google.bigtable.repackaged.io.grpc.ServerCall;
import com.google.bigtable.repackaged.io.grpc.Status;
import com.google.bigtable.repackaged.io.grpc.alts.internal.AltsInternalContext;
import com.google.bigtable.repackaged.io.grpc.alts.internal.AltsProtocolNegotiator;
import java.util.Collection;

public final class AuthorizationUtil {
    private AuthorizationUtil() {
    }

    public static Status clientAuthorizationCheck(ServerCall<?, ?> call, Collection<String> expectedServiceAccounts) {
        AltsInternalContext altsContext = (AltsInternalContext)call.getAttributes().get(AltsProtocolNegotiator.AUTH_CONTEXT_KEY);
        if (altsContext == null) {
            return Status.PERMISSION_DENIED.withDescription("Peer ALTS AuthContext not found");
        }
        if (expectedServiceAccounts.contains(altsContext.getPeerServiceAccount())) {
            return Status.OK;
        }
        return Status.PERMISSION_DENIED.withDescription("Client " + altsContext.getPeerServiceAccount() + " is not authorized");
    }
}

