/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc.protobuf.services;

import com.google.bigtable.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.bigtable.repackaged.com.google.common.base.MoreObjects;
import com.google.bigtable.repackaged.com.google.common.base.Objects;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.common.base.Stopwatch;
import com.google.bigtable.repackaged.com.google.common.base.Supplier;
import com.google.bigtable.repackaged.io.grpc.CallOptions;
import com.google.bigtable.repackaged.io.grpc.ChannelLogger;
import com.google.bigtable.repackaged.io.grpc.ClientCall;
import com.google.bigtable.repackaged.io.grpc.ConnectivityState;
import com.google.bigtable.repackaged.io.grpc.ConnectivityStateInfo;
import com.google.bigtable.repackaged.io.grpc.LoadBalancer;
import com.google.bigtable.repackaged.io.grpc.Metadata;
import com.google.bigtable.repackaged.io.grpc.Status;
import com.google.bigtable.repackaged.io.grpc.SynchronizationContext;
import com.google.bigtable.repackaged.io.grpc.health.v1.HealthCheckRequest;
import com.google.bigtable.repackaged.io.grpc.health.v1.HealthCheckResponse;
import com.google.bigtable.repackaged.io.grpc.health.v1.HealthGrpc;
import com.google.bigtable.repackaged.io.grpc.internal.BackoffPolicy;
import com.google.bigtable.repackaged.io.grpc.internal.ServiceConfigUtil;
import com.google.bigtable.repackaged.io.grpc.util.ForwardingLoadBalancer;
import com.google.bigtable.repackaged.io.grpc.util.ForwardingLoadBalancerHelper;
import com.google.bigtable.repackaged.io.grpc.util.ForwardingSubchannel;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

final class HealthCheckingLoadBalancerFactory
extends LoadBalancer.Factory {
    private static final Logger logger = Logger.getLogger(HealthCheckingLoadBalancerFactory.class.getName());
    private final LoadBalancer.Factory delegateFactory;
    private final BackoffPolicy.Provider backoffPolicyProvider;
    private final Supplier<Stopwatch> stopwatchSupplier;

    public HealthCheckingLoadBalancerFactory(LoadBalancer.Factory delegateFactory, BackoffPolicy.Provider backoffPolicyProvider, Supplier<Stopwatch> stopwatchSupplier) {
        this.delegateFactory = Preconditions.checkNotNull(delegateFactory, "delegateFactory");
        this.backoffPolicyProvider = Preconditions.checkNotNull(backoffPolicyProvider, "backoffPolicyProvider");
        this.stopwatchSupplier = Preconditions.checkNotNull(stopwatchSupplier, "stopwatchSupplier");
    }

    @Override
    public LoadBalancer newLoadBalancer(LoadBalancer.Helper helper) {
        HelperImpl wrappedHelper = new HelperImpl(helper);
        LoadBalancer delegateBalancer = this.delegateFactory.newLoadBalancer(wrappedHelper);
        return new HealthCheckingLoadBalancer(wrappedHelper, delegateBalancer);
    }

    private final class HealthCheckState
    implements LoadBalancer.SubchannelStateListener {
        private final Runnable retryTask = new Runnable(){

            @Override
            public void run() {
                HealthCheckState.this.startRpc();
            }
        };
        private final SynchronizationContext syncContext;
        private final ScheduledExecutorService timerService;
        private final HelperImpl helperImpl;
        private final LoadBalancer.Subchannel subchannel;
        private final ChannelLogger subchannelLogger;
        private LoadBalancer.SubchannelStateListener stateListener;
        @Nullable
        private HcStream activeRpc;
        private String serviceName;
        private BackoffPolicy backoffPolicy;
        private ConnectivityStateInfo rawState = ConnectivityStateInfo.forNonError(ConnectivityState.IDLE);
        private ConnectivityStateInfo concludedState = ConnectivityStateInfo.forNonError(ConnectivityState.IDLE);
        private boolean running;
        private boolean disabled;
        private SynchronizationContext.ScheduledHandle retryTimer;

        HealthCheckState(HelperImpl helperImpl, LoadBalancer.Subchannel subchannel, SynchronizationContext syncContext, ScheduledExecutorService timerService) {
            this.helperImpl = Preconditions.checkNotNull(helperImpl, "helperImpl");
            this.subchannel = Preconditions.checkNotNull(subchannel, "subchannel");
            this.subchannelLogger = Preconditions.checkNotNull(subchannel.getChannelLogger(), "subchannelLogger");
            this.syncContext = Preconditions.checkNotNull(syncContext, "syncContext");
            this.timerService = Preconditions.checkNotNull(timerService, "timerService");
        }

        void init(LoadBalancer.SubchannelStateListener listener) {
            Preconditions.checkState(this.stateListener == null, "init() already called");
            this.stateListener = Preconditions.checkNotNull(listener, "listener");
        }

        void setServiceName(@Nullable String newServiceName) {
            if (Objects.equal(newServiceName, this.serviceName)) {
                return;
            }
            this.serviceName = newServiceName;
            String cancelMsg = this.serviceName == null ? "Health check disabled by service config" : "Switching to new service name: " + newServiceName;
            this.stopRpc(cancelMsg);
            this.adjustHealthCheck();
        }

        @Override
        public void onSubchannelState(ConnectivityStateInfo rawState) {
            if (Objects.equal((Object)this.rawState.getState(), (Object)ConnectivityState.READY) && !Objects.equal((Object)rawState.getState(), (Object)ConnectivityState.READY)) {
                this.disabled = false;
            }
            if (Objects.equal((Object)rawState.getState(), (Object)ConnectivityState.SHUTDOWN)) {
                this.helperImpl.hcStates.remove(this);
            }
            this.rawState = rawState;
            this.adjustHealthCheck();
        }

        private boolean isRetryTimerPending() {
            return this.retryTimer != null && this.retryTimer.isPending();
        }

        private void adjustHealthCheck() {
            if (!this.disabled && this.serviceName != null && Objects.equal((Object)this.rawState.getState(), (Object)ConnectivityState.READY)) {
                this.running = true;
                if (this.activeRpc == null && !this.isRetryTimerPending()) {
                    this.startRpc();
                }
            } else {
                this.running = false;
                this.stopRpc("Client stops health check");
                this.backoffPolicy = null;
                this.gotoState(this.rawState);
            }
        }

        private void startRpc() {
            Preconditions.checkState(this.serviceName != null, "serviceName is null");
            Preconditions.checkState(this.activeRpc == null, "previous health-checking RPC has not been cleaned up");
            Preconditions.checkState(this.subchannel != null, "init() not called");
            if (!Objects.equal((Object)this.concludedState.getState(), (Object)ConnectivityState.READY)) {
                this.subchannelLogger.log(ChannelLogger.ChannelLogLevel.INFO, "CONNECTING: Starting health-check for \"{0}\"", this.serviceName);
                this.gotoState(ConnectivityStateInfo.forNonError(ConnectivityState.CONNECTING));
            }
            this.activeRpc = new HcStream();
            this.activeRpc.start();
        }

        private void stopRpc(String msg) {
            if (this.activeRpc != null) {
                this.activeRpc.cancel(msg);
                this.activeRpc = null;
            }
            if (this.retryTimer != null) {
                this.retryTimer.cancel();
                this.retryTimer = null;
            }
        }

        private void gotoState(ConnectivityStateInfo newState) {
            Preconditions.checkState(this.subchannel != null, "init() not called");
            if (!Objects.equal(this.concludedState, newState)) {
                this.concludedState = newState;
                this.stateListener.onSubchannelState(this.concludedState);
            }
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("running", this.running).add("disabled", this.disabled).add("activeRpc", this.activeRpc).add("serviceName", this.serviceName).add("rawState", this.rawState).add("concludedState", this.concludedState).toString();
        }

        private class HcStream
        extends ClientCall.Listener<HealthCheckResponse> {
            private final ClientCall<HealthCheckRequest, HealthCheckResponse> call;
            private final String callServiceName;
            private final Stopwatch stopwatch;
            private boolean callHasResponded;

            HcStream() {
                this.stopwatch = ((Stopwatch)HealthCheckingLoadBalancerFactory.this.stopwatchSupplier.get()).start();
                this.callServiceName = HealthCheckState.this.serviceName;
                this.call = HealthCheckState.this.subchannel.asChannel().newCall(HealthGrpc.getWatchMethod(), CallOptions.DEFAULT);
            }

            void start() {
                this.call.start(this, new Metadata());
                this.call.sendMessage(HealthCheckRequest.newBuilder().setService(HealthCheckState.this.serviceName).build());
                this.call.halfClose();
                this.call.request(1);
            }

            void cancel(String msg) {
                this.call.cancel(msg, null);
            }

            @Override
            public void onMessage(final HealthCheckResponse response) {
                HealthCheckState.this.syncContext.execute(new Runnable(){

                    @Override
                    public void run() {
                        if (HealthCheckState.this.activeRpc == HcStream.this) {
                            HcStream.this.handleResponse(response);
                        }
                    }
                });
            }

            @Override
            public void onClose(final Status status, Metadata trailers) {
                HealthCheckState.this.syncContext.execute(new Runnable(){

                    @Override
                    public void run() {
                        if (HealthCheckState.this.activeRpc == HcStream.this) {
                            HealthCheckState.this.activeRpc = null;
                            HcStream.this.handleStreamClosed(status);
                        }
                    }
                });
            }

            void handleResponse(HealthCheckResponse response) {
                this.callHasResponded = true;
                HealthCheckState.this.backoffPolicy = null;
                HealthCheckResponse.ServingStatus status = response.getStatus();
                if (Objects.equal(status, HealthCheckResponse.ServingStatus.SERVING)) {
                    HealthCheckState.this.subchannelLogger.log(ChannelLogger.ChannelLogLevel.INFO, "READY: health-check responded SERVING");
                    HealthCheckState.this.gotoState(ConnectivityStateInfo.forNonError(ConnectivityState.READY));
                } else {
                    HealthCheckState.this.subchannelLogger.log(ChannelLogger.ChannelLogLevel.INFO, "TRANSIENT_FAILURE: health-check responded {0}", status);
                    HealthCheckState.this.gotoState(ConnectivityStateInfo.forTransientFailure(Status.UNAVAILABLE.withDescription("Health-check service responded " + status + " for '" + this.callServiceName + "'")));
                }
                this.call.request(1);
            }

            void handleStreamClosed(Status status) {
                if (Objects.equal((Object)status.getCode(), (Object)Status.Code.UNIMPLEMENTED)) {
                    HealthCheckState.this.disabled = true;
                    logger.log(Level.SEVERE, "Health-check with {0} is disabled. Server returned: {1}", new Object[]{HealthCheckState.this.subchannel.getAllAddresses(), status});
                    HealthCheckState.this.subchannelLogger.log(ChannelLogger.ChannelLogLevel.ERROR, "Health-check disabled: {0}", status);
                    HealthCheckState.this.subchannelLogger.log(ChannelLogger.ChannelLogLevel.INFO, "{0} (no health-check)", HealthCheckState.this.rawState);
                    HealthCheckState.this.gotoState(HealthCheckState.this.rawState);
                    return;
                }
                long delayNanos = 0L;
                HealthCheckState.this.subchannelLogger.log(ChannelLogger.ChannelLogLevel.INFO, "TRANSIENT_FAILURE: health-check stream closed with {0}", status);
                HealthCheckState.this.gotoState(ConnectivityStateInfo.forTransientFailure(Status.UNAVAILABLE.withDescription("Health-check stream unexpectedly closed with " + status + " for '" + this.callServiceName + "'")));
                if (!this.callHasResponded) {
                    if (HealthCheckState.this.backoffPolicy == null) {
                        HealthCheckState.this.backoffPolicy = HealthCheckingLoadBalancerFactory.this.backoffPolicyProvider.get();
                    }
                    delayNanos = HealthCheckState.this.backoffPolicy.nextBackoffNanos() - this.stopwatch.elapsed(TimeUnit.NANOSECONDS);
                }
                if (delayNanos <= 0L) {
                    HealthCheckState.this.startRpc();
                } else {
                    Preconditions.checkState(!HealthCheckState.this.isRetryTimerPending(), "Retry double scheduled");
                    HealthCheckState.this.subchannelLogger.log(ChannelLogger.ChannelLogLevel.DEBUG, "Will retry health-check after {0} ns", delayNanos);
                    HealthCheckState.this.retryTimer = HealthCheckState.this.syncContext.schedule(HealthCheckState.this.retryTask, delayNanos, TimeUnit.NANOSECONDS, HealthCheckState.this.timerService);
                }
            }

            public String toString() {
                return MoreObjects.toStringHelper(this).add("callStarted", this.call != null).add("serviceName", this.callServiceName).add("hasResponded", this.callHasResponded).toString();
            }
        }
    }

    private static final class HealthCheckingLoadBalancer
    extends ForwardingLoadBalancer {
        final LoadBalancer delegate;
        final HelperImpl helper;

        HealthCheckingLoadBalancer(HelperImpl helper, LoadBalancer delegate) {
            this.helper = Preconditions.checkNotNull(helper, "helper");
            this.delegate = Preconditions.checkNotNull(delegate, "delegate");
        }

        @Override
        protected LoadBalancer delegate() {
            return this.delegate;
        }

        @Override
        public void handleResolvedAddresses(LoadBalancer.ResolvedAddresses resolvedAddresses) {
            Map<String, ?> healthCheckingConfig = resolvedAddresses.getAttributes().get(LoadBalancer.ATTR_HEALTH_CHECKING_CONFIG);
            String serviceName = ServiceConfigUtil.getHealthCheckedServiceName(healthCheckingConfig);
            this.helper.setHealthCheckedService(serviceName);
            super.handleResolvedAddresses(resolvedAddresses);
        }

        @Override
        public String toString() {
            return MoreObjects.toStringHelper(this).add("delegate", this.delegate()).toString();
        }
    }

    @VisibleForTesting
    static final class SubchannelImpl
    extends ForwardingSubchannel {
        final LoadBalancer.Subchannel delegate;
        final HealthCheckState hcState;

        SubchannelImpl(LoadBalancer.Subchannel delegate, HealthCheckState hcState) {
            this.delegate = Preconditions.checkNotNull(delegate, "delegate");
            this.hcState = Preconditions.checkNotNull(hcState, "hcState");
        }

        @Override
        protected LoadBalancer.Subchannel delegate() {
            return this.delegate;
        }

        @Override
        public void start(LoadBalancer.SubchannelStateListener listener) {
            this.hcState.init(listener);
            this.delegate().start(this.hcState);
        }
    }

    private final class HelperImpl
    extends ForwardingLoadBalancerHelper {
        private final LoadBalancer.Helper delegate;
        private final SynchronizationContext syncContext;
        @Nullable
        String healthCheckedService;
        final HashSet<HealthCheckState> hcStates = new HashSet();

        HelperImpl(LoadBalancer.Helper delegate) {
            this.delegate = Preconditions.checkNotNull(delegate, "delegate");
            this.syncContext = Preconditions.checkNotNull(delegate.getSynchronizationContext(), "syncContext");
        }

        @Override
        protected LoadBalancer.Helper delegate() {
            return this.delegate;
        }

        @Override
        public LoadBalancer.Subchannel createSubchannel(LoadBalancer.CreateSubchannelArgs args) {
            this.syncContext.throwIfNotInThisSynchronizationContext();
            LoadBalancer.Subchannel originalSubchannel = super.createSubchannel(args);
            HealthCheckState hcState = new HealthCheckState(this, originalSubchannel, this.syncContext, this.delegate.getScheduledExecutorService());
            this.hcStates.add(hcState);
            SubchannelImpl subchannel = new SubchannelImpl(originalSubchannel, hcState);
            if (this.healthCheckedService != null) {
                hcState.setServiceName(this.healthCheckedService);
            }
            return subchannel;
        }

        void setHealthCheckedService(@Nullable String service) {
            this.healthCheckedService = service;
            for (HealthCheckState hcState : this.hcStates) {
                hcState.setServiceName(service);
            }
        }

        @Override
        public String toString() {
            return MoreObjects.toStringHelper(this).add("delegate", this.delegate()).toString();
        }
    }
}

