/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.opencensus.exporter.metrics.ocagent;

import com.google.bigtable.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.io.opencensus.common.Duration;
import com.google.bigtable.repackaged.io.opencensus.exporter.metrics.ocagent.AutoValue_OcAgentMetricsExporterConfiguration;
import io.netty.handler.ssl.SslContext;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public abstract class OcAgentMetricsExporterConfiguration {
    @VisibleForTesting
    static final String DEFAULT_END_POINT = "localhost:55678";
    @VisibleForTesting
    static final String DEFAULT_SERVICE_NAME = "OpenCensus";
    @VisibleForTesting
    static final Duration DEFAULT_RETRY_INTERVAL = Duration.create(300L, 0);
    @VisibleForTesting
    static final Duration DEFAULT_EXPORT_INTERVAL = Duration.create(60L, 0);
    @VisibleForTesting
    static final Duration ZERO = Duration.create(0L, 0);

    OcAgentMetricsExporterConfiguration() {
    }

    public abstract String getEndPoint();

    public abstract Boolean getUseInsecure();

    @Nullable
    public abstract SslContext getSslContext();

    public abstract String getServiceName();

    public abstract Duration getRetryInterval();

    public abstract Duration getExportInterval();

    public static Builder builder() {
        return new AutoValue_OcAgentMetricsExporterConfiguration.Builder().setEndPoint(DEFAULT_END_POINT).setServiceName(DEFAULT_SERVICE_NAME).setRetryInterval(DEFAULT_RETRY_INTERVAL).setExportInterval(DEFAULT_EXPORT_INTERVAL).setUseInsecure(true);
    }

    public static abstract class Builder {
        Builder() {
        }

        public abstract Builder setEndPoint(String var1);

        public abstract Builder setUseInsecure(Boolean var1);

        public abstract Builder setSslContext(SslContext var1);

        public abstract Builder setServiceName(String var1);

        public abstract Builder setRetryInterval(Duration var1);

        public abstract Builder setExportInterval(Duration var1);

        abstract Duration getRetryInterval();

        abstract Duration getExportInterval();

        abstract OcAgentMetricsExporterConfiguration autoBuild();

        public OcAgentMetricsExporterConfiguration build() {
            Preconditions.checkArgument(this.getRetryInterval().compareTo(ZERO) > 0, "Retry interval must be positive.");
            Preconditions.checkArgument(this.getExportInterval().compareTo(ZERO) > 0, "Export interval must be positive.");
            return this.autoBuild();
        }
    }
}

