/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.adapters.filters;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.Filters;
import com.google.bigtable.repackaged.com.google.protobuf.ByteString;
import com.google.cloud.bigtable.hbase.adapters.filters.FilterAdapterContext;
import com.google.cloud.bigtable.hbase.adapters.filters.FilterSupportStatus;
import com.google.cloud.bigtable.hbase.adapters.filters.TypedFilterAdapterBase;
import java.io.IOException;
import org.apache.hadoop.hbase.filter.ColumnPaginationFilter;
import org.apache.hadoop.hbase.util.Bytes;

@InternalApi(value="For internal usage only")
public class ColumnPaginationFilterAdapter
extends TypedFilterAdapterBase<ColumnPaginationFilter> {
    private static final FilterSupportStatus UNSUPPORTED_STATUS = FilterSupportStatus.newNotSupported("ColumnPaginationFilter requires specifying a single column family for the Scan when specifying a qualifier as the column offset.");

    @Override
    public Filters.Filter adapt(FilterAdapterContext context, ColumnPaginationFilter filter) throws IOException {
        if (filter.getColumnOffset() != null) {
            byte[] family = context.getScan().getFamilies()[0];
            ByteString startQualifier = ByteString.copyFrom(filter.getColumnOffset());
            return this.createChain(filter, (Filters.Filter)((Object)Filters.FILTERS.qualifier().rangeWithinFamily(Bytes.toString((byte[])family)).startClosed(startQualifier)));
        }
        if (filter.getOffset() > 0) {
            return this.createChain(filter, Filters.FILTERS.offset().cellsPerRow(filter.getOffset()));
        }
        return this.createChain(filter, null);
    }

    private Filters.Filter createChain(ColumnPaginationFilter filter, Filters.Filter intermediate) {
        Filters.ChainFilter chain = Filters.FILTERS.chain();
        chain.filter(Filters.FILTERS.limit().cellsPerColumn(1));
        if (intermediate != null) {
            chain.filter(intermediate);
        }
        chain.filter(Filters.FILTERS.limit().cellsPerRow(filter.getLimit()));
        return chain;
    }

    @Override
    public FilterSupportStatus isFilterSupported(FilterAdapterContext context, ColumnPaginationFilter filter) {
        int familyCount = context.getScan().numFamilies();
        if (filter.getColumnOffset() != null && familyCount != 1) {
            return UNSUPPORTED_STATUS;
        }
        return FilterSupportStatus.SUPPORTED;
    }
}

