/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.auth.oauth2;

import com.google.bigtable.repackaged.com.google.api.client.http.HttpResponseException;
import com.google.bigtable.repackaged.com.google.auth.Retryable;
import com.google.bigtable.repackaged.com.google.auth.oauth2.OAuth2Utils;
import java.io.IOException;

class GoogleAuthException
extends IOException
implements Retryable {
    private final boolean isRetryable;
    private final int retryCount;

    GoogleAuthException(boolean isRetryable, int retryCount, String message, Throwable cause) {
        super(message, cause);
        this.isRetryable = isRetryable;
        this.retryCount = retryCount;
    }

    GoogleAuthException(boolean isRetryable, int retryCount, Throwable cause) {
        super(cause);
        this.isRetryable = isRetryable;
        this.retryCount = retryCount;
    }

    GoogleAuthException(boolean isRetryable, Throwable cause) {
        super(cause);
        this.isRetryable = isRetryable;
        this.retryCount = 0;
    }

    GoogleAuthException(Throwable cause) {
        this(false, cause);
    }

    GoogleAuthException() {
        this.isRetryable = false;
        this.retryCount = 0;
    }

    static GoogleAuthException createWithTokenEndpointResponseException(HttpResponseException responseException, String message) {
        int responseStatus = responseException.getStatusCode();
        boolean isRetryable = OAuth2Utils.TOKEN_ENDPOINT_RETRYABLE_STATUS_CODES.contains(responseStatus);
        int retryCount = responseException.getAttemptCount() - 1;
        if (message == null) {
            return new GoogleAuthException(isRetryable, retryCount, responseException);
        }
        return new GoogleAuthException(isRetryable, retryCount, message, responseException);
    }

    static GoogleAuthException createWithTokenEndpointResponseException(HttpResponseException responseException) {
        return GoogleAuthException.createWithTokenEndpointResponseException(responseException, null);
    }

    static GoogleAuthException createWithTokenEndpointIOException(IOException ioException, String message) {
        if (message == null) {
            return new GoogleAuthException(true, 3, ioException);
        }
        return new GoogleAuthException(true, 3, message, ioException);
    }

    static GoogleAuthException createWithTokenEndpointIOException(IOException ioException) {
        return GoogleAuthException.createWithTokenEndpointIOException(ioException, null);
    }

    @Override
    public boolean isRetryable() {
        return this.isRetryable;
    }

    @Override
    public int getRetryCount() {
        return this.retryCount;
    }
}

