/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.auth.oauth2;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

class MetricsUtils {
    static final String API_CLIENT_HEADER = "x-goog-api-client";
    private static final String authLibraryVersion = MetricsUtils.getAuthLibraryVersion();
    private static final String javaLanguageVersion = System.getProperty("java.version");

    MetricsUtils() {
    }

    static String getLanguageAndAuthLibraryVersions() {
        return String.format("gl-java/%s auth/%s", javaLanguageVersion, authLibraryVersion);
    }

    private static String getAuthLibraryVersion() {
        String version = "unknown-version";
        try (InputStream inputStream = MetricsUtils.class.getResourceAsStream("/com/google/bigtable/repackaged/com/google/auth/oauth2/google-auth-library.properties");){
            if (inputStream != null) {
                Properties properties = new Properties();
                properties.load(inputStream);
                version = properties.getProperty("google-auth-library.version");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return version;
    }
}

